/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xpickup.managers;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jn.willfrydev.xpickup.XPickup;
import jn.willfrydev.xpickup.managers.ConfigManager;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MessageManager {
    private final XPickup plugin;
    private final ConfigManager configManager;
    private final Pattern hexPattern = Pattern.compile("&#([a-fA-F0-9]{6})");

    public MessageManager(XPickup plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
    }

    public String colorize(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        Matcher matcher = this.hexPattern.matcher(text);
        StringBuffer buffer = new StringBuffer(text.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + '\u00a7' + group.charAt(1) + '\u00a7' + group.charAt(2) + '\u00a7' + group.charAt(3) + '\u00a7' + group.charAt(4) + '\u00a7' + group.charAt(5));
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }

    public void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(this.colorize(message));
    }

    public void sendPrefixedMessage(CommandSender sender, String messagePath) {
        String prefix = this.configManager.getMessage("prefix");
        String message = this.configManager.getMessage(messagePath);
        this.sendMessage(sender, prefix + message);
    }

    public void sendHelpMessage(CommandSender sender) {
        List<String> helpList = this.configManager.getHelpMessage();
        for (String line : helpList) {
            this.sendMessage(sender, line);
        }
    }

    public void handleFullInventoryMessages(Player player) {
        String message = this.configManager.getPrefixedMessage("inventory-full");
        if (this.configManager.useChatForFullInv()) {
            player.sendMessage(this.colorize(message));
        }
        if (this.configManager.useActionbarForFullInv()) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(this.colorize(message)));
        }
        if (this.configManager.isTitleForFullInvEnabled()) {
            this.sendFullInventoryTitle(player);
        }
    }

    private void sendFullInventoryTitle(Player player) {
        ConfigurationSection titleSection = this.plugin.getConfig().getConfigurationSection("inventory-full-message.title");
        if (titleSection == null) {
            return;
        }
        String title = this.colorize(titleSection.getString("title", ""));
        String subtitle = this.colorize(titleSection.getString("subtitle", ""));
        int fadeIn = titleSection.getInt("fade-in", 10);
        int stay = titleSection.getInt("stay", 40);
        int fadeOut = titleSection.getInt("fade-out", 10);
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }
}

