/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.config;

import amg.plugins.aMGShop.AMGShop;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final AMGShop plugin;
    private FileConfiguration config;
    private File configFile;
    private File logsFile;
    private FileConfiguration logs;
    private final Map<String, FileConfiguration> categoryConfigs;
    private final File shopsFolder;

    public ConfigManager(AMGShop plugin) {
        this.plugin = plugin;
        this.categoryConfigs = new HashMap<String, FileConfiguration>();
        this.shopsFolder = new File(plugin.getDataFolder(), "shops");
        this.setupConfig();
        this.setupLogs();
        this.setupShopsFolder();
    }

    private void setupConfig() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    private void setupLogs() {
        this.logsFile = new File(this.plugin.getDataFolder(), "logs.yml");
        if (!this.logsFile.exists()) {
            try {
                this.logsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not create logs.yml", e);
            }
        }
        this.logs = YamlConfiguration.loadConfiguration((File)this.logsFile);
    }

    private void setupShopsFolder() {
        if (!this.shopsFolder.exists()) {
            this.shopsFolder.mkdirs();
            this.saveResourceIfNotExists("blocks.yml");
            this.saveResourceIfNotExists("combat.yml");
            this.saveResourceIfNotExists("food.yml");
            this.saveResourceIfNotExists("tools.yml");
            this.saveResourceIfNotExists("redstone.yml");
            this.saveResourceIfNotExists("brewing.yml");
            this.saveResourceIfNotExists("decoration.yml");
            this.saveResourceIfNotExists("misc.yml");
        }
        this.loadCategoryFiles();
    }

    private void saveResourceIfNotExists(String fileName) {
        File file = new File(this.shopsFolder, fileName);
        if (!file.exists()) {
            this.plugin.saveResource("shops/" + fileName, false);
            this.plugin.getLogger().info("Created example category file: " + fileName);
        }
    }

    private void loadCategoryFiles() {
        this.categoryConfigs.clear();
        ConfigurationSection categoriesSection = this.config.getConfigurationSection("categories");
        if (categoriesSection != null) {
            for (String categoryId : categoriesSection.getKeys(false)) {
                String fileName = categoriesSection.getString(categoryId + ".file");
                if (fileName == null) continue;
                File categoryFile = new File(this.shopsFolder, fileName);
                if (categoryFile.exists()) {
                    YamlConfiguration categoryConfig = YamlConfiguration.loadConfiguration((File)categoryFile);
                    this.categoryConfigs.put(categoryId, (FileConfiguration)categoryConfig);
                    this.plugin.getLogger().info("Loaded category file: " + fileName);
                    continue;
                }
                this.plugin.getLogger().warning("Category file not found: " + fileName);
            }
        }
    }

    public void loadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.loadCategoryFiles();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getLogs() {
        return this.logs;
    }

    public Map<String, FileConfiguration> getCategoryConfigs() {
        return this.categoryConfigs;
    }

    public FileConfiguration getCategoryConfig(String categoryId) {
        return this.categoryConfigs.get(categoryId);
    }

    public void saveLogs() {
        try {
            this.logs.save(this.logsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save logs.yml", e);
        }
    }

    public void archiveLogs(String archivePath, String section) {
        File archiveDir = new File(this.plugin.getDataFolder(), "archives");
        if (!archiveDir.exists()) {
            archiveDir.mkdirs();
        }
        File archiveFile = new File(archiveDir, archivePath);
        YamlConfiguration archive = new YamlConfiguration();
        archive.set(section, this.logs.get(section));
        try {
            archive.save(archiveFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save archive file: " + archivePath, e);
        }
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.loadCategoryFiles();
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save config.yml", e);
        }
    }

    public void saveCategoryConfig(String categoryId) {
        String fileName;
        FileConfiguration categoryConfig = this.categoryConfigs.get(categoryId);
        if (categoryConfig != null && (fileName = this.config.getString("categories." + categoryId + ".file")) != null) {
            File categoryFile = new File(this.shopsFolder, fileName);
            try {
                categoryConfig.save(categoryFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save category file: " + fileName, e);
            }
        }
    }

    public void createCategoryConfig(String categoryId, String name, String icon, int slot) {
        String fileName = categoryId + ".yml";
        File categoryFile = new File(this.shopsFolder, fileName);
        YamlConfiguration categoryConfig = new YamlConfiguration();
        categoryConfig.set("name", (Object)name);
        categoryConfig.set("icon", (Object)icon);
        categoryConfig.set("slot", (Object)slot);
        categoryConfig.createSection("items");
        try {
            categoryConfig.save(categoryFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save new category file: " + fileName, e);
            return;
        }
        this.config.set("categories." + categoryId + ".file", (Object)fileName);
        this.saveConfig();
        this.categoryConfigs.put(categoryId, (FileConfiguration)categoryConfig);
    }
}

