/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.gui;

import amg.plugins.aMGShop.AMGShop;
import amg.plugins.aMGShop.managers.ShopManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SellGUI
implements Listener {
    private final AMGShop plugin;
    private final Map<Player, Inventory> sellMenus;
    private final int SELL_BUTTON_SLOT = 49;
    private final int INVENTORY_SIZE = 54;
    private final Map<Player, BukkitTask> updateTasks;

    public SellGUI(AMGShop plugin) {
        this.plugin = plugin;
        this.sellMenus = new HashMap<Player, Inventory>();
        this.updateTasks = new HashMap<Player, BukkitTask>();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openSellMenu(Player player) {
        Component title = ((TextComponent)Component.text((String)"Sell Items").color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false);
        Inventory menu = Bukkit.createInventory(null, (int)54, (Component)title);
        this.addBorder(menu);
        this.addSellButton(menu);
        player.openInventory(menu);
        this.sellMenus.put(player, menu);
        this.startPriceUpdates(player, menu);
    }

    private void startPriceUpdates(Player player, Inventory inventory) {
        this.stopPriceUpdates(player);
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (player.isOnline() && player.getOpenInventory().getTopInventory().equals((Object)inventory)) {
                this.updateSellValue(player, inventory);
            } else {
                this.stopPriceUpdates(player);
            }
        }, 5L, 5L);
        this.updateTasks.put(player, task);
    }

    private void stopPriceUpdates(Player player) {
        BukkitTask task = this.updateTasks.remove(player);
        if (task != null) {
            task.cancel();
        }
    }

    private void addBorder(Inventory inventory) {
        ItemStack border = this.createGlassPane();
        for (int i = 0; i < 9; ++i) {
            inventory.setItem(45 + i, border.clone());
        }
    }

    private ItemStack createGlassPane() {
        ItemStack pane = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta meta = pane.getItemMeta();
        meta.displayName((Component)Component.empty());
        pane.setItemMeta(meta);
        return pane;
    }

    private void addSellButton(Inventory inventory) {
        ItemStack sellButton = new ItemStack(Material.EMERALD);
        ItemMeta meta = sellButton.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)"Sell All Items").color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(((TextComponent)Component.text((String)"Place items in empty slots").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        lore.add(((TextComponent)Component.text((String)"to see their sell value").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        meta.lore(lore);
        sellButton.setItemMeta(meta);
        inventory.setItem(49, sellButton);
    }

    private void updateSellValue(Player player, Inventory inventory) {
        double totalValue = 0.0;
        HashMap<String, Map> itemsToSell = new HashMap<String, Map>();
        for (int i = 0; i < inventory.getSize(); ++i) {
            String[] categoryAndItem;
            ItemStack item;
            if (this.isBorderSlot(i) || i == 49 || (item = inventory.getItem(i)) == null || (categoryAndItem = this.findCategoryAndItem(item.getType())) == null) continue;
            String category = categoryAndItem[0];
            String itemId = categoryAndItem[1];
            itemsToSell.computeIfAbsent(category, k -> new HashMap());
            ((Map)itemsToSell.get(category)).merge(itemId, item.getAmount(), Integer::sum);
            double price = this.plugin.getShopManager().calculateSellPrice(category, itemId, item.getAmount());
            if (!(price > 0.0)) continue;
            totalValue += price;
        }
        this.updateSellButton(inventory, totalValue);
    }

    private void updateSellButton(Inventory inventory, double totalValue) {
        ItemStack sellButton = inventory.getItem(49);
        if (sellButton == null) {
            return;
        }
        ItemMeta meta = sellButton.getItemMeta();
        ArrayList<Object> lore = new ArrayList<Object>();
        if (totalValue > 0.0) {
            double taxAmount = this.plugin.getTaxManager().calculateSellTax(totalValue);
            double priceBeforeTax = totalValue + taxAmount;
            lore.add(((TextComponent)Component.text((String)String.format("Total Value: $%.2f", totalValue)).color((TextColor)NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false));
            if (this.plugin.getTaxManager().shouldShowTaxInLore()) {
                lore.add(((TextComponent)Component.text((String)String.format("Tax Deducted: $%.2f", taxAmount)).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
                lore.add(((TextComponent)Component.text((String)String.format("Value Before Tax: $%.2f", priceBeforeTax)).color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
            }
            lore.add(Component.empty());
            lore.add(((TextComponent)Component.text((String)"Click to sell all items").color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
        } else {
            lore.add(((TextComponent)Component.text((String)"Place items in empty slots").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
            lore.add(((TextComponent)Component.text((String)"to see their sell value").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        }
        meta.lore(lore);
        sellButton.setItemMeta(meta);
    }

    private void debug(String message) {
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            this.plugin.getLogger().info("[Debug] " + message);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory inventory = event.getInventory();
        if (!this.sellMenus.containsValue(inventory)) {
            return;
        }
        if (event.getRawSlot() == 49) {
            event.setCancelled(true);
            this.debug("Sell button clicked");
            this.handleSellAll(player, inventory);
            return;
        }
        if (this.isBorderSlot(event.getRawSlot())) {
            event.setCancelled(true);
            return;
        }
        if (event.getRawSlot() >= 0 && event.getRawSlot() < 54) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.updateSellValue(player, inventory), 1L);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!this.sellMenus.containsValue(event.getInventory())) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot >= 54 || !this.isBorderSlot(slot) && slot != 49) continue;
            event.setCancelled(true);
            return;
        }
    }

    private void handleSellAll(Player player, Inventory inventory) {
        HashMap<String, Map> itemsToSell = new HashMap<String, Map>();
        double totalValue = 0.0;
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(player.getName()).append(" sold: ");
        for (int i = 0; i < inventory.getSize(); ++i) {
            String[] categoryAndItem;
            ItemStack item;
            if (this.isBorderSlot(i) || i == 49 || (item = inventory.getItem(i)) == null || (categoryAndItem = this.findCategoryAndItem(item.getType())) == null) continue;
            String category = categoryAndItem[0];
            String itemId = categoryAndItem[1];
            itemsToSell.computeIfAbsent(category, k -> new HashMap());
            ((Map)itemsToSell.get(category)).merge(itemId, item.getAmount(), Integer::sum);
        }
        this.debug("Items to sell: " + itemsToSell.size() + " categories");
        for (Map.Entry categoryEntry : itemsToSell.entrySet()) {
            String category = (String)categoryEntry.getKey();
            this.debug("Processing category: " + category + " with " + ((Map)categoryEntry.getValue()).size() + " items");
            for (Map.Entry itemEntry : ((Map)categoryEntry.getValue()).entrySet()) {
                String itemId = (String)itemEntry.getKey();
                int amount = (Integer)itemEntry.getValue();
                this.debug("Selling item: " + itemId + " x" + amount);
                Material material = null;
                for (ShopManager.ShopItem shopItem : this.plugin.getShopManager().getCategories().get(category).values()) {
                    if (!shopItem.getMaterial().name().equalsIgnoreCase(itemId) && !itemId.equalsIgnoreCase(shopItem.getMaterial().name())) continue;
                    material = shopItem.getMaterial();
                    break;
                }
                if (material == null) {
                    this.debug("Material not found for item: " + itemId);
                    continue;
                }
                double price = this.plugin.getShopManager().calculateSellPrice(category, itemId, amount);
                this.debug("Calculated price: $" + String.format("%.2f", price) + " for " + amount + " items");
                if (!this.hasEnoughItems(player, material, amount)) {
                    String message = this.plugin.getConfig().getString("messages.not_enough_items", "&c&lError: &fYou don't have enough items to sell!");
                    player.sendMessage(this.formatMessage(message));
                    continue;
                }
                this.removeItems(inventory, material, amount);
                Object playerData = this.plugin.getShopManager().getPlayerData(player);
                if (playerData == null) continue;
                double money = this.plugin.getShopManager().getPlayerMoney(playerData);
                this.plugin.getShopManager().setPlayerMoney(playerData, money + price);
                int currentStock = this.plugin.getDatabaseManager().getStock(category, itemId);
                this.plugin.getDatabaseManager().updateStock(category, itemId, currentStock + amount);
                this.plugin.getShopManager().calculateBuyPrice(category, itemId, 1);
                this.plugin.getShopManager().calculateSellPrice(category, itemId, 1);
                double taxAmount = this.plugin.getTaxManager().calculateSellTax(price);
                this.plugin.getTaxManager().addTax(taxAmount);
                totalValue += price;
                logMessage.append(amount).append("x ").append(itemId.toLowerCase()).append(" ($").append(String.format("%.2f", price)).append("), ");
            }
        }
        if (totalValue > 0.0) {
            AMGShop amgShop;
            logMessage.setLength(logMessage.length() - 2);
            logMessage.append(" - Total: $").append(String.format("%.2f", totalValue));
            this.plugin.getLogManager().logSale(player, "BULK_SALE", logMessage.toString(), 1, totalValue, 0.0, 0.0);
            String message = this.plugin.getConfig().getString("messages.items_sold_bulk", "&a&lSuccess! &fYou sold items for &e$%price%").replace("%price%", String.format("%.2f", totalValue));
            player.sendMessage(this.formatMessage(message));
            player.updateInventory();
            AMGShop aMGShop = this.plugin;
            if (aMGShop instanceof AMGShop && (amgShop = aMGShop).getShopGUI() != null) {
                amgShop.getShopGUI().refreshCategoryMenus();
            }
        } else {
            player.sendMessage(this.formatMessage("&c&lError: &fNo items were sold."));
        }
        this.updateSellValue(player, inventory);
    }

    private String formatMessage(String message) {
        return message.replace("&", "\u00a7");
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.sellMenus.containsValue(event.getInventory())) {
            return;
        }
        this.stopPriceUpdates(player);
        Inventory inventory = event.getInventory();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item;
            if (this.isBorderSlot(i) || i == 49 || (item = inventory.getItem(i)) == null) continue;
            ItemStack cleanItem = new ItemStack(item.getType(), item.getAmount());
            if (!item.getEnchantments().isEmpty()) {
                cleanItem.addEnchantments(item.getEnchantments());
            }
            player.getInventory().addItem(new ItemStack[]{cleanItem});
        }
        this.sellMenus.remove(player);
    }

    private boolean isBorderSlot(int slot) {
        int row = slot / 9;
        return row == 5;
    }

    private String[] findCategoryAndItem(Material material) {
        Map<String, Map<String, ShopManager.ShopItem>> categories = this.plugin.getShopManager().getCategories();
        for (Map.Entry<String, Map<String, ShopManager.ShopItem>> category : categories.entrySet()) {
            for (Map.Entry<String, ShopManager.ShopItem> item : category.getValue().entrySet()) {
                if (item.getValue().getMaterial() != material) continue;
                return new String[]{category.getKey(), item.getKey()};
            }
        }
        return null;
    }

    private void removeItems(Inventory inventory, Material material, int amount) {
        int remaining = amount;
        for (int i = 0; i < inventory.getSize() && remaining > 0; ++i) {
            ItemStack item;
            if (this.isBorderSlot(i) || i == 49 || (item = inventory.getItem(i)) == null || item.getType() != material) continue;
            if (item.getAmount() <= remaining) {
                remaining -= item.getAmount();
                inventory.setItem(i, null);
                continue;
            }
            ItemStack newItem = new ItemStack(material, item.getAmount() - remaining);
            inventory.setItem(i, newItem);
            remaining = 0;
        }
    }

    private boolean hasEnoughItems(Player player, Material material, int amount) {
        int count = 0;
        Inventory inventory = this.sellMenus.get(player);
        if (inventory == null) {
            return false;
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() != material) continue;
            count += item.getAmount();
        }
        return count >= amount;
    }
}

