/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.listeners;

import amg.plugins.aMGShop.AMGShop;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;

public class NPCListener
implements Listener {
    private final AMGShop plugin;

    public NPCListener(AMGShop plugin) {
        this.plugin = plugin;
    }

    private void debug(String message) {
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            this.plugin.getLogger().info("[Debug] " + message);
        }
    }

    @EventHandler
    public void onEntityInteract(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Entity clickedEntity = event.getRightClicked();
        if (!(clickedEntity instanceof Villager)) {
            return;
        }
        if (!this.plugin.getNPCManager().isShopNPC(clickedEntity)) {
            return;
        }
        String npcType = this.plugin.getNPCManager().getNPCTypeFromEntity(clickedEntity);
        this.debug("Shop NPC clicked: Player=" + player.getName() + ", Type=" + npcType);
        if (npcType == null) {
            return;
        }
        event.setCancelled(true);
        if (!player.hasPermission("amgshop.use")) {
            player.sendMessage(this.plugin.getConfig().getString("messages.no_permission", "\u00a7cYou don't have permission to do that!"));
            this.debug("Player " + player.getName() + " doesn't have permission to use shop");
            return;
        }
        switch (npcType) {
            case "buy": {
                this.debug("Opening buy menu for " + player.getName());
                this.plugin.getShopGUI().openBuyMenu(player);
                break;
            }
            case "sell": {
                this.debug("Opening sell menu for " + player.getName());
                this.plugin.getShopGUI().openSellMenu(player);
            }
        }
    }
}

