/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.managers;

import amg.plugins.aMGShop.AMGShop;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class InflationManager {
    private final AMGShop plugin;
    private final boolean enabled;
    private double inflationRate;
    private BukkitTask updateTask;

    public InflationManager(AMGShop plugin) {
        this.plugin = plugin;
        this.enabled = plugin.getConfig().getBoolean("shop.inflation.enabled", true);
        this.inflationRate = plugin.getConfig().getDouble("shop.inflation.rate", 5.0);
        if (this.enabled) {
            this.startUpdateTask();
        }
    }

    private void startUpdateTask() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        long updateInterval = this.plugin.getConfig().getLong("shop.inflation.update_interval", 60L) * 20L * 60L;
        this.updateTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, this::updateInflation, updateInterval, updateInterval);
    }

    public void stopUpdateTask() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
    }

    private void updateInflation() {
        this.inflationRate = this.plugin.getConfig().getDouble("shop.inflation.rate", 5.0);
        this.plugin.getLogger().info("Updated inflation rate: " + this.inflationRate + "%");
    }

    public double getInflationMultiplier() {
        if (!this.enabled) {
            return 1.0;
        }
        double inflationMultiplier = 1.0 + this.inflationRate / 100.0;
        return inflationMultiplier;
    }

    public double getBuyPriceMultiplier() {
        if (!this.enabled) {
            return 1.0;
        }
        return this.getInflationMultiplier();
    }

    public double getSellPriceMultiplier() {
        if (!this.enabled) {
            return 1.0;
        }
        double inflationMultiplier = this.getInflationMultiplier();
        return 1.0 / inflationMultiplier;
    }

    public double getInflationRate() {
        return this.inflationRate;
    }
}

