/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.managers;

import amg.plugins.aMGShop.AMGShop;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class LogManager {
    private final AMGShop plugin;
    private final DateTimeFormatter formatter;
    private static final int MAX_LOGS_PER_FILE = 1000;

    public LogManager(AMGShop plugin) {
        this.plugin = plugin;
        this.formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    }

    public String getCurrentTime() {
        return LocalDateTime.now().format(this.formatter);
    }

    public void logPurchase(Player player, String category, String itemId, int amount, double price, double oldStock, double newStock) {
        String time = this.getCurrentTime();
        FileConfiguration logs = this.plugin.getConfigManager().getLogs();
        String path = "transactions." + time.replace(":", "-");
        String message = String.format("%s bought %dx %s for $%.2f - %s", player.getName(), amount, itemId.toLowerCase(), price, time);
        logs.set(path, (Object)message);
        this.checkAndRotateLogs();
        this.plugin.getConfigManager().saveLogs();
    }

    public void logSale(Player player, String category, String itemId, int amount, double pricePerItem, double oldStock, double newStock) {
        String time = this.getCurrentTime();
        FileConfiguration logs = this.plugin.getConfigManager().getLogs();
        String path = "transactions." + time.replace(":", "-");
        double totalPrice = pricePerItem * (double)amount;
        String message = String.format("%s sold %dx %s for $%.2f total ($%.2f each) - %s", player.getName(), amount, itemId.toLowerCase(), totalPrice, pricePerItem, time);
        logs.set(path, (Object)message);
        this.checkAndRotateLogs();
        this.plugin.getConfigManager().saveLogs();
    }

    private void checkAndRotateLogs() {
        ArrayList transactions;
        FileConfiguration logs = this.plugin.getConfigManager().getLogs();
        if (logs.getConfigurationSection("transactions") != null && (transactions = new ArrayList(logs.getConfigurationSection("transactions").getKeys(false))).size() >= 1000) {
            String archiveDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            String archivePath = "archives/transactions_" + archiveDate + "_" + System.currentTimeMillis() + ".yml";
            this.plugin.getConfigManager().archiveLogs(archivePath, "transactions");
            logs.set("transactions", null);
        }
    }
}

