/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.managers;

import amg.plugins.aMGShop.AMGShop;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class NPCManager
implements Listener {
    private final AMGShop plugin;
    private final Map<UUID, String> npcTypes;
    private Villager buyNPC;
    private Villager sellNPC;
    private final NamespacedKey npcTypeKey;
    private static final int NAMETAG_VISIBILITY_DISTANCE = 5;

    public NPCManager(AMGShop plugin) {
        this.plugin = plugin;
        this.npcTypes = new HashMap<UUID, String>();
        this.npcTypeKey = new NamespacedKey((Plugin)plugin, "npc_type");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void debug(String message) {
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            this.plugin.getLogger().info("[Debug] " + message);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (this.isShopNPC(event.getEntity())) {
            event.setCancelled(true);
            this.debug("Cancelled damage to shop NPC: " + String.valueOf(event.getEntity().getUniqueId()));
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        for (Entity entity : event.getChunk().getEntities()) {
            if (!this.isShopNPC(entity)) continue;
            entity.setPersistent(true);
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                Location loc = villager.getLocation();
                if (entity.equals((Object)this.buyNPC)) {
                    this.saveLocationToConfig("npcs.buy", loc);
                } else if (entity.equals((Object)this.sellNPC)) {
                    this.saveLocationToConfig("npcs.sell", loc);
                }
            }
            this.debug("Made shop NPC persistent during chunk unload: " + String.valueOf(entity.getUniqueId()));
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            NPCManager nPCManager = this;
            synchronized (nPCManager) {
                Villager.Profession profession;
                Villager.Type villagerType;
                String name;
                Location buyLoc = this.getLocationFromConfig("npcs.buy");
                Location sellLoc = this.getLocationFromConfig("npcs.sell");
                if (buyLoc != null && buyLoc.getChunk().equals((Object)event.getChunk()) && (this.buyNPC == null || !this.buyNPC.isValid())) {
                    name = this.plugin.getConfig().getString("npcs.buy.name", "&6Shop Keeper").replace("&", "\u00a7");
                    villagerType = this.getVillagerType(this.plugin.getConfig().getString("npcs.buy.villager_type", "PLAINS"));
                    profession = this.getVillagerProfession(this.plugin.getConfig().getString("npcs.buy.profession", "LIBRARIAN"));
                    this.buyNPC = this.createNPC(buyLoc, name, "buy", villagerType, profession);
                    this.debug("Respawned Buy NPC in loaded chunk at " + this.formatLocation(buyLoc));
                }
                if (sellLoc != null && sellLoc.getChunk().equals((Object)event.getChunk()) && (this.sellNPC == null || !this.sellNPC.isValid())) {
                    name = this.plugin.getConfig().getString("npcs.sell.name", "&eMerchant").replace("&", "\u00a7");
                    villagerType = this.getVillagerType(this.plugin.getConfig().getString("npcs.sell.villager_type", "DESERT"));
                    profession = this.getVillagerProfession(this.plugin.getConfig().getString("npcs.sell.profession", "MASON"));
                    this.sellNPC = this.createNPC(sellLoc, name, "sell", villagerType, profession);
                    this.debug("Respawned Sell NPC in loaded chunk at " + this.formatLocation(sellLoc));
                }
            }
        });
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (event.getFrom().distanceSquared(event.getTo()) < 4.0) {
            return;
        }
        this.updateNametagVisibilityForPlayer(player);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.updateNametagVisibilityForPlayer(player);
            this.debug("Updated nametag visibility for joining player: " + player.getName());
        }, 20L);
    }

    private void updateNametagVisibilityForPlayer(Player player) {
        boolean isClose;
        if (this.plugin.getConfig().getBoolean("npcs.hide_nametag", false)) {
            return;
        }
        if (this.buyNPC != null && this.buyNPC.isValid()) {
            isClose = player.getLocation().distance(this.buyNPC.getLocation()) <= 5.0;
            this.buyNPC.setCustomNameVisible(isClose);
            this.debug("Buy NPC nametag visibility for " + player.getName() + ": " + isClose);
        }
        if (this.sellNPC != null && this.sellNPC.isValid()) {
            isClose = player.getLocation().distance(this.sellNPC.getLocation()) <= 5.0;
            this.sellNPC.setCustomNameVisible(isClose);
            this.debug("Sell NPC nametag visibility for " + player.getName() + ": " + isClose);
        }
    }

    public void loadNPCs() {
        Villager.Profession profession;
        Villager.Type villagerType;
        String name;
        Object location;
        try {
            this.removeNPCs();
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    if (!(entity instanceof Villager) || !this.isShopNPC(entity)) continue;
                    entity.remove();
                    this.debug("Removed leftover shop NPC: " + String.valueOf(entity.getUniqueId()));
                }
            }
            if (this.plugin.getConfig().contains("npcs.buy.location")) {
                location = this.getLocationFromConfig("npcs.buy");
                if (location != null && location.getWorld() != null) {
                    if (!location.getChunk().isLoaded()) {
                        location.getChunk().load();
                        this.debug("Loaded chunk for Buy NPC at " + this.formatLocation((Location)location));
                    }
                    name = this.plugin.getConfig().getString("npcs.buy.name", "&6Shop Keeper").replace("&", "\u00a7");
                    villagerType = this.getVillagerType(this.plugin.getConfig().getString("npcs.buy.villager_type", "PLAINS"));
                    profession = this.getVillagerProfession(this.plugin.getConfig().getString("npcs.buy.profession", "LIBRARIAN"));
                    this.buyNPC = this.createNPC((Location)location, name, "buy", villagerType, profession);
                    this.debug("Loaded Buy NPC at " + this.formatLocation((Location)location));
                } else {
                    this.plugin.getLogger().warning("Failed to load Buy NPC - Invalid location or world");
                }
            }
            if (this.plugin.getConfig().contains("npcs.sell.location")) {
                location = this.getLocationFromConfig("npcs.sell");
                if (location != null && location.getWorld() != null) {
                    if (!location.getChunk().isLoaded()) {
                        location.getChunk().load();
                        this.debug("Loaded chunk for Sell NPC at " + this.formatLocation((Location)location));
                    }
                    name = this.plugin.getConfig().getString("npcs.sell.name", "&eMerchant").replace("&", "\u00a7");
                    villagerType = this.getVillagerType(this.plugin.getConfig().getString("npcs.sell.villager_type", "DESERT"));
                    profession = this.getVillagerProfession(this.plugin.getConfig().getString("npcs.sell.profession", "MASON"));
                    this.sellNPC = this.createNPC((Location)location, name, "sell", villagerType, profession);
                    this.debug("Loaded Sell NPC at " + this.formatLocation((Location)location));
                } else {
                    this.plugin.getLogger().warning("Failed to load Sell NPC - Invalid location or world");
                }
            }
            location = Bukkit.getOnlinePlayers().iterator();
            while (location.hasNext()) {
                Player player = (Player)location.next();
                this.updateNametagVisibilityForPlayer(player);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading NPCs: " + e.getMessage());
            e.printStackTrace();
        }
        if (this.plugin.getConfig().contains("npcs.sell.location") && (location = this.getLocationFromConfig("npcs.sell")) != null) {
            name = this.plugin.getConfig().getString("npcs.sell.name", "&eMerchant").replace("&", "\u00a7");
            villagerType = this.getVillagerType(this.plugin.getConfig().getString("npcs.sell.villager_type", "DESERT"));
            profession = this.getVillagerProfession(this.plugin.getConfig().getString("npcs.sell.profession", "MASON"));
            this.sellNPC = this.createNPC((Location)location, name, "sell", villagerType, profession);
            this.debug("Loaded Sell NPC at " + this.formatLocation((Location)location));
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updateNametagVisibilityForPlayer(player);
        }
    }

    public void createBuyNPC(Location location) {
        if (this.buyNPC != null) {
            this.buyNPC.remove();
            this.buyNPC = null;
            this.debug("Removed old Buy NPC");
        }
        String name = this.plugin.getConfig().getString("npcs.buy.name", "&6Shop Keeper").replace("&", "\u00a7");
        Villager.Type villagerType = this.getVillagerType(this.plugin.getConfig().getString("npcs.buy.villager_type", "PLAINS"));
        Villager.Profession profession = this.getVillagerProfession(this.plugin.getConfig().getString("npcs.buy.profession", "LIBRARIAN"));
        this.buyNPC = this.createNPC(location, name, "buy", villagerType, profession);
        this.saveLocationToConfig("npcs.buy", location);
        this.debug("Created Buy NPC at " + this.formatLocation(location));
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updateNametagVisibilityForPlayer(player);
        }
    }

    public void createSellNPC(Location location) {
        if (this.sellNPC != null) {
            this.sellNPC.remove();
            this.sellNPC = null;
            this.debug("Removed old Sell NPC");
        }
        String name = this.plugin.getConfig().getString("npcs.sell.name", "&eMerchant").replace("&", "\u00a7");
        Villager.Type villagerType = this.getVillagerType(this.plugin.getConfig().getString("npcs.sell.villager_type", "DESERT"));
        Villager.Profession profession = this.getVillagerProfession(this.plugin.getConfig().getString("npcs.sell.profession", "MASON"));
        this.sellNPC = this.createNPC(location, name, "sell", villagerType, profession);
        this.saveLocationToConfig("npcs.sell", location);
        this.debug("Created Sell NPC at " + this.formatLocation(location));
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updateNametagVisibilityForPlayer(player);
        }
    }

    private Villager createNPC(Location location, String name, String type, Villager.Type villagerType, Villager.Profession profession) {
        if (!location.getChunk().isLoaded()) {
            location.getChunk().load();
        }
        location.getWorld().getNearbyEntities(location, 1.0, 1.0, 1.0).forEach(entity -> {
            if (entity instanceof Villager && this.isShopNPC((Entity)entity)) {
                entity.remove();
                this.debug("Removed duplicate NPC at spawn location: " + String.valueOf(entity.getUniqueId()));
            }
        });
        Villager npc = (Villager)location.getWorld().spawnEntity(location, EntityType.VILLAGER);
        npc.customName((Component)Component.text((String)name));
        npc.setCustomNameVisible(false);
        npc.setAI(false);
        npc.setInvulnerable(true);
        npc.setSilent(true);
        npc.setVillagerType(villagerType);
        npc.setProfession(profession);
        npc.setVillagerLevel(5);
        npc.setPersistent(true);
        npc.setRemoveWhenFarAway(false);
        npc.setCollidable(false);
        npc.teleport(location);
        PersistentDataContainer pdc = npc.getPersistentDataContainer();
        pdc.set(this.npcTypeKey, PersistentDataType.STRING, (Object)type);
        this.npcTypes.put(npc.getUniqueId(), type);
        this.debug("Created " + type + " NPC with ID: " + String.valueOf(npc.getUniqueId()));
        return npc;
    }

    private void saveLocationToConfig(String path, Location location) {
        this.plugin.getConfig().set(path + ".location.world", (Object)location.getWorld().getName());
        this.plugin.getConfig().set(path + ".location.x", (Object)location.getX());
        this.plugin.getConfig().set(path + ".location.y", (Object)location.getY());
        this.plugin.getConfig().set(path + ".location.z", (Object)location.getZ());
        this.plugin.getConfig().set(path + ".location.yaw", (Object)Float.valueOf(location.getYaw()));
        this.plugin.getConfig().set(path + ".location.pitch", (Object)Float.valueOf(location.getPitch()));
        this.plugin.saveConfig();
        this.debug("Saved location to config: " + path);
    }

    private Location getLocationFromConfig(String path) {
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection(path + ".location");
        if (section == null) {
            return null;
        }
        String worldName = section.getString("world");
        if (worldName == null) {
            return null;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return null;
        }
        double x = section.getDouble("x");
        double y = section.getDouble("y");
        double z = section.getDouble("z");
        float yaw = (float)section.getDouble("yaw");
        float pitch = (float)section.getDouble("pitch");
        Location location = new Location(world, x, y, z, yaw, pitch);
        this.debug("Loaded location from config: " + path + " = " + this.formatLocation(location));
        return location;
    }

    private String formatLocation(Location location) {
        return String.format("(World: %s, X: %.2f, Y: %.2f, Z: %.2f)", location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }

    private Villager.Type getVillagerType(String typeName) {
        try {
            return Villager.Type.valueOf((String)typeName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.debug("Invalid villager type: " + typeName + ", using PLAINS instead");
            return Villager.Type.PLAINS;
        }
    }

    private Villager.Profession getVillagerProfession(String professionName) {
        try {
            return Villager.Profession.valueOf((String)professionName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.debug("Invalid villager profession: " + professionName + ", using LIBRARIAN instead");
            return Villager.Profession.LIBRARIAN;
        }
    }

    public String getNPCType(UUID npcUUID) {
        return this.npcTypes.get(npcUUID);
    }

    public boolean isShopNPC(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (this.npcTypes.containsKey(entity.getUniqueId())) {
            return true;
        }
        if (entity instanceof Villager) {
            PersistentDataContainer pdc = entity.getPersistentDataContainer();
            return pdc.has(this.npcTypeKey, PersistentDataType.STRING);
        }
        return false;
    }

    public String getNPCTypeFromEntity(Entity entity) {
        PersistentDataContainer pdc;
        if (entity == null) {
            return null;
        }
        String type = this.npcTypes.get(entity.getUniqueId());
        if (type != null) {
            return type;
        }
        if (entity instanceof Villager && (pdc = entity.getPersistentDataContainer()).has(this.npcTypeKey, PersistentDataType.STRING)) {
            return (String)pdc.get(this.npcTypeKey, PersistentDataType.STRING);
        }
        return null;
    }

    public void removeNPCs() {
        if (this.buyNPC != null) {
            this.buyNPC.remove();
            this.buyNPC = null;
            this.debug("Removed Buy NPC");
        }
        if (this.sellNPC != null) {
            this.sellNPC.remove();
            this.sellNPC = null;
            this.debug("Removed Sell NPC");
        }
        this.npcTypes.clear();
    }

    public void updateNameTagVisibility() {
        boolean hideNametag = this.plugin.getConfig().getBoolean("npcs.hide_nametag", false);
        this.debug("Updating nametag visibility, hide_nametag=" + hideNametag);
        if (hideNametag) {
            if (this.buyNPC != null) {
                this.buyNPC.setCustomNameVisible(false);
            }
            if (this.sellNPC != null) {
                this.sellNPC.setCustomNameVisible(false);
            }
        } else {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.updateNametagVisibilityForPlayer(player);
            }
        }
    }
}

