/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.managers;

import amg.plugins.aMGShop.AMGShop;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ShopManager {
    private final AMGShop plugin;
    private final Map<String, Map<String, ShopItem>> categories;
    private final boolean priceFluctuationEnabled;
    private final double priceSensitivity;

    public ShopManager(AMGShop plugin) {
        this.plugin = plugin;
        this.categories = new HashMap<String, Map<String, ShopItem>>();
        ConfigurationSection fluctuation = plugin.getConfig().getConfigurationSection("shop.price_fluctuation");
        this.priceFluctuationEnabled = fluctuation.getBoolean("enabled", true);
        double sensitivity = fluctuation.getDouble("sensitivity", 5.0);
        this.priceSensitivity = Math.max(1.0, Math.min(10.0, sensitivity));
    }

    public Object getPlayerData(Player player) {
        try {
            Plugin amgCore = this.plugin.getServer().getPluginManager().getPlugin("AMGCore");
            if (amgCore == null) {
                this.plugin.getLogger().severe("AMGCore plugin not found!");
                return null;
            }
            Method getPlayerDataManager = amgCore.getClass().getMethod("getPlayerDataManager", new Class[0]);
            Object playerDataManager = getPlayerDataManager.invoke((Object)amgCore, new Object[0]);
            Method getPlayerData = playerDataManager.getClass().getMethod("getPlayerData", Player.class);
            return getPlayerData.invoke(playerDataManager, player);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to get player data using reflection", e);
            return null;
        }
    }

    public double getPlayerMoney(Object playerData) {
        try {
            Method getMoney = playerData.getClass().getMethod("getMoney", new Class[0]);
            return (Double)getMoney.invoke(playerData, new Object[0]);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to get player money using reflection", e);
            return 0.0;
        }
    }

    public void setPlayerMoney(Object playerData, double amount) {
        try {
            Method setMoney = playerData.getClass().getMethod("setMoney", Double.TYPE);
            setMoney.invoke(playerData, amount);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to set player money using reflection", e);
        }
    }

    public void loadShops() {
        this.categories.clear();
        ConfigurationSection categoriesSection = this.plugin.getConfig().getConfigurationSection("categories");
        if (categoriesSection == null) {
            this.plugin.getLogger().warning("No categories found in config!");
            return;
        }
        for (String categoryId : categoriesSection.getKeys(false)) {
            HashMap<String, ShopItem> items = new HashMap<String, ShopItem>();
            FileConfiguration categoryConfig = this.plugin.getConfigManager().getCategoryConfig(categoryId);
            if (categoryConfig == null) {
                this.plugin.getLogger().warning("Category config not found for: " + categoryId);
                continue;
            }
            ConfigurationSection itemsSection = categoryConfig.getConfigurationSection("items");
            if (itemsSection != null) {
                for (String itemId : itemsSection.getKeys(false)) {
                    ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemId);
                    Material material = Material.valueOf((String)itemSection.getString("material"));
                    double buyPrice = itemSection.getDouble("buy_price");
                    double sellPrice = itemSection.getDouble("sell_price");
                    int initialStock = itemSection.getInt("initial_stock");
                    int maxStock = itemSection.getInt("max_stock");
                    ShopItem item = new ShopItem(categoryId, itemId, material, buyPrice, sellPrice, maxStock);
                    items.put(itemId, item);
                    this.plugin.getDatabaseManager().initializeItem(categoryId, itemId, initialStock, buyPrice, sellPrice);
                }
            }
            this.categories.put(categoryId, items);
            this.plugin.getLogger().info("Loaded category: " + categoryId + " with " + items.size() + " items");
        }
    }

    private double calculatePriceMultiplier(int currentStock, int maxStock) {
        double stockPercentage = (double)currentStock / (double)maxStock * 100.0;
        double maxMultiplier = 1.0 + this.priceSensitivity * 0.3;
        double minMultiplier = 1.0 / (1.0 + this.priceSensitivity * 0.15);
        double curve = 1.0 + this.priceSensitivity * 0.1;
        double multiplier = maxMultiplier * Math.exp(-curve * (stockPercentage / 100.0)) + minMultiplier;
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            this.plugin.getLogger().info(String.format("[Debug] Price multiplier calculation: Stock=%d/%d (%.1f%%), Sensitivity=%.1f, Range=%.2f-%.2f, Curve=%.1f, Final=%.2f", currentStock, maxStock, stockPercentage, this.priceSensitivity, maxMultiplier, minMultiplier, curve, multiplier));
        }
        return multiplier;
    }

    public double calculateBuyPrice(String category, String itemId, int amount) {
        ShopItem item = this.getItem(category, itemId);
        if (item == null) {
            return -1.0;
        }
        double[] currentPrices = this.plugin.getDatabaseManager().getCurrentPrices(category, itemId);
        if (currentPrices == null) {
            return -1.0;
        }
        double basePrice = item.getBuyPrice() * (double)amount;
        int currentStock = this.plugin.getDatabaseManager().getStock(category, itemId);
        if (this.priceFluctuationEnabled) {
            double stockMultiplier = this.calculatePriceMultiplier(currentStock, item.getMaxStock());
            basePrice *= stockMultiplier;
            if (this.plugin.getConfig().getBoolean("debug", false)) {
                this.plugin.getLogger().info(String.format("[Debug] Buy price calculation for %s: Base=%.2f, Stock=%d/%d (%.1f%%), Multiplier=%.2f, Final=%.2f", itemId, item.getBuyPrice(), currentStock, item.getMaxStock(), (double)currentStock / (double)item.getMaxStock() * 100.0, stockMultiplier, basePrice));
            }
        }
        if (Math.abs(currentPrices[0] - (basePrice = (basePrice *= this.plugin.getInflationManager().getBuyPriceMultiplier()) < 0.01 ? 0.01 : (double)Math.round(basePrice * 100.0) / 100.0) / (double)amount) > 0.01) {
            double newBuyPrice = (double)Math.round(basePrice / (double)amount * 100.0) / 100.0;
            double newSellPrice = this.calculateSellPrice(category, itemId, 1);
            this.plugin.getDatabaseManager().updatePrices(category, itemId, newBuyPrice, newSellPrice);
        }
        return basePrice;
    }

    public double calculateSellPrice(String category, String itemId, int amount) {
        ShopItem item = this.getItem(category, itemId);
        if (item == null) {
            return -1.0;
        }
        double[] currentPrices = this.plugin.getDatabaseManager().getCurrentPrices(category, itemId);
        if (currentPrices == null) {
            return -1.0;
        }
        double basePrice = item.getSellPrice() * (double)amount;
        int currentStock = this.plugin.getDatabaseManager().getStock(category, itemId);
        if (this.priceFluctuationEnabled) {
            double stockMultiplier = this.calculatePriceMultiplier(currentStock, item.getMaxStock());
            basePrice *= stockMultiplier;
            if (this.plugin.getConfig().getBoolean("debug", false)) {
                this.plugin.getLogger().info(String.format("[Debug] Sell price calculation for %s: Base=%.2f, Stock=%d/%d (%.1f%%), Multiplier=%.2f, Final=%.2f", itemId, item.getSellPrice(), currentStock, item.getMaxStock(), (double)currentStock / (double)item.getMaxStock() * 100.0, stockMultiplier, basePrice));
            }
        }
        basePrice *= this.plugin.getInflationManager().getSellPriceMultiplier();
        basePrice = (basePrice *= this.plugin.getTaxManager().getSellPriceMultiplier()) < 0.01 ? 0.01 : (double)Math.round(basePrice * 100.0) / 100.0;
        return basePrice;
    }

    public boolean buyItem(Player player, String categoryId, String itemId, int quantity) {
        ShopItem item = this.categories.get(categoryId).get(itemId);
        if (item == null) {
            return false;
        }
        int currentStock = this.plugin.getDatabaseManager().getStock(categoryId, itemId);
        if (currentStock < quantity) {
            player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("transaction.not_enough_stock")));
            return false;
        }
        if (!this.hasEnoughSpace(player, item.getMaterial(), quantity)) {
            player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("transaction.inventory_full")));
            return false;
        }
        double basePrice = this.calculateBuyPrice(categoryId, itemId, quantity);
        double tax = this.plugin.getTaxManager().calculateBuyTax(basePrice);
        double totalPrice = basePrice;
        Object playerData = this.getPlayerData(player);
        if (playerData == null) {
            return false;
        }
        double playerMoney = this.getPlayerMoney(playerData);
        if (playerMoney < totalPrice) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("price", String.format("%.2f", basePrice));
            placeholders.put("tax", String.format("%.2f", tax));
            player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("transaction.not_enough_money", placeholders)));
            return false;
        }
        this.plugin.getDatabaseManager().updateStock(categoryId, itemId, currentStock - quantity);
        this.setPlayerMoney(playerData, playerMoney - totalPrice);
        this.plugin.getTaxManager().addTax(tax);
        ItemStack boughtItem = new ItemStack(item.getMaterial(), quantity);
        player.getInventory().addItem(new ItemStack[]{boughtItem});
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("amount", String.valueOf(quantity));
        placeholders.put("item", item.getMaterial().name());
        placeholders.put("price", String.format("%.2f", basePrice));
        placeholders.put("tax", String.format("%.2f", tax));
        player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("transaction.item_bought", placeholders)));
        return true;
    }

    public boolean sellItem(Player player, ItemStack item, int quantity) {
        ShopItem shopItem = this.findShopItem(item.getType());
        if (shopItem == null) {
            player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.not_in_shop")));
            return false;
        }
        if (!this.hasEnoughItems(player, item.getType(), quantity)) {
            player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("transaction.not_enough_items")));
            return false;
        }
        int currentStock = this.plugin.getDatabaseManager().getStock(shopItem.getCategoryId(), shopItem.getItemId());
        if (currentStock + quantity > shopItem.getMaxStock()) {
            player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("transaction.max_stock_reached")));
            return false;
        }
        double basePrice = this.calculateSellPrice(shopItem.getCategoryId(), shopItem.getItemId(), quantity);
        double tax = this.plugin.getTaxManager().calculateSellTax(basePrice);
        double finalPrice = basePrice - tax;
        Object playerData = this.getPlayerData(player);
        if (playerData == null) {
            return false;
        }
        double playerMoney = this.getPlayerMoney(playerData);
        this.setPlayerMoney(playerData, playerMoney + finalPrice);
        this.removeItems(player, item.getType(), quantity);
        this.plugin.getDatabaseManager().updateStock(shopItem.getCategoryId(), shopItem.getItemId(), currentStock + quantity);
        this.plugin.getTaxManager().addTax(tax);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("amount", String.valueOf(quantity));
        placeholders.put("item", item.getType().name());
        placeholders.put("price", String.format("%.2f", basePrice));
        placeholders.put("tax", String.format("%.2f", tax));
        player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("transaction.item_sold", placeholders)));
        return true;
    }

    public void sellAllItems(Player player) {
        double totalPrice = 0.0;
        double totalTax = 0.0;
        boolean soldAny = false;
        for (ItemStack item : player.getInventory().getContents()) {
            ShopItem shopItem;
            if (item == null || (shopItem = this.findShopItem(item.getType())) == null) continue;
            int quantity = item.getAmount();
            int currentStock = this.plugin.getDatabaseManager().getStock(shopItem.getCategoryId(), shopItem.getItemId());
            if (currentStock + quantity > shopItem.getMaxStock()) continue;
            double basePrice = this.calculateSellPrice(shopItem.getCategoryId(), shopItem.getItemId(), quantity);
            double tax = this.plugin.getTaxManager().calculateSellTax(basePrice);
            double finalPrice = basePrice - tax;
            this.plugin.getDatabaseManager().updateStock(shopItem.getCategoryId(), shopItem.getItemId(), currentStock + quantity);
            this.removeItems(player, item.getType(), quantity);
            totalPrice += finalPrice;
            totalTax += tax;
            soldAny = true;
        }
        if (soldAny) {
            Object playerData = this.getPlayerData(player);
            if (playerData != null) {
                double playerMoney = this.getPlayerMoney(playerData);
                this.setPlayerMoney(playerData, playerMoney + totalPrice);
            }
            this.plugin.getTaxManager().addTax(totalTax);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("price", String.format("%.2f", totalPrice));
            player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("transaction.items_sold_bulk", placeholders)));
        } else {
            player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.no_items")));
        }
    }

    private boolean hasEnoughItems(Player player, Material material, int amount) {
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material) continue;
            count += item.getAmount();
        }
        return count >= amount;
    }

    private void removeItems(Player player, Material material, int amount) {
        int remaining = amount;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length && remaining > 0; ++i) {
            ItemStack item = contents[i];
            if (item == null || item.getType() != material) continue;
            if (item.getAmount() <= remaining) {
                remaining -= item.getAmount();
                player.getInventory().setItem(i, null);
                continue;
            }
            ItemStack newItem = new ItemStack(material, item.getAmount() - remaining);
            player.getInventory().setItem(i, newItem);
            remaining = 0;
        }
    }

    private boolean hasEnoughSpace(Player player, Material material, int amount) {
        ItemStack[] contents;
        int freeSpace = 0;
        for (ItemStack item : contents = player.getInventory().getStorageContents()) {
            if (item == null) {
                freeSpace += material.getMaxStackSize();
                continue;
            }
            if (item.getType() != material) continue;
            freeSpace += material.getMaxStackSize() - item.getAmount();
        }
        return freeSpace >= amount;
    }

    private ShopItem findShopItem(Material material) {
        for (Map<String, ShopItem> categoryItems : this.categories.values()) {
            for (ShopItem item : categoryItems.values()) {
                if (item.getMaterial() != material) continue;
                return item;
            }
        }
        return null;
    }

    private ShopItem getItem(String category, String itemId) {
        Map<String, ShopItem> items = this.categories.get(category);
        return items != null ? items.get(itemId) : null;
    }

    public Map<String, Map<String, ShopItem>> getCategories() {
        return this.categories;
    }

    public static class ShopItem {
        private final String categoryId;
        private final String itemId;
        private final Material material;
        private final double buyPrice;
        private final double sellPrice;
        private final int maxStock;

        public ShopItem(String categoryId, String itemId, Material material, double buyPrice, double sellPrice, int maxStock) {
            this.categoryId = categoryId;
            this.itemId = itemId;
            this.material = material;
            this.buyPrice = buyPrice;
            this.sellPrice = sellPrice;
            this.maxStock = maxStock;
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public String getItemId() {
            return this.itemId;
        }

        public Material getMaterial() {
            return this.material;
        }

        public double getBuyPrice() {
            return this.buyPrice;
        }

        public double getSellPrice() {
            return this.sellPrice;
        }

        public int getMaxStock() {
            return this.maxStock;
        }
    }
}

