/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop;

import amg.plugins.aMGShop.commands.ShopCommand;
import amg.plugins.aMGShop.database.DatabaseManager;
import amg.plugins.aMGShop.gui.ShopGUI;
import amg.plugins.aMGShop.libs.bstats.bukkit.Metrics;
import amg.plugins.aMGShop.listeners.NPCListener;
import amg.plugins.aMGShop.managers.ConfigManager;
import amg.plugins.aMGShop.managers.EconomyManager;
import amg.plugins.aMGShop.managers.ExploitChecker;
import amg.plugins.aMGShop.managers.InflationManager;
import amg.plugins.aMGShop.managers.LocaleManager;
import amg.plugins.aMGShop.managers.LogManager;
import amg.plugins.aMGShop.managers.NPCManager;
import amg.plugins.aMGShop.managers.ShopManager;
import amg.plugins.aMGShop.managers.TaxManager;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AMGShop
extends JavaPlugin {
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private ShopManager shopManager;
    private NPCManager npcManager;
    private LogManager logManager;
    private TaxManager taxManager;
    private InflationManager inflationManager;
    private ExploitChecker exploitChecker;
    private LocaleManager localeManager;
    private EconomyManager economyManager;
    private ShopGUI shopGUI;

    public void onEnable() {
        this.saveDefaultConfig();
        this.saveDefaultResources();
        int pluginId = 26768;
        Metrics metrics = new Metrics(this, pluginId);
        this.configManager = new ConfigManager(this);
        this.databaseManager = new DatabaseManager(this);
        this.databaseManager.initialize();
        this.localeManager = new LocaleManager(this);
        this.logManager = new LogManager(this);
        this.taxManager = new TaxManager(this);
        this.inflationManager = new InflationManager(this);
        this.economyManager = new EconomyManager(this);
        if (!this.isEnabled()) {
            return;
        }
        this.shopManager = new ShopManager(this);
        this.npcManager = new NPCManager(this);
        this.exploitChecker = new ExploitChecker(this);
        this.shopManager.loadShops();
        this.npcManager.loadNPCs();
        this.shopGUI = new ShopGUI(this);
        PluginCommand command = this.getCommand("amgshop");
        if (command != null) {
            ShopCommand shopCommand = new ShopCommand(this);
            command.setExecutor((CommandExecutor)shopCommand);
            command.setTabCompleter((TabCompleter)shopCommand);
        } else {
            this.getLogger().severe("Failed to register /amgshop command! The command will not work.");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new NPCListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.npcManager, (Plugin)this);
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            this.getLogger().info("Checking for potential crafting exploits...");
            this.exploitChecker.checkForExploits();
        }, 100L);
        this.getLogger().info("AMGShop has been enabled!");
    }

    private void saveDefaultResources() {
        this.saveResourceIfNotExists("shops/blocks.yml");
        this.saveResourceIfNotExists("shops/ores.yml");
        this.saveResourceIfNotExists("shops/mobs.yml");
        this.saveResourceIfNotExists("shops/farming.yml");
        this.saveResourceIfNotExists("shops/food.yml");
        this.saveResourceIfNotExists("shops/other.yml");
        this.saveResourceIfNotExists("shops/decoration.yml");
        this.saveResourceIfNotExists("shops/redstone.yml");
        this.saveResourceIfNotExists("shops/dyes.yml");
        this.saveResourceIfNotExists("locales/en_US.yml");
        this.saveResourceIfNotExists("locales/bg_BG.yml");
    }

    private void saveResourceIfNotExists(String resourcePath) {
        File file;
        File folder;
        String parentFolder;
        String string = parentFolder = resourcePath.contains("/") ? resourcePath.substring(0, resourcePath.lastIndexOf("/")) : "";
        if (!parentFolder.isEmpty() && !(folder = new File(this.getDataFolder(), parentFolder)).exists()) {
            folder.mkdirs();
        }
        if (!(file = new File(this.getDataFolder(), resourcePath)).exists()) {
            this.saveResource(resourcePath, false);
        }
    }

    public void onDisable() {
        if (this.npcManager != null) {
            this.npcManager.removeNPCs();
        }
        if (this.inflationManager != null) {
            this.inflationManager.stopUpdateTask();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("AMGShop has been disabled!");
    }

    public void reloadPlugin() {
        this.getLogger().info("Performing full plugin reload...");
        if (this.inflationManager != null) {
            this.inflationManager.stopUpdateTask();
        }
        if (this.npcManager != null) {
            this.npcManager.removeNPCs();
        }
        this.reloadConfig();
        if (this.configManager != null) {
            this.configManager.reloadConfig();
        }
        if (this.localeManager != null) {
            this.localeManager.reload();
        }
        if (this.shopManager != null) {
            this.shopManager.loadShops();
        }
        if (this.npcManager != null) {
            this.npcManager.loadNPCs();
        }
        this.inflationManager = new InflationManager(this);
        this.economyManager = new EconomyManager(this);
        this.getLogger().info("Plugin reload complete!");
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }

    public NPCManager getNPCManager() {
        return this.npcManager;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public TaxManager getTaxManager() {
        return this.taxManager;
    }

    public InflationManager getInflationManager() {
        return this.inflationManager;
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public ShopGUI getShopGUI() {
        return this.shopGUI;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }
}

