/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.commands;

import amg.plugins.aMGShop.AMGShop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class ShopCommand
implements CommandExecutor,
TabCompleter {
    private final AMGShop plugin;
    private final List<String> COMMANDS = Arrays.asList("reload", "setbuynpc", "setsellnpc", "setowner", "removeowner");

    public ShopCommand(AMGShop plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("amgshop.admin")) {
            sender.sendMessage(this.formatMessage(this.plugin.getConfig().getString("messages.no_permission", "&cYou don't have permission to do that!")));
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.plugin.reloadPlugin();
                sender.sendMessage(this.formatMessage("&aAMGShop has been fully reloaded!"));
                break;
            }
            case "setbuynpc": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.formatMessage("&cThis command can only be used by players!"));
                    return true;
                }
                Player player = (Player)sender;
                this.plugin.getNPCManager().createBuyNPC(player.getLocation());
                sender.sendMessage(this.formatMessage("&aBuy NPC created at your location!"));
                break;
            }
            case "setsellnpc": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.formatMessage("&cThis command can only be used by players!"));
                    return true;
                }
                Player player = (Player)sender;
                this.plugin.getNPCManager().createSellNPC(player.getLocation());
                sender.sendMessage(this.formatMessage("&aSell NPC created at your location!"));
                break;
            }
            case "setowner": {
                if (args.length < 2) {
                    sender.sendMessage(this.formatMessage("&cUsage: /amgshop setowner <player>"));
                    return true;
                }
                String playerName = args[1];
                Player targetPlayer = this.plugin.getServer().getPlayer(playerName);
                if (targetPlayer == null) {
                    sender.sendMessage(this.formatMessage("&cPlayer not found!"));
                    return true;
                }
                this.plugin.getConfig().set("shop.owner.uuid", (Object)targetPlayer.getUniqueId().toString());
                this.plugin.getConfig().set("shop.owner.name", (Object)targetPlayer.getName());
                this.plugin.saveConfig();
                sender.sendMessage(this.formatMessage("&aShop owner set to " + targetPlayer.getName() + "!"));
                break;
            }
            case "removeowner": {
                this.plugin.getConfig().set("shop.owner.uuid", null);
                this.plugin.getConfig().set("shop.owner.name", null);
                this.plugin.saveConfig();
                sender.sendMessage(this.formatMessage("&aShop owner has been removed!"));
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!sender.hasPermission("amgshop.admin")) {
            return completions;
        }
        if (args.length == 1) {
            StringUtil.copyPartialMatches((String)args[0], this.COMMANDS, completions);
        } else if (args.length == 2) {
            switch (args[0].toLowerCase()) {
                case "setowner": {
                    ArrayList onlinePlayers = new ArrayList();
                    this.plugin.getServer().getOnlinePlayers().forEach(player -> onlinePlayers.add(player.getName()));
                    StringUtil.copyPartialMatches((String)args[1], onlinePlayers, completions);
                }
            }
        }
        Collections.sort(completions);
        return completions;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(this.formatMessage("&6AMGShop Admin Commands:"));
        sender.sendMessage(this.formatMessage("&e/amgshop reload &7- Reload the configuration"));
        sender.sendMessage(this.formatMessage("&e/amgshop setbuynpc &7- Create a buy NPC at your location"));
        sender.sendMessage(this.formatMessage("&e/amgshop setsellnpc &7- Create a sell NPC at your location"));
        sender.sendMessage(this.formatMessage("&e/amgshop setowner <player> &7- Set the shop owner"));
        sender.sendMessage(this.formatMessage("&e/amgshop removeowner &7- Remove the shop owner"));
    }

    private String formatMessage(String message) {
        return message.replace("&", "\u00a7");
    }
}

