/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.database;

import amg.plugins.aMGShop.AMGShop;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.h2.jdbcx.JdbcConnectionPool;

public class DatabaseManager {
    private final AMGShop plugin;
    private JdbcConnectionPool connectionPool;

    public DatabaseManager(AMGShop plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        try {
            File dataDir = new File(this.plugin.getDataFolder(), "data");
            if (!dataDir.exists()) {
                dataDir.mkdirs();
            }
            String dbPath = new File(dataDir, this.plugin.getConfig().getString("database.file", "shop")).getAbsolutePath();
            String url = "jdbc:h2:" + dbPath;
            if (this.plugin.getConfig().getBoolean("database.encryption", true)) {
                url = url + ";CIPHER=AES;MODE=MySQL";
            }
            String username = this.plugin.getConfig().getString("database.username", "sa");
            Object password = this.plugin.getConfig().getString("database.password", "shoppassword");
            if (this.plugin.getConfig().getBoolean("database.encryption", true)) {
                password = "file_password " + (String)password;
            }
            this.connectionPool = JdbcConnectionPool.create(url, username, (String)password);
            this.connectionPool.setMaxConnections(this.plugin.getConfig().getInt("database.max_connections", 10));
            try (Connection conn = this.connectionPool.getConnection();){
                this.createTables(conn);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize database", e);
        }
    }

    private void createTables(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            stmt.execute("    CREATE TABLE IF NOT EXISTS shop_items (\n        id INT AUTO_INCREMENT PRIMARY KEY,\n        category VARCHAR(50) NOT NULL,\n        item_id VARCHAR(50) NOT NULL,\n        current_stock INT NOT NULL,\n        current_buy_price DOUBLE NOT NULL,\n        current_sell_price DOUBLE NOT NULL,\n        base_buy_price DOUBLE NOT NULL,\n        base_sell_price DOUBLE NOT NULL,\n        last_update TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n        CONSTRAINT unique_item UNIQUE(category, item_id)\n    )\n");
            stmt.execute("    CREATE TABLE IF NOT EXISTS shop_data (\n        setting_key VARCHAR(50) PRIMARY KEY,\n        setting_value TEXT NOT NULL,\n        update_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP\n    )\n");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_category ON shop_items(category)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_item_id ON shop_items(item_id)");
        }
    }

    public void updateStock(String category, String itemId, int newStock) {
        String sql = "MERGE INTO shop_items (category, item_id, current_stock) KEY(category, item_id) VALUES(?, ?, ?)";
        try (Connection conn = this.connectionPool.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, category);
            stmt.setString(2, itemId);
            stmt.setInt(3, newStock);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to update stock", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getStock(String category, String itemId) {
        String sql = "SELECT current_stock FROM shop_items WHERE category = ? AND item_id = ?";
        try (Connection conn = this.connectionPool.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, category);
            stmt.setString(2, itemId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return 0;
            int n = rs.getInt("current_stock");
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to get stock", e);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double[] getCurrentPrices(String category, String itemId) {
        String sql = "SELECT current_buy_price, current_sell_price FROM shop_items WHERE category = ? AND item_id = ?";
        try (Connection conn = this.connectionPool.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, category);
            stmt.setString(2, itemId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            double[] dArray = new double[]{rs.getDouble("current_buy_price"), rs.getDouble("current_sell_price")};
            return dArray;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to get current prices", e);
        }
        return null;
    }

    public void updatePrices(String category, String itemId, double buyPrice, double sellPrice) {
        String sql = "MERGE INTO shop_items (category, item_id, current_buy_price, current_sell_price) KEY(category, item_id) VALUES(?, ?, ?, ?)";
        try (Connection conn = this.connectionPool.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, category);
            stmt.setString(2, itemId);
            stmt.setDouble(3, buyPrice);
            stmt.setDouble(4, sellPrice);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to update prices", e);
        }
    }

    public void initializeItem(String category, String itemId, int initialStock, double buyPrice, double sellPrice) {
        String sql = "    MERGE INTO shop_items (category, item_id, current_stock, current_buy_price, current_sell_price, base_buy_price, base_sell_price)\n    KEY(category, item_id) VALUES(?, ?, ?, ?, ?, ?, ?)\n";
        try (Connection conn = this.connectionPool.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, category);
            stmt.setString(2, itemId);
            stmt.setInt(3, initialStock);
            stmt.setDouble(4, buyPrice);
            stmt.setDouble(5, sellPrice);
            stmt.setDouble(6, buyPrice);
            stmt.setDouble(7, sellPrice);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize item", e);
        }
    }

    public void saveShopData(String key, String value) {
        String sql = "MERGE INTO shop_data (setting_key, setting_value) KEY(setting_key) VALUES(?, ?)";
        try (Connection conn = this.connectionPool.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, key);
            stmt.setString(2, value);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save shop data: " + key, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getShopData(String key, String defaultValue) {
        String sql = "SELECT setting_value FROM shop_data WHERE setting_key = ?";
        try (Connection conn = this.connectionPool.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, key);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return defaultValue;
            String string = rs.getString("setting_value");
            return string;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to get shop data: " + key, e);
        }
        return defaultValue;
    }

    public void saveCollectedTaxes(double amount) {
        this.saveShopData("collected_taxes", String.valueOf(amount));
    }

    public double getCollectedTaxes() {
        String value = this.getShopData("collected_taxes", "0.0");
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            this.plugin.getLogger().log(Level.WARNING, "Invalid collected taxes value in database: " + value);
            return 0.0;
        }
    }

    public void close() {
        if (this.connectionPool != null) {
            this.connectionPool.dispose();
        }
    }
}

