/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.gui;

import amg.plugins.aMGShop.AMGShop;
import amg.plugins.aMGShop.gui.SellGUI;
import amg.plugins.aMGShop.managers.ShopManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ShopGUI
implements Listener {
    private final AMGShop plugin;
    private final Map<String, List<Inventory>> categoryPages;
    private final Map<Player, Integer> currentPage;
    private final Map<Player, QuantitySelectionData> quantitySelections;
    private final Map<UUID, Inventory> playerBuyMenus;
    private final Map<UUID, Inventory> playerSellMenus;
    private final Map<Inventory, Boolean> quantityMenus;
    private final Map<Player, Long> lastClickTime;
    private final SellGUI sellGUI;

    public ShopGUI(AMGShop plugin) {
        this.plugin = plugin;
        this.categoryPages = new HashMap<String, List<Inventory>>();
        this.currentPage = new HashMap<Player, Integer>();
        this.quantitySelections = new HashMap<Player, QuantitySelectionData>();
        this.playerBuyMenus = new HashMap<UUID, Inventory>();
        this.playerSellMenus = new HashMap<UUID, Inventory>();
        this.quantityMenus = new HashMap<Inventory, Boolean>();
        this.lastClickTime = new HashMap<Player, Long>();
        this.sellGUI = new SellGUI(plugin);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        plugin.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onPlayerQuit(PlayerQuitEvent event) {
                ShopGUI.this.cleanup(event.getPlayer());
            }
        }, (Plugin)plugin);
        this.createCategoryMenus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(Player player) {
        Map<UUID, Object> map = this.playerBuyMenus;
        synchronized (map) {
            this.playerBuyMenus.remove(player.getUniqueId());
        }
        map = this.playerSellMenus;
        synchronized (map) {
            this.playerSellMenus.remove(player.getUniqueId());
        }
        map = this.currentPage;
        synchronized (map) {
            this.currentPage.remove(player);
        }
        map = this.quantitySelections;
        synchronized (map) {
            this.quantitySelections.remove(player);
        }
        map = this.lastClickTime;
        synchronized (map) {
            this.lastClickTime.remove(player);
        }
        map = this.quantityMenus;
        synchronized (map) {
            this.quantityMenus.entrySet().removeIf(entry -> this.plugin.getServer().getOnlinePlayers().stream().noneMatch(p -> p.getOpenInventory().getTopInventory().equals(entry.getKey())));
        }
    }

    private Inventory createSellMenu(Player player) {
        int i;
        Component title = ((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.sell_menu_title")).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false);
        int rows = this.plugin.getConfig().getInt("shop.rows", 6);
        Inventory menu = Bukkit.createInventory(null, (int)(rows * 9), (Component)title);
        for (i = 0; i < 9; ++i) {
            menu.setItem(i, this.createGlassPane(0));
            menu.setItem(menu.getSize() - 9 + i, this.createGlassPane(0));
        }
        for (i = 0; i < rows; ++i) {
            menu.setItem(i * 9, this.createGlassPane(1));
            menu.setItem(i * 9 + 8, this.createGlassPane(1));
        }
        ConfigurationSection categories = this.plugin.getConfig().getConfigurationSection("categories");
        if (categories != null) {
            for (String categoryId : categories.getKeys(false)) {
                ConfigurationSection category = categories.getConfigurationSection(categoryId);
                if (category == null) continue;
                this.createCategoryButton(category, categoryId, menu);
            }
        }
        this.addBottomButtons(menu);
        this.fillEmptySlots(menu, 0, menu.getSize() - 1);
        this.playerSellMenus.put(player.getUniqueId(), menu);
        return menu;
    }

    private void debug(String message) {
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            this.plugin.getLogger().info("[Debug] " + message);
        }
    }

    private ItemStack createGlassPane(int colorIndex) {
        Material[] glassPanes = new Material[]{Material.RED_STAINED_GLASS_PANE, Material.RED_STAINED_GLASS_PANE, Material.RED_STAINED_GLASS_PANE};
        ItemStack pane = new ItemStack(glassPanes[colorIndex % glassPanes.length]);
        ItemMeta meta = pane.getItemMeta();
        meta.displayName((Component)Component.empty());
        pane.setItemMeta(meta);
        return pane;
    }

    private void fillEmptySlots(Inventory inventory, int startSlot, int endSlot) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null || i < startSlot || i > endSlot) continue;
            inventory.setItem(i, this.createGlassPane(i));
        }
    }

    private Inventory createBuyMenu(Player player) {
        int i;
        Component title = ((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.buy_menu_title")).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false);
        int rows = this.plugin.getConfig().getInt("shop.rows", 6);
        Inventory menu = Bukkit.createInventory(null, (int)(rows * 9), (Component)title);
        for (i = 0; i < 9; ++i) {
            menu.setItem(i, this.createGlassPane(0));
            menu.setItem(menu.getSize() - 9 + i, this.createGlassPane(0));
        }
        for (i = 0; i < rows; ++i) {
            menu.setItem(i * 9, this.createGlassPane(1));
            menu.setItem(i * 9 + 8, this.createGlassPane(1));
        }
        ConfigurationSection categories = this.plugin.getConfig().getConfigurationSection("categories");
        if (categories != null) {
            for (String categoryId : categories.getKeys(false)) {
                ConfigurationSection items;
                Material icon;
                ConfigurationSection category = categories.getConfigurationSection(categoryId);
                if (category == null) continue;
                String name = category.getString("name", categoryId);
                String iconName = category.getString("icon", "BARRIER");
                int slot = category.getInt("slot", 0);
                try {
                    icon = Material.valueOf((String)iconName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid material for category " + categoryId + ": " + iconName);
                    icon = Material.BARRIER;
                }
                ItemStack item = new ItemStack(icon);
                ItemMeta meta = item.getItemMeta();
                meta.displayName(Component.text((String)name.replace("&", "\u00a7")).decoration(TextDecoration.ITALIC, false));
                NamespacedKey categoryKey = new NamespacedKey((Plugin)this.plugin, "category_id");
                meta.getPersistentDataContainer().set(categoryKey, PersistentDataType.STRING, (Object)categoryId);
                ArrayList<Object> lore = new ArrayList<Object>();
                FileConfiguration categoryConfig = this.plugin.getConfigManager().getCategoryConfig(categoryId);
                if (categoryConfig != null && (items = categoryConfig.getConfigurationSection("items")) != null) {
                    int itemCount = items.getKeys(false).size();
                    HashMap<String, String> itemCountPlaceholders = new HashMap<String, String>();
                    itemCountPlaceholders.put("count", String.valueOf(itemCount));
                    lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.item_count", itemCountPlaceholders)).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
                    lore.add(Component.empty());
                    lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.click_to_buy")).color((TextColor)NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false));
                }
                meta.lore(lore);
                item.setItemMeta(meta);
                menu.setItem(slot, item);
            }
        }
        this.addBottomButtons(menu);
        this.fillEmptySlots(menu, 0, menu.getSize() - 1);
        this.playerBuyMenus.put(player.getUniqueId(), menu);
        return menu;
    }

    private void addBottomButtons(Inventory inventory) {
        this.addSpecialButton(inventory);
        ItemStack closeButton = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = closeButton.getItemMeta();
        closeMeta.displayName(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.buttons.close")).color((TextColor)NamedTextColor.RED)).decoration(TextDecoration.ITALIC, false));
        closeButton.setItemMeta(closeMeta);
        inventory.setItem(50, closeButton);
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta itemMeta = playerHead.getItemMeta();
        if (itemMeta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)itemMeta;
            skullMeta.displayName(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.buttons.your_balance")).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false));
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)"MHF_Question"));
            playerHead.setItemMeta((ItemMeta)skullMeta);
        }
        inventory.setItem(48, playerHead);
    }

    private void addSpecialButton(Inventory inventory) {
        ItemStack placeholderButton = new ItemStack(Material.GOLD_INGOT);
        ItemMeta meta = placeholderButton.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.buttons.loading")).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        placeholderButton.setItemMeta(meta);
        inventory.setItem(49, placeholderButton);
    }

    private void updatePlayerHead(Player player, Inventory inventory) {
        ItemMeta itemMeta;
        ItemStack playerHead = inventory.getItem(48);
        if (playerHead != null && (itemMeta = playerHead.getItemMeta()) instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)itemMeta;
            skullMeta.setOwningPlayer((OfflinePlayer)player);
            double balance = this.plugin.getShopManager().getPlayerMoney(player);
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add(((TextComponent)Component.text((String)String.format("$%.2f", balance)).color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
            skullMeta.lore(lore);
            playerHead.setItemMeta((ItemMeta)skullMeta);
        }
    }

    private void createCategoryButton(ConfigurationSection category, String categoryId, Inventory menu) {
        FileConfiguration categoryConfig = this.plugin.getConfigManager().getCategoryConfig(categoryId);
        if (categoryConfig == null) {
            return;
        }
        Material icon = Material.valueOf((String)categoryConfig.getString("icon", "BARRIER"));
        int slot = categoryConfig.getInt("slot", 0);
        ItemStack item = new ItemStack(icon);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.category." + categoryId)).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false));
        NamespacedKey categoryKey = new NamespacedKey((Plugin)this.plugin, "category_id");
        meta.getPersistentDataContainer().set(categoryKey, PersistentDataType.STRING, (Object)categoryId);
        ArrayList<Object> lore = new ArrayList<Object>();
        ConfigurationSection items = categoryConfig.getConfigurationSection("items");
        if (items != null) {
            int itemCount = items.getKeys(false).size();
            lore.add(((TextComponent)Component.text((String)("Contains " + itemCount + " items")).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
            lore.add(Component.empty());
            lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.click_to_buy")).color((TextColor)NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false));
        }
        meta.lore(lore);
        item.setItemMeta(meta);
        menu.setItem(slot, item);
    }

    private void addTaxCollectionButton(Player player, Inventory inventory) {
        if (!this.plugin.getTaxManager().isOwner(player)) {
            this.addInfoButton(inventory);
            return;
        }
        int slot = this.plugin.getConfig().getInt("shop.tax.collection_button.slot", 49);
        Material material = Material.valueOf((String)this.plugin.getConfig().getString("shop.tax.collection_button.material", "GOLD_INGOT"));
        ItemStack button = new ItemStack(material);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("tax.button_name")).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false));
        double taxes = this.plugin.getTaxManager().getCollectedTaxes();
        ArrayList<Component> lore = new ArrayList<Component>();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("amount", String.format("%.2f", taxes));
        lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("tax.button_lore", placeholders)).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        meta.lore(lore);
        button.setItemMeta(meta);
        inventory.setItem(slot, button);
    }

    private void addInfoButton(Inventory inventory) {
        ItemStack infoButton = new ItemStack(Material.BOOK);
        ItemMeta meta = infoButton.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("info.title")).color((TextColor)NamedTextColor.AQUA)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("owner", this.plugin.getConfig().getString("shop.owner.name", "None"));
        lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("info.owner", placeholders)).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        lore.add(Component.empty());
        meta.lore(lore);
        infoButton.setItemMeta(meta);
        inventory.setItem(49, infoButton);
    }

    private void createCategoryMenus() {
        this.debug("Creating category menus...");
        this.categoryPages.clear();
        Map<String, Map<String, ShopManager.ShopItem>> categories = this.plugin.getShopManager().getCategories();
        for (Map.Entry<String, Map<String, ShopManager.ShopItem>> entry : categories.entrySet()) {
            String categoryId = entry.getKey();
            Map<String, ShopManager.ShopItem> items = entry.getValue();
            ConfigurationSection category = this.plugin.getConfig().getConfigurationSection("categories." + categoryId);
            if (category == null) continue;
            String name = category.getString("name", categoryId).replace("&", "\u00a7");
            ArrayList<Map.Entry<String, ShopManager.ShopItem>> sortedItems = new ArrayList<Map.Entry<String, ShopManager.ShopItem>>(items.entrySet());
            FileConfiguration categoryConfig = this.plugin.getConfigManager().getCategoryConfig(categoryId);
            if (categoryConfig != null && categoryConfig.isConfigurationSection("items")) {
                ConfigurationSection itemsSection = categoryConfig.getConfigurationSection("items");
                ArrayList orderedKeys = new ArrayList(itemsSection.getKeys(false));
                Collections.sort(sortedItems, (a, b) -> {
                    int indexA = orderedKeys.indexOf(a.getKey());
                    int indexB = orderedKeys.indexOf(b.getKey());
                    return Integer.compare(indexA, indexB);
                });
                this.debug("Sorted " + sortedItems.size() + " items by config file order for category: " + categoryId);
            } else {
                Collections.sort(sortedItems, (a, b) -> ((String)a.getKey()).compareTo((String)b.getKey()));
                this.debug("Using alphabetical sorting for category: " + categoryId);
            }
            ArrayList<Inventory> pages = new ArrayList<Inventory>();
            int pageNumber = 1;
            int itemsPerPage = 28;
            int totalPages = (int)Math.ceil((double)sortedItems.size() / (double)itemsPerPage);
            this.debug("Category " + categoryId + " requires " + totalPages + " pages for " + sortedItems.size() + " items");
            for (int page = 0; page < totalPages; ++page) {
                int i;
                Component title = ((TextComponent)Component.text((String)(name + " (Page " + (page + 1) + "/" + totalPages + ")")).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false);
                Inventory menu = Bukkit.createInventory(null, (int)54, (Component)title);
                for (i = 0; i < 9; ++i) {
                    menu.setItem(i, this.createGlassPane(0));
                    menu.setItem(menu.getSize() - 9 + i, this.createGlassPane(0));
                }
                for (i = 0; i < 6; ++i) {
                    menu.setItem(i * 9, this.createGlassPane(1));
                    menu.setItem(i * 9 + 8, this.createGlassPane(1));
                }
                int startIndex = page * itemsPerPage;
                int endIndex = Math.min(startIndex + itemsPerPage, sortedItems.size());
                int row = 1;
                int col = 1;
                for (int i2 = startIndex; i2 < endIndex; ++i2) {
                    int slot = row * 9 + col;
                    Map.Entry itemEntry = (Map.Entry)sortedItems.get(i2);
                    String itemId = (String)itemEntry.getKey();
                    ShopManager.ShopItem shopItem = (ShopManager.ShopItem)itemEntry.getValue();
                    ItemStack item = this.createShopItem(categoryId, itemId, shopItem);
                    menu.setItem(slot, item);
                    if (++col != 8) continue;
                    col = 1;
                    ++row;
                }
                if (page > 0) {
                    ItemStack prevButton = new ItemStack(Material.ARROW);
                    ItemMeta prevMeta = prevButton.getItemMeta();
                    prevMeta.displayName(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.buttons.prev_page")).color((TextColor)NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false));
                    ArrayList<Component> prevLore = new ArrayList<Component>();
                    HashMap<String, String> prevPlaceholders = new HashMap<String, String>();
                    prevPlaceholders.put("page", String.valueOf(page));
                    prevLore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.buttons.prev_page_lore", prevPlaceholders)).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
                    prevMeta.lore(prevLore);
                    prevButton.setItemMeta(prevMeta);
                    menu.setItem(45, prevButton);
                }
                if (page < totalPages - 1) {
                    ItemStack nextButton = new ItemStack(Material.ARROW);
                    ItemMeta nextMeta = nextButton.getItemMeta();
                    nextMeta.displayName(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.buttons.next_page")).color((TextColor)NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false));
                    ArrayList<Component> nextLore = new ArrayList<Component>();
                    HashMap<String, String> nextPlaceholders = new HashMap<String, String>();
                    nextPlaceholders.put("page", String.valueOf(page + 2));
                    nextLore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.buttons.next_page_lore", nextPlaceholders)).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
                    nextMeta.lore(nextLore);
                    nextButton.setItemMeta(nextMeta);
                    menu.setItem(53, nextButton);
                    this.debug("Added next page button on page " + (page + 1) + " to go to page " + (page + 2));
                }
                ItemStack backButton = new ItemStack(Material.BARRIER);
                ItemMeta backMeta = backButton.getItemMeta();
                backMeta.displayName(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.buttons.back_to_main")).color((TextColor)NamedTextColor.RED)).decoration(TextDecoration.ITALIC, false));
                backButton.setItemMeta(backMeta);
                menu.setItem(49, backButton);
                pages.add(menu);
                this.debug("Created page " + pageNumber + " for category " + categoryId + " with prev=" + (page > 0) + ", next=" + (page < totalPages - 1));
                ++pageNumber;
            }
            this.categoryPages.put(categoryId, pages);
            this.debug("Created category menu for: " + categoryId + " with " + sortedItems.size() + " items across " + pages.size() + " pages");
        }
    }

    private ItemStack createShopItem(String categoryId, String itemId, ShopManager.ShopItem shopItem) {
        ItemStack item = new ItemStack(shopItem.getMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)itemId.replace("_", " ").toUpperCase()).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false));
        NamespacedKey categoryKey = new NamespacedKey((Plugin)this.plugin, "category_id");
        NamespacedKey itemKey = new NamespacedKey((Plugin)this.plugin, "item_id");
        meta.getPersistentDataContainer().set(categoryKey, PersistentDataType.STRING, (Object)categoryId);
        meta.getPersistentDataContainer().set(itemKey, PersistentDataType.STRING, (Object)itemId);
        ArrayList<Object> lore = new ArrayList<Object>();
        int currentStock = this.plugin.getDatabaseManager().getStock(categoryId, itemId);
        double buyPrice = this.plugin.getShopManager().calculateBuyPrice(categoryId, itemId, 1);
        double taxAmount = this.plugin.getTaxManager().calculateBuyTax(buyPrice);
        HashMap<String, String> stockPlaceholders = new HashMap<String, String>();
        stockPlaceholders.put("amount", String.valueOf(currentStock));
        lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.stock", stockPlaceholders)).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        HashMap<String, String> pricePlaceholders = new HashMap<String, String>();
        pricePlaceholders.put("price", String.format("%.2f", buyPrice));
        lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.price", pricePlaceholders)).color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
        if (this.plugin.getTaxManager().shouldShowTaxInLore()) {
            lore.add(((TextComponent)Component.text((String)String.format("Includes Tax: $%.2f", taxAmount)).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        }
        if (this.plugin.getConfig().getBoolean("shop.inflation.enabled", true)) {
            HashMap<String, String> inflationPlaceholders = new HashMap<String, String>();
            inflationPlaceholders.put("rate", String.format("%.1f", this.plugin.getInflationManager().getInflationRate()));
            lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.inflation", inflationPlaceholders)).color((TextColor)NamedTextColor.RED)).decoration(TextDecoration.ITALIC, false));
        }
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.click_to_buy")).color((TextColor)NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false));
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public void openBuyMenu(Player player) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Map<UUID, Inventory> map = this.playerBuyMenus;
            synchronized (map) {
                Inventory menu = this.playerBuyMenus.get(player.getUniqueId());
                if (menu == null) {
                    menu = this.createBuyMenu(player);
                    this.playerBuyMenus.put(player.getUniqueId(), menu);
                }
                player.openInventory(menu);
                this.updatePlayerHead(player, menu);
            }
        });
    }

    public void openSellMenu(Player player) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Map<UUID, Inventory> map = this.playerSellMenus;
            synchronized (map) {
                Inventory menu = this.playerSellMenus.get(player.getUniqueId());
                if (menu == null) {
                    menu = this.createSellMenu(player);
                    this.playerSellMenus.put(player.getUniqueId(), menu);
                }
                player.openInventory(menu);
                this.updatePlayerHead(player, menu);
                this.sellGUI.openSellMenu(player);
            }
        });
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.quantityMenus.containsKey(event.getView().getTopInventory())) {
            event.setCancelled(true);
            if (event.getCurrentItem() != null && event.getClickedInventory() != null) {
                this.handleQuantitySelectionClick(event);
            }
            return;
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getClickedInventory() == null) {
            return;
        }
        if (!this.isShopInventory(event.getView().getTopInventory())) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        this.debug("Clicked item: " + String.valueOf(clickedItem.getType()) + " in slot " + event.getSlot());
        if (clickedItem.getType() == Material.WHITE_STAINED_GLASS_PANE || clickedItem.getType() == Material.LIGHT_BLUE_STAINED_GLASS_PANE || clickedItem.getType() == Material.BLUE_STAINED_GLASS_PANE || clickedItem.getType() == Material.RED_STAINED_GLASS_PANE) {
            return;
        }
        if (clickedItem.getType() == Material.BARRIER) {
            this.debug("Barrier clicked in slot " + event.getSlot());
            String title = PlainTextComponentSerializer.plainText().serialize(event.getView().title());
            String mainMenuTitle = this.plugin.getLocaleManager().getMessage("shop.buy_menu_title");
            this.debug("Current menu title: '" + title + "', Main menu title: '" + mainMenuTitle + "'");
            if (event.getSlot() == 50 || event.getSlot() == 49) {
                if (!title.equals(mainMenuTitle)) {
                    this.debug("In category menu, returning to main menu");
                    this.openBuyMenu(player);
                } else if (event.getSlot() == 50) {
                    this.debug("In main menu, closing inventory");
                    event.getView().close();
                }
                return;
            }
            if (event.getSlot() == 26) {
                this.debug("Closing quantity selection menu");
                event.getView().close();
                return;
            }
        }
        if (clickedItem.getType() == Material.ARROW) {
            this.debug("Navigation button clicked in slot " + event.getSlot());
            this.handleNavigationClick(event);
            return;
        }
        if (clickedItem.getType() == Material.PLAYER_HEAD && event.getSlot() == 48) {
            return;
        }
        if (clickedItem.getType() == Material.BOOK && event.getSlot() == 49) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return;
        }
        Material taxButtonMaterial = Material.valueOf((String)this.plugin.getConfig().getString("shop.tax.collection_button.material", "GOLD_INGOT"));
        if (clickedItem.getType() == taxButtonMaterial && event.getSlot() == this.plugin.getConfig().getInt("shop.tax.collection_button.slot", 49)) {
            if (this.plugin.getTaxManager().isOwner(player)) {
                this.handleTaxCollection(player);
            } else {
                String message = this.plugin.getConfig().getString("messages.not_shop_owner", "&c&lError: &fOnly the shop owner can do this!");
                player.sendMessage(this.formatMessage(message));
            }
            return;
        }
        NamespacedKey categoryKey = new NamespacedKey((Plugin)this.plugin, "category_id");
        NamespacedKey itemKey = new NamespacedKey((Plugin)this.plugin, "item_id");
        String categoryId = (String)meta.getPersistentDataContainer().get(categoryKey, PersistentDataType.STRING);
        String itemId = meta.getPersistentDataContainer().has(itemKey, PersistentDataType.STRING) ? (String)meta.getPersistentDataContainer().get(itemKey, PersistentDataType.STRING) : null;
        this.debug("Click detected - Category: " + categoryId + ", Item: " + itemId + ", Material: " + String.valueOf(clickedItem.getType()) + ", Name: " + String.valueOf(meta.displayName()));
        if (categoryId != null) {
            if (itemId != null) {
                this.debug("Opening quantity selection menu for: " + itemId + " in category " + categoryId);
                this.openQuantitySelectionMenu(player, categoryId, itemId);
            } else if (this.categoryPages.containsKey(categoryId)) {
                this.debug("Opening category: " + categoryId + " (Menu exists: " + (this.categoryPages.get(categoryId) != null) + ")");
                Inventory categoryMenu = this.categoryPages.get(categoryId).get(0);
                if (categoryMenu != null) {
                    this.currentPage.put(player, 0);
                    player.openInventory(categoryMenu);
                } else {
                    this.plugin.getLogger().warning("Category menu is null for: " + categoryId);
                }
            } else {
                this.plugin.getLogger().warning("Category menu not found for: " + categoryId);
            }
        }
    }

    private void handleNavigationClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        String title = PlainTextComponentSerializer.plainText().serialize(event.getView().title());
        this.debug("Processing navigation click. Title: " + title);
        int pageIndex = title.lastIndexOf(" (Page ");
        if (pageIndex == -1) {
            this.debug("No page info found in title: " + title);
            return;
        }
        try {
            String categoryName = title.substring(0, pageIndex).replaceAll("\u00a7[0-9a-fk-or]", "");
            this.debug("Category name: " + categoryName);
            String pageInfo = title.substring(pageIndex + 7);
            pageInfo = pageInfo.substring(0, pageInfo.length() - 1);
            String[] pageParts = pageInfo.split("/");
            if (pageParts.length != 2) {
                this.debug("Invalid page format in title: " + title);
                return;
            }
            int currentPageNum = Integer.parseInt(pageParts[0].trim()) - 1;
            int totalPages = Integer.parseInt(pageParts[1].trim());
            this.debug("Current page: " + (currentPageNum + 1) + ", Total pages: " + totalPages);
            String categoryId = null;
            for (String id : this.categoryPages.keySet()) {
                String name = this.plugin.getConfig().getString("categories." + id + ".name", "").replace("&", "\u00a7");
                if (!(name = name.replaceAll("\u00a7[0-9a-fk-or]", "")).equals(categoryName)) continue;
                categoryId = id;
                break;
            }
            if (categoryId == null) {
                this.debug("Could not find category for name: " + categoryName);
                return;
            }
            this.debug("Found category ID: " + categoryId);
            List<Inventory> pages = this.categoryPages.get(categoryId);
            if (pages == null) {
                this.debug("No pages found for category: " + categoryId);
                return;
            }
            this.debug("Category has " + pages.size() + " pages");
            int slot = event.getSlot();
            this.debug("Clicked slot: " + slot + ", Current page: " + (currentPageNum + 1) + "/" + totalPages);
            if (slot == 45 && currentPageNum > 0) {
                this.debug("Moving to previous page");
                this.currentPage.put(player, currentPageNum - 1);
                Inventory prevPage = pages.get(currentPageNum - 1);
                if (prevPage != null) {
                    player.openInventory(prevPage);
                    this.debug("Opened previous page " + currentPageNum + " for " + player.getName());
                } else {
                    this.debug("Previous page inventory is null!");
                }
            } else if (slot == 53 && currentPageNum < totalPages - 1) {
                this.debug("Moving to next page");
                this.currentPage.put(player, currentPageNum + 1);
                Inventory nextPage = pages.get(currentPageNum + 1);
                if (nextPage != null) {
                    player.openInventory(nextPage);
                    this.debug("Opened next page " + (currentPageNum + 2) + " for " + player.getName());
                } else {
                    this.debug("Next page inventory is null!");
                }
            } else {
                this.debug("Navigation conditions not met: slot=" + slot + ", currentPage=" + currentPageNum + ", totalPages=" + totalPages);
            }
        }
        catch (Exception e) {
            this.debug("Error in navigation: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (this.quantityMenus.containsKey(event.getInventory()) || this.playerBuyMenus.containsValue(event.getInventory()) || this.playerSellMenus.containsValue(event.getInventory()) || this.isInventoryInCategoryPages(event.getInventory())) {
            event.setCancelled(true);
        }
    }

    private boolean isInventoryInCategoryPages(Inventory inventory) {
        for (List<Inventory> pages : this.categoryPages.values()) {
            if (!pages.contains(inventory)) continue;
            return true;
        }
        return false;
    }

    private boolean isShopInventory(Inventory inventory) {
        return this.playerBuyMenus.containsValue(inventory) || this.playerSellMenus.containsValue(inventory) || this.isInventoryInCategoryPages(inventory);
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.isShopInventory(event.getInventory())) {
            return;
        }
        this.updatePlayerHead(player, event.getInventory());
        if (this.playerBuyMenus.containsValue(event.getInventory()) || this.playerSellMenus.containsValue(event.getInventory())) {
            if (this.plugin.getTaxManager().isOwner(player)) {
                this.addTaxCollectionButton(player, event.getInventory());
            } else {
                this.addInfoButton(event.getInventory());
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.quantityMenus.containsKey(event.getInventory())) {
            this.quantityMenus.remove(event.getInventory());
            this.quantitySelections.remove(player);
            this.lastClickTime.remove(player);
        }
    }

    private void handleBuyTransaction(Player player, String categoryId, String itemId, int quantity) {
        int currentStock = this.plugin.getDatabaseManager().getStock(categoryId, itemId);
        if (currentStock < quantity) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("available", String.valueOf(currentStock));
            placeholders.put("requested", String.valueOf(quantity));
            player.sendMessage(Component.text((String)this.plugin.getLocaleManager().getMessage("transaction.not_enough_stock", placeholders)).color((TextColor)NamedTextColor.RED));
            return;
        }
        double price = this.plugin.getShopManager().calculateBuyPrice(categoryId, itemId, quantity);
        if (this.plugin.getShopManager().getPlayerMoney(player) < price) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("price", String.format("%.2f", price));
            player.sendMessage(Component.text((String)this.plugin.getLocaleManager().getMessage("transaction.not_enough_money", placeholders)).color((TextColor)NamedTextColor.RED));
            return;
        }
        if (this.plugin.getShopManager().buyItem(player, categoryId, itemId, quantity)) {
            this.createCategoryMenus();
            player.openInventory(this.categoryPages.get(categoryId).get(this.currentPage.getOrDefault(player, 0)));
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("quantity", String.valueOf(quantity));
            placeholders.put("item", itemId.replace("_", " "));
            placeholders.put("price", String.format("%.2f", price));
            player.sendMessage(Component.text((String)this.plugin.getLocaleManager().getMessage("transaction.purchase_success", placeholders)).color((TextColor)NamedTextColor.GREEN));
        }
    }

    private void handleTaxCollection(Player player) {
        if (!this.plugin.getTaxManager().isOwner(player)) {
            player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("tax.not_owner")));
            return;
        }
        double amount = this.plugin.getTaxManager().collectTaxes(player);
        if (amount > 0.0) {
            this.plugin.getShopManager().depositMoney(player, amount);
        }
        if (player.getOpenInventory() != null && this.isShopInventory(player.getOpenInventory().getTopInventory())) {
            this.addTaxCollectionButton(player, player.getOpenInventory().getTopInventory());
        }
    }

    public void refreshCategoryMenus() {
        this.createCategoryMenus();
    }

    private String formatMessage(String message) {
        return message.replace("&", "\u00a7");
    }

    private void openQuantitySelectionMenu(Player player, String categoryId, String itemId) {
        ShopManager.ShopItem item = this.plugin.getShopManager().getCategories().get(categoryId).get(itemId);
        if (item == null) {
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("item", itemId.replace("_", " "));
        Component title = ((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.quantity_menu_title", placeholders)).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false);
        Inventory menu = Bukkit.createInventory(null, (int)27, (Component)title);
        ItemStack border = this.createGlassPane(0);
        for (int i = 0; i < 27; ++i) {
            menu.setItem(i, border.clone());
        }
        ItemStack displayItem = new ItemStack(item.getMaterial());
        ItemMeta displayMeta = displayItem.getItemMeta();
        NamespacedKey categoryKey = new NamespacedKey((Plugin)this.plugin, "category_id");
        NamespacedKey itemKey = new NamespacedKey((Plugin)this.plugin, "item_id");
        displayMeta.getPersistentDataContainer().set(categoryKey, PersistentDataType.STRING, (Object)categoryId);
        displayMeta.getPersistentDataContainer().set(itemKey, PersistentDataType.STRING, (Object)itemId);
        displayMeta.displayName(((TextComponent)Component.text((String)itemId.replace("_", " ").toUpperCase()).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false));
        int currentStock = this.plugin.getDatabaseManager().getStock(categoryId, itemId);
        double buyPrice = this.plugin.getShopManager().calculateBuyPrice(categoryId, itemId, 1);
        ArrayList<Component> displayLore = new ArrayList<Component>();
        displayLore.add(((TextComponent)Component.text((String)("Stock: " + currentStock)).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        displayLore.add(((TextComponent)Component.text((String)String.format("Price: $%.2f each", buyPrice)).color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
        displayMeta.lore(displayLore);
        displayItem.setItemMeta(displayMeta);
        menu.setItem(13, displayItem);
        int initialQuantity = 1;
        this.addQuantityButton(menu, 10, Material.RED_CONCRETE, this.plugin.getLocaleManager().getMessage("shop.buttons.remove_thirtytwo"), -32, categoryId, itemId);
        this.addQuantityButton(menu, 11, Material.RED_CONCRETE, this.plugin.getLocaleManager().getMessage("shop.buttons.remove_sixteen"), -16, categoryId, itemId);
        this.addQuantityButton(menu, 12, Material.RED_CONCRETE, this.plugin.getLocaleManager().getMessage("shop.buttons.remove_one"), -1, categoryId, itemId);
        this.addQuantityButton(menu, 14, Material.LIME_CONCRETE, this.plugin.getLocaleManager().getMessage("shop.buttons.add_one"), 1, categoryId, itemId);
        this.addQuantityButton(menu, 15, Material.LIME_CONCRETE, this.plugin.getLocaleManager().getMessage("shop.buttons.add_sixteen"), 16, categoryId, itemId);
        this.addQuantityButton(menu, 16, Material.LIME_CONCRETE, this.plugin.getLocaleManager().getMessage("shop.buttons.add_thirtytwo"), 32, categoryId, itemId);
        this.updateQuantityDisplay(menu, initialQuantity, categoryId, itemId);
        ItemStack confirmButton = new ItemStack(Material.EMERALD);
        ItemMeta confirmMeta = confirmButton.getItemMeta();
        confirmMeta.displayName(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.buttons.confirm_purchase")).color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
        confirmMeta.getPersistentDataContainer().set(categoryKey, PersistentDataType.STRING, (Object)categoryId);
        confirmMeta.getPersistentDataContainer().set(itemKey, PersistentDataType.STRING, (Object)itemId);
        confirmMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "button_type"), PersistentDataType.STRING, (Object)"confirm");
        confirmButton.setItemMeta(confirmMeta);
        menu.setItem(22, confirmButton);
        ItemStack backButton = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = backButton.getItemMeta();
        backMeta.displayName(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.buttons.back_to_category")).color((TextColor)NamedTextColor.RED)).decoration(TextDecoration.ITALIC, false));
        backMeta.getPersistentDataContainer().set(categoryKey, PersistentDataType.STRING, (Object)categoryId);
        backMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "button_type"), PersistentDataType.STRING, (Object)"back");
        backButton.setItemMeta(backMeta);
        menu.setItem(26, backButton);
        this.quantitySelections.put(player, new QuantitySelectionData(categoryId, itemId, initialQuantity));
        this.quantityMenus.put(menu, true);
        player.openInventory(menu);
    }

    private void addQuantityButton(Inventory menu, int slot, Material material, String label, int change, String categoryId, String itemId) {
        ItemStack button = new ItemStack(material);
        ItemMeta meta = button.getItemMeta();
        meta.displayName(((TextComponent)Component.text((String)label).color((TextColor)(change > 0 ? NamedTextColor.GREEN : NamedTextColor.RED))).decoration(TextDecoration.ITALIC, false));
        NamespacedKey changeKey = new NamespacedKey((Plugin)this.plugin, "quantity_change");
        NamespacedKey categoryKey = new NamespacedKey((Plugin)this.plugin, "category_id");
        NamespacedKey itemKey = new NamespacedKey((Plugin)this.plugin, "item_id");
        NamespacedKey buttonTypeKey = new NamespacedKey((Plugin)this.plugin, "button_type");
        meta.getPersistentDataContainer().set(changeKey, PersistentDataType.INTEGER, (Object)change);
        meta.getPersistentDataContainer().set(categoryKey, PersistentDataType.STRING, (Object)categoryId);
        meta.getPersistentDataContainer().set(itemKey, PersistentDataType.STRING, (Object)itemId);
        meta.getPersistentDataContainer().set(buttonTypeKey, PersistentDataType.STRING, (Object)"quantity");
        button.setItemMeta(meta);
        menu.setItem(slot, button);
    }

    private void updateQuantityDisplay(Inventory menu, int quantity, String categoryId, String itemId) {
        quantity = Math.max(1, quantity);
        int currentStock = this.plugin.getDatabaseManager().getStock(categoryId, itemId);
        quantity = Math.min(quantity, currentStock);
        double totalPrice = this.plugin.getShopManager().calculateBuyPrice(categoryId, itemId, quantity);
        double basePrice = totalPrice / this.plugin.getTaxManager().getBuyPriceMultiplier();
        double taxAmount = totalPrice - basePrice;
        ItemStack quantityItem = new ItemStack(Material.YELLOW_CONCRETE);
        ItemMeta meta = quantityItem.getItemMeta();
        NamespacedKey categoryKey = new NamespacedKey((Plugin)this.plugin, "category_id");
        NamespacedKey itemKey = new NamespacedKey((Plugin)this.plugin, "item_id");
        NamespacedKey buttonTypeKey = new NamespacedKey((Plugin)this.plugin, "button_type");
        meta.getPersistentDataContainer().set(categoryKey, PersistentDataType.STRING, (Object)categoryId);
        meta.getPersistentDataContainer().set(itemKey, PersistentDataType.STRING, (Object)itemId);
        meta.getPersistentDataContainer().set(buttonTypeKey, PersistentDataType.STRING, (Object)"fullstack");
        meta.displayName(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.buttons.quantity")).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false));
        ArrayList<Object> lore = new ArrayList<Object>();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("quantity", String.valueOf(quantity));
        lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.selected_quantity", placeholders)).color((TextColor)NamedTextColor.AQUA)).decoration(TextDecoration.ITALIC, false));
        placeholders.clear();
        placeholders.put("price", String.format("%.2f", totalPrice));
        lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.total_price", placeholders)).color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
        if (this.plugin.getTaxManager().shouldShowTaxInLore()) {
            placeholders.clear();
            placeholders.put("tax", String.format("%.2f", taxAmount));
            lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.tax_included", placeholders)).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        }
        lore.add(Component.empty());
        lore.add(((TextComponent)Component.text((String)this.plugin.getLocaleManager().getMessage("shop.lore.click_full_stack")).color((TextColor)NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false));
        meta.lore(lore);
        quantityItem.setItemMeta(meta);
        menu.setItem(4, quantityItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQuantitySelectionClick(InventoryClickEvent event) {
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        if (event.getClickedInventory() == player.getInventory()) {
            return;
        }
        if (!this.quantityMenus.containsKey(event.getView().getTopInventory())) {
            return;
        }
        int slot = event.getSlot();
        Player player2 = player;
        synchronized (player2) {
            long currentTime = System.currentTimeMillis();
            Long lastClick = this.lastClickTime.get(player);
            if (lastClick != null && currentTime - lastClick < 250L) {
                this.debug("Click blocked due to cooldown for player: " + player.getName() + " at slot " + slot);
                return;
            }
            this.lastClickTime.put(player, currentTime);
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem == null || !clickedItem.hasItemMeta()) {
                return;
            }
            ItemMeta meta = clickedItem.getItemMeta();
            NamespacedKey buttonTypeKey = new NamespacedKey((Plugin)this.plugin, "button_type");
            NamespacedKey categoryKey = new NamespacedKey((Plugin)this.plugin, "category_id");
            String buttonType = (String)meta.getPersistentDataContainer().get(buttonTypeKey, PersistentDataType.STRING);
            if (buttonType == null) {
                return;
            }
            String categoryId = (String)meta.getPersistentDataContainer().get(categoryKey, PersistentDataType.STRING);
            if (categoryId == null) {
                return;
            }
            QuantitySelectionData data = this.quantitySelections.get(player);
            if (data == null || !data.categoryId.equals(categoryId)) {
                player.closeInventory();
                return;
            }
            switch (buttonType) {
                case "quantity": {
                    NamespacedKey changeKey = new NamespacedKey((Plugin)this.plugin, "quantity_change");
                    if (!meta.getPersistentDataContainer().has(changeKey, PersistentDataType.INTEGER)) break;
                    int change = (Integer)meta.getPersistentDataContainer().get(changeKey, PersistentDataType.INTEGER);
                    int currentStock = this.plugin.getDatabaseManager().getStock(data.categoryId, data.itemId);
                    int oldQuantity = data.quantity;
                    data.quantity = Math.max(1, Math.min(currentStock, data.quantity + change));
                    if (data.quantity != oldQuantity) {
                        this.debug("Quantity changed from " + oldQuantity + " to " + data.quantity + " for player: " + player.getName());
                        int newQuantity = data.quantity;
                        String catId = data.categoryId;
                        String itmId = data.itemId;
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.updateQuantityDisplay(event.getInventory(), newQuantity, catId, itmId));
                        break;
                    }
                    this.debug("Quantity unchanged (" + data.quantity + ") for player: " + player.getName());
                    break;
                }
                case "fullstack": {
                    int currentStock = this.plugin.getDatabaseManager().getStock(data.categoryId, data.itemId);
                    int fullStackQuantity = data.quantity = Math.min(64, currentStock);
                    String fullStackCatId = data.categoryId;
                    String fullStackItemId = data.itemId;
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        this.updateQuantityDisplay(event.getInventory(), fullStackQuantity, fullStackCatId, fullStackItemId);
                        this.changeFullStackButtonToPaper(event.getInventory(), fullStackCatId, fullStackItemId);
                    });
                    break;
                }
                case "confirm": {
                    String confirmCatId = data.categoryId;
                    String confirmItemId = data.itemId;
                    int confirmQuantity = data.quantity;
                    this.quantityMenus.remove(event.getView().getTopInventory());
                    player.closeInventory();
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        this.handleBuyTransaction(player, confirmCatId, confirmItemId, confirmQuantity);
                        this.quantitySelections.remove(player);
                    });
                    break;
                }
                case "back": {
                    String backCatId = categoryId;
                    this.quantityMenus.remove(event.getView().getTopInventory());
                    player.closeInventory();
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        this.quantitySelections.remove(player);
                        List<Inventory> pages = this.categoryPages.get(backCatId);
                        if (pages != null && !pages.isEmpty()) {
                            int page = this.currentPage.getOrDefault(player, 0);
                            page = Math.min(page, pages.size() - 1);
                            player.openInventory(pages.get(page));
                        } else {
                            this.openBuyMenu(player);
                        }
                    });
                }
            }
        }
    }

    private void changeFullStackButtonToPaper(Inventory inventory, String categoryId, String itemId) {
        ItemStack fullStackButton = inventory.getItem(4);
        if (fullStackButton != null && fullStackButton.hasItemMeta()) {
            ItemMeta meta = fullStackButton.getItemMeta();
            NamespacedKey buttonTypeKey = new NamespacedKey((Plugin)this.plugin, "button_type");
            String buttonType = (String)meta.getPersistentDataContainer().get(buttonTypeKey, PersistentDataType.STRING);
            if ("fullstack".equals(buttonType)) {
                ItemStack paperButton = new ItemStack(Material.PAPER);
                ItemMeta paperMeta = paperButton.getItemMeta();
                paperMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "category_id"), PersistentDataType.STRING, (Object)categoryId);
                paperMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "item_id"), PersistentDataType.STRING, (Object)itemId);
                paperMeta.getPersistentDataContainer().set(buttonTypeKey, PersistentDataType.STRING, (Object)"fullstack");
                paperMeta.displayName(meta.displayName());
                paperMeta.lore(meta.lore());
                paperButton.setItemMeta(paperMeta);
                inventory.setItem(4, paperButton);
            }
        }
    }

    private static class QuantitySelectionData {
        private final String categoryId;
        private final String itemId;
        private int quantity;

        public QuantitySelectionData(String categoryId, String itemId, int quantity) {
            this.categoryId = categoryId;
            this.itemId = itemId;
            this.quantity = quantity;
        }
    }
}

