/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.managers;

import amg.plugins.aMGShop.AMGShop;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final AMGShop plugin;
    private FileConfiguration config;
    private final Map<String, FileConfiguration> categoryConfigs;
    private FileConfiguration logs;
    private final File logsFile;

    public ConfigManager(AMGShop plugin) {
        this.plugin = plugin;
        this.categoryConfigs = new HashMap<String, FileConfiguration>();
        this.logsFile = new File(plugin.getDataFolder(), "logs.yml");
        this.reloadConfig();
    }

    private void loadCategoryConfigs() {
        File[] shopFiles;
        File shopsFolder = new File(this.plugin.getDataFolder(), "shops");
        if (!shopsFolder.exists()) {
            shopsFolder.mkdirs();
            this.saveDefaultShops();
        }
        if ((shopFiles = shopsFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"))) != null) {
            for (File file : shopFiles) {
                String categoryId = file.getName().substring(0, file.getName().length() - 4);
                this.categoryConfigs.put(categoryId, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
                this.plugin.getLogger().info("Loaded category file: " + file.getName());
            }
        }
    }

    private void saveDefaultShops() {
        String[] defaultCategories;
        for (String category : defaultCategories = new String[]{"blocks", "combat", "food", "tools", "redstone", "brewing", "decoration", "misc"}) {
            String resourcePath = "shops/" + category + ".yml";
            if (this.plugin.getResource(resourcePath) == null) continue;
            this.plugin.saveResource(resourcePath, false);
            this.plugin.getLogger().info("Created default shop category: " + category);
        }
    }

    private void loadLogs() {
        if (!this.logsFile.exists()) {
            try {
                this.logsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create logs.yml!");
                e.printStackTrace();
            }
        }
        this.logs = YamlConfiguration.loadConfiguration((File)this.logsFile);
    }

    public Set<String> getShopCategories() {
        return this.categoryConfigs.keySet();
    }

    public FileConfiguration getCategoryConfig(String category) {
        return this.categoryConfigs.get(category);
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.loadCategoryConfigs();
        this.loadLogs();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getLogs() {
        return this.logs;
    }

    public void saveLogs() {
        try {
            this.logs.save(this.logsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save logs.yml!");
            e.printStackTrace();
        }
    }

    public void archiveLogs(String archivePath, String section) {
        File archiveFile = new File(this.plugin.getDataFolder(), archivePath);
        if (!archiveFile.getParentFile().exists()) {
            archiveFile.getParentFile().mkdirs();
        }
        try {
            YamlConfiguration archive = new YamlConfiguration();
            archive.set(section, this.logs.get(section));
            archive.save(archiveFile);
            this.logs.set(section, null);
            this.saveLogs();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not archive logs to " + archivePath);
            e.printStackTrace();
        }
    }
}

