/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.managers;

import amg.plugins.aMGShop.AMGShop;
import java.lang.reflect.Method;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyManager {
    private final AMGShop plugin;
    private boolean amgCoreEnabled = false;
    private boolean vaultEnabled = false;
    private Economy vaultEconomy = null;
    private String priority = "auto";
    private boolean checkBalanceSync = true;

    public EconomyManager(AMGShop plugin) {
        this.plugin = plugin;
        this.loadConfig();
        if (this.hookIntoAMGCore()) {
            plugin.getLogger().info("Successfully hooked into AMGCore economy system!");
            this.amgCoreEnabled = true;
        } else {
            plugin.getLogger().warning("AMGCore not found or failed to hook into its economy system.");
        }
        if (this.hookIntoVault()) {
            plugin.getLogger().info("Successfully hooked into Vault economy system!");
            this.vaultEnabled = true;
        } else {
            plugin.getLogger().warning("Vault not found or failed to hook into an economy plugin.");
        }
        if (!this.amgCoreEnabled && !this.vaultEnabled) {
            plugin.getLogger().severe("No economy provider found! AMGShop requires either AMGCore or Vault with an economy plugin.");
            plugin.getLogger().severe("The plugin will be disabled.");
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        } else {
            Object providers = "";
            if (this.amgCoreEnabled) {
                providers = (String)providers + "AMGCore";
            }
            if (this.vaultEnabled) {
                if (!((String)providers).isEmpty()) {
                    providers = (String)providers + " and ";
                }
                providers = (String)providers + "Vault";
            }
            plugin.getLogger().info("Economy providers enabled: " + (String)providers);
            if (this.amgCoreEnabled && this.vaultEnabled) {
                plugin.getLogger().info("Economy priority: " + this.priority);
            }
        }
    }

    private void loadConfig() {
        this.priority = this.plugin.getConfig().getString("economy.priority", "auto").toLowerCase();
        if (!(this.priority.equals("auto") || this.priority.equals("amgcore_first") || this.priority.equals("vault_first"))) {
            this.plugin.getLogger().warning("Invalid economy priority setting: " + this.priority + ". Defaulting to 'auto'.");
            this.priority = "auto";
        }
        this.checkBalanceSync = this.plugin.getConfig().getBoolean("economy.check_balance_sync", true);
    }

    private boolean hookIntoAMGCore() {
        try {
            Plugin amgCore = this.plugin.getServer().getPluginManager().getPlugin("AMGCore");
            return amgCore != null && amgCore.isEnabled();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error while hooking into AMGCore", e);
            return false;
        }
    }

    private boolean hookIntoVault() {
        try {
            if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
                return false;
            }
            RegisteredServiceProvider economyProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
            if (economyProvider == null) {
                return false;
            }
            this.vaultEconomy = (Economy)economyProvider.getProvider();
            return this.vaultEconomy != null;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error while hooking into Vault", e);
            return false;
        }
    }

    public double getBalance(Player player) {
        double vaultBalance;
        double amgCoreBalance;
        Object playerData;
        boolean tryVaultFirst;
        double balance = 0.0;
        boolean success = false;
        boolean tryAMGCoreFirst = this.amgCoreEnabled && (this.priority.equals("auto") || this.priority.equals("amgcore_first"));
        boolean bl = tryVaultFirst = this.vaultEnabled && (this.priority.equals("vault_first") || this.priority.equals("auto") && !this.amgCoreEnabled);
        if (tryAMGCoreFirst) {
            playerData = this.getAMGCorePlayerData(player);
            if (playerData != null) {
                balance = this.getAMGCoreBalance(playerData);
                success = true;
            }
        } else if (tryVaultFirst && this.vaultEconomy != null) {
            balance = this.vaultEconomy.getBalance((OfflinePlayer)player);
            success = true;
        }
        if (!success) {
            if (tryAMGCoreFirst && this.vaultEnabled && this.vaultEconomy != null) {
                balance = this.vaultEconomy.getBalance((OfflinePlayer)player);
                success = true;
            } else if (tryVaultFirst && this.amgCoreEnabled && (playerData = this.getAMGCorePlayerData(player)) != null) {
                balance = this.getAMGCoreBalance(playerData);
                success = true;
            }
        }
        if (success && this.amgCoreEnabled && this.vaultEnabled && this.vaultEconomy != null && this.checkBalanceSync && (playerData = this.getAMGCorePlayerData(player)) != null && Math.abs((amgCoreBalance = this.getAMGCoreBalance(playerData)) - (vaultBalance = this.vaultEconomy.getBalance((OfflinePlayer)player))) > 0.01) {
            this.plugin.getLogger().warning("Balance discrepancy detected for " + player.getName() + ": AMGCore=" + amgCoreBalance + ", Vault=" + vaultBalance);
        }
        if (!success) {
            this.plugin.getLogger().warning("Failed to get balance for " + player.getName() + " from any economy provider!");
        }
        return balance;
    }

    public boolean withdrawMoney(Player player, double amount) {
        double currentBalance;
        Object playerData;
        boolean tryVaultFirst;
        boolean success = false;
        boolean tryAMGCoreFirst = this.amgCoreEnabled && (this.priority.equals("auto") || this.priority.equals("amgcore_first"));
        boolean bl = tryVaultFirst = this.vaultEnabled && (this.priority.equals("vault_first") || this.priority.equals("auto") && !this.amgCoreEnabled);
        if (tryAMGCoreFirst) {
            playerData = this.getAMGCorePlayerData(player);
            if (playerData != null && (currentBalance = this.getAMGCoreBalance(playerData)) >= amount) {
                this.setAMGCoreBalance(playerData, currentBalance - amount);
                success = true;
            }
        } else if (tryVaultFirst && this.vaultEconomy != null && this.vaultEconomy.has((OfflinePlayer)player, amount)) {
            this.vaultEconomy.withdrawPlayer((OfflinePlayer)player, amount);
            success = true;
        }
        if (this.amgCoreEnabled && this.vaultEnabled && this.vaultEconomy != null) {
            if (tryAMGCoreFirst && success) {
                if (this.vaultEconomy.has((OfflinePlayer)player, amount)) {
                    this.vaultEconomy.withdrawPlayer((OfflinePlayer)player, amount);
                } else if (this.checkBalanceSync) {
                    this.plugin.getLogger().warning("Balance discrepancy: " + player.getName() + " has insufficient funds in Vault but operation proceeded with AMGCore.");
                }
            } else if (tryVaultFirst && success && (playerData = this.getAMGCorePlayerData(player)) != null) {
                currentBalance = this.getAMGCoreBalance(playerData);
                if (currentBalance >= amount) {
                    this.setAMGCoreBalance(playerData, currentBalance - amount);
                } else if (this.checkBalanceSync) {
                    this.plugin.getLogger().warning("Balance discrepancy: " + player.getName() + " has insufficient funds in AMGCore but operation proceeded with Vault.");
                }
            }
        }
        if (!success) {
            if (tryAMGCoreFirst && this.vaultEnabled && this.vaultEconomy != null) {
                if (this.vaultEconomy.has((OfflinePlayer)player, amount)) {
                    this.vaultEconomy.withdrawPlayer((OfflinePlayer)player, amount);
                    success = true;
                }
            } else if (tryVaultFirst && this.amgCoreEnabled && (playerData = this.getAMGCorePlayerData(player)) != null && (currentBalance = this.getAMGCoreBalance(playerData)) >= amount) {
                this.setAMGCoreBalance(playerData, currentBalance - amount);
                success = true;
            }
        }
        if (!success) {
            this.plugin.getLogger().warning("Failed to withdraw " + amount + " from " + player.getName() + " using any economy provider!");
        }
        return success;
    }

    public boolean depositMoney(Player player, double amount) {
        double currentBalance;
        Object playerData;
        boolean tryVaultFirst;
        boolean success = false;
        boolean tryAMGCoreFirst = this.amgCoreEnabled && (this.priority.equals("auto") || this.priority.equals("amgcore_first"));
        boolean bl = tryVaultFirst = this.vaultEnabled && (this.priority.equals("vault_first") || this.priority.equals("auto") && !this.amgCoreEnabled);
        if (tryAMGCoreFirst) {
            playerData = this.getAMGCorePlayerData(player);
            if (playerData != null) {
                currentBalance = this.getAMGCoreBalance(playerData);
                this.setAMGCoreBalance(playerData, currentBalance + amount);
                success = true;
            }
        } else if (tryVaultFirst && this.vaultEconomy != null) {
            this.vaultEconomy.depositPlayer((OfflinePlayer)player, amount);
            success = true;
        }
        if (this.amgCoreEnabled && this.vaultEnabled && this.vaultEconomy != null) {
            if (tryAMGCoreFirst && success) {
                this.vaultEconomy.depositPlayer((OfflinePlayer)player, amount);
            } else if (tryVaultFirst && success && (playerData = this.getAMGCorePlayerData(player)) != null) {
                currentBalance = this.getAMGCoreBalance(playerData);
                this.setAMGCoreBalance(playerData, currentBalance + amount);
            }
        }
        if (!success) {
            if (tryAMGCoreFirst && this.vaultEnabled && this.vaultEconomy != null) {
                this.vaultEconomy.depositPlayer((OfflinePlayer)player, amount);
                success = true;
            } else if (tryVaultFirst && this.amgCoreEnabled && (playerData = this.getAMGCorePlayerData(player)) != null) {
                currentBalance = this.getAMGCoreBalance(playerData);
                this.setAMGCoreBalance(playerData, currentBalance + amount);
                success = true;
            }
        }
        if (!success) {
            this.plugin.getLogger().warning("Failed to deposit " + amount + " to " + player.getName() + " using any economy provider!");
        }
        return success;
    }

    public boolean hasEnoughMoney(Player player, double amount) {
        Object playerData;
        boolean tryVaultFirst;
        boolean hasEnough = false;
        boolean checked = false;
        boolean tryAMGCoreFirst = this.amgCoreEnabled && (this.priority.equals("auto") || this.priority.equals("amgcore_first"));
        boolean bl = tryVaultFirst = this.vaultEnabled && (this.priority.equals("vault_first") || this.priority.equals("auto") && !this.amgCoreEnabled);
        if (tryAMGCoreFirst) {
            playerData = this.getAMGCorePlayerData(player);
            if (playerData != null) {
                hasEnough = this.getAMGCoreBalance(playerData) >= amount;
                checked = true;
            }
        } else if (tryVaultFirst && this.vaultEconomy != null) {
            hasEnough = this.vaultEconomy.has((OfflinePlayer)player, amount);
            checked = true;
        }
        if (checked && hasEnough && this.amgCoreEnabled && this.vaultEnabled && this.vaultEconomy != null && this.checkBalanceSync) {
            boolean amgCoreHasEnough = false;
            boolean vaultHasEnough = false;
            Object playerData2 = this.getAMGCorePlayerData(player);
            if (playerData2 != null) {
                boolean bl2 = amgCoreHasEnough = this.getAMGCoreBalance(playerData2) >= amount;
            }
            if (amgCoreHasEnough != (vaultHasEnough = this.vaultEconomy.has((OfflinePlayer)player, amount))) {
                this.plugin.getLogger().warning("Balance discrepancy detected for " + player.getName() + ": AMGCore has enough=" + amgCoreHasEnough + ", Vault has enough=" + vaultHasEnough);
            }
        }
        if (!checked) {
            if (tryAMGCoreFirst && this.vaultEnabled && this.vaultEconomy != null) {
                hasEnough = this.vaultEconomy.has((OfflinePlayer)player, amount);
                checked = true;
            } else if (tryVaultFirst && this.amgCoreEnabled && (playerData = this.getAMGCorePlayerData(player)) != null) {
                hasEnough = this.getAMGCoreBalance(playerData) >= amount;
                checked = true;
            }
        }
        if (!checked) {
            this.plugin.getLogger().warning("Failed to check if " + player.getName() + " has enough money using any economy provider!");
        }
        return hasEnough;
    }

    public String formatMoney(double amount) {
        if (this.vaultEnabled && this.vaultEconomy != null) {
            return this.vaultEconomy.format(amount);
        }
        return String.format("$%.2f", amount);
    }

    private Object getAMGCorePlayerData(Player player) {
        try {
            Plugin amgCore = this.plugin.getServer().getPluginManager().getPlugin("AMGCore");
            if (amgCore == null) {
                return null;
            }
            Method getPlayerDataManager = amgCore.getClass().getMethod("getPlayerDataManager", new Class[0]);
            Object playerDataManager = getPlayerDataManager.invoke((Object)amgCore, new Object[0]);
            Method getPlayerData = playerDataManager.getClass().getMethod("getPlayerData", Player.class);
            return getPlayerData.invoke(playerDataManager, player);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to get player data from AMGCore", e);
            return null;
        }
    }

    private double getAMGCoreBalance(Object playerData) {
        try {
            Method getMoney = playerData.getClass().getMethod("getMoney", new Class[0]);
            return (Double)getMoney.invoke(playerData, new Object[0]);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to get player money from AMGCore", e);
            return 0.0;
        }
    }

    private void setAMGCoreBalance(Object playerData, double amount) {
        try {
            Method setMoney = playerData.getClass().getMethod("setMoney", Double.TYPE);
            setMoney.invoke(playerData, amount);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to set player money in AMGCore", e);
        }
    }

    public boolean isAMGCoreEnabled() {
        return this.amgCoreEnabled;
    }

    public boolean isVaultEnabled() {
        return this.vaultEnabled && this.vaultEconomy != null;
    }
}

