/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.managers;

import amg.plugins.aMGShop.AMGShop;
import amg.plugins.aMGShop.managers.ShopManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;

public class ExploitChecker {
    private final AMGShop plugin;
    private final Map<Material, List<CraftingExploit>> potentialExploits;
    private final Map<Material, Double> materialBuyPrices;
    private final Map<Material, Double> materialSellPrices;

    public ExploitChecker(AMGShop plugin) {
        this.plugin = plugin;
        this.potentialExploits = new HashMap<Material, List<CraftingExploit>>();
        this.materialBuyPrices = new HashMap<Material, Double>();
        this.materialSellPrices = new HashMap<Material, Double>();
    }

    public void checkForExploits() {
        this.potentialExploits.clear();
        this.materialBuyPrices.clear();
        this.materialSellPrices.clear();
        this.loadMaterialPrices();
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            try {
                Recipe recipe = (Recipe)recipeIterator.next();
                this.checkRecipe(recipe);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error checking recipe for exploits", e);
            }
        }
        this.logExploits();
    }

    private void loadMaterialPrices() {
        Map<String, Map<String, ShopManager.ShopItem>> categories = this.plugin.getShopManager().getCategories();
        for (Map.Entry<String, Map<String, ShopManager.ShopItem>> category : categories.entrySet()) {
            for (Map.Entry<String, ShopManager.ShopItem> item : category.getValue().entrySet()) {
                Material material = item.getValue().getMaterial();
                String categoryId = category.getKey();
                String itemId = item.getKey();
                double buyPrice = this.plugin.getShopManager().calculateBuyPrice(categoryId, itemId, 1);
                double sellPrice = this.plugin.getShopManager().calculateSellPrice(categoryId, itemId, 1);
                this.materialBuyPrices.put(material, buyPrice);
                this.materialSellPrices.put(material, sellPrice);
            }
        }
    }

    private void checkRecipe(Recipe recipe) {
        ItemStack result = recipe.getResult();
        Material resultMaterial = result.getType();
        if (!this.materialSellPrices.containsKey(resultMaterial)) {
            return;
        }
        HashMap<Material, Integer> ingredients = new HashMap<Material, Integer>();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            String[] shape = shapedRecipe.getShape();
            Map choiceMap = shapedRecipe.getChoiceMap();
            for (String row : shape) {
                for (char c : row.toCharArray()) {
                    RecipeChoice.MaterialChoice materialChoice;
                    RecipeChoice choice = (RecipeChoice)choiceMap.get(Character.valueOf(c));
                    if (!(choice instanceof RecipeChoice.MaterialChoice) || (materialChoice = (RecipeChoice.MaterialChoice)choice).getChoices().isEmpty()) continue;
                    ingredients.merge((Material)materialChoice.getChoices().get(0), 1, Integer::sum);
                }
            }
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            for (RecipeChoice choice : shapelessRecipe.getChoiceList()) {
                RecipeChoice.MaterialChoice materialChoice;
                if (!(choice instanceof RecipeChoice.MaterialChoice) || (materialChoice = (RecipeChoice.MaterialChoice)choice).getChoices().isEmpty()) continue;
                ingredients.merge((Material)materialChoice.getChoices().get(0), 1, Integer::sum);
            }
        } else if (recipe instanceof FurnaceRecipe) {
            FurnaceRecipe furnaceRecipe = (FurnaceRecipe)recipe;
            this.handleCookingRecipeInput(furnaceRecipe.getInputChoice(), ingredients);
        } else if (recipe instanceof BlastingRecipe) {
            BlastingRecipe blastingRecipe = (BlastingRecipe)recipe;
            this.handleCookingRecipeInput(blastingRecipe.getInputChoice(), ingredients);
        } else if (recipe instanceof CampfireRecipe) {
            CampfireRecipe campfireRecipe = (CampfireRecipe)recipe;
            this.handleCookingRecipeInput(campfireRecipe.getInputChoice(), ingredients);
        } else if (recipe instanceof SmokingRecipe) {
            SmokingRecipe smokingRecipe = (SmokingRecipe)recipe;
            this.handleCookingRecipeInput(smokingRecipe.getInputChoice(), ingredients);
        } else if (recipe instanceof StonecuttingRecipe) {
            StonecuttingRecipe stonecuttingRecipe = (StonecuttingRecipe)recipe;
            this.handleCookingRecipeInput(stonecuttingRecipe.getInputChoice(), ingredients);
        } else if (recipe instanceof SmithingRecipe) {
            SmithingRecipe smithingRecipe = (SmithingRecipe)recipe;
            RecipeChoice.MaterialChoice baseChoice = (RecipeChoice.MaterialChoice)smithingRecipe.getBase();
            RecipeChoice.MaterialChoice additionChoice = (RecipeChoice.MaterialChoice)smithingRecipe.getAddition();
            if (!baseChoice.getChoices().isEmpty()) {
                ingredients.put((Material)baseChoice.getChoices().get(0), 1);
            }
            if (!additionChoice.getChoices().isEmpty()) {
                ingredients.put((Material)additionChoice.getChoices().get(0), 1);
            }
        }
        double totalBuyCost = 0.0;
        boolean allIngredientsInShop = true;
        for (Map.Entry entry : ingredients.entrySet()) {
            Material material = (Material)entry.getKey();
            int amount = (Integer)entry.getValue();
            if (!this.materialBuyPrices.containsKey(material)) {
                allIngredientsInShop = false;
                break;
            }
            totalBuyCost += this.materialBuyPrices.get(material) * (double)amount;
        }
        if (!allIngredientsInShop) {
            return;
        }
        double resultSellPrice = this.materialSellPrices.get(resultMaterial) * (double)result.getAmount();
        double profit = resultSellPrice - totalBuyCost;
        if (profit > 0.01) {
            CraftingExploit exploit = new CraftingExploit(recipe, ingredients, totalBuyCost, resultSellPrice, profit);
            this.potentialExploits.computeIfAbsent(resultMaterial, k -> new ArrayList()).add(exploit);
        }
    }

    private void handleCookingRecipeInput(RecipeChoice choice, Map<Material, Integer> ingredients) {
        RecipeChoice.MaterialChoice materialChoice;
        if (choice instanceof RecipeChoice.MaterialChoice && !(materialChoice = (RecipeChoice.MaterialChoice)choice).getChoices().isEmpty()) {
            ingredients.put((Material)materialChoice.getChoices().get(0), 1);
        }
    }

    private void logExploits() {
        if (this.potentialExploits.isEmpty()) {
            this.plugin.getLogger().info("No crafting exploits found!");
            return;
        }
        this.plugin.getLogger().warning("Found potential crafting exploits:");
        for (Map.Entry<Material, List<CraftingExploit>> entry : this.potentialExploits.entrySet()) {
            Material resultMaterial = entry.getKey();
            List<CraftingExploit> exploits = entry.getValue();
            for (CraftingExploit exploit : exploits) {
                StringBuilder message = new StringBuilder();
                message.append("\nResult: ").append(resultMaterial.name());
                message.append("\nIngredients:");
                for (Map.Entry<Material, Integer> ingredient : exploit.ingredients().entrySet()) {
                    message.append("\n  - ").append(ingredient.getValue()).append("x ").append(ingredient.getKey().name()).append(" ($").append(String.format("%.2f", this.materialBuyPrices.get(ingredient.getKey()))).append(" each)");
                }
                message.append("\nTotal Cost: $").append(String.format("%.2f", exploit.totalCost()));
                message.append("\nSell Price: $").append(String.format("%.2f", exploit.sellPrice()));
                message.append("\nProfit: $").append(String.format("%.2f", exploit.profit()));
                message.append("\n");
                this.plugin.getLogger().warning(message.toString());
            }
        }
    }

    public Map<Material, List<CraftingExploit>> getPotentialExploits() {
        return Collections.unmodifiableMap(this.potentialExploits);
    }

    public record CraftingExploit(Recipe recipe, Map<Material, Integer> ingredients, double totalCost, double sellPrice, double profit) {
    }
}

