/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.managers;

import amg.plugins.aMGShop.AMGShop;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LocaleManager {
    private final AMGShop plugin;
    private final File localeFolder;
    private FileConfiguration locale;
    private String currentLanguage;
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("%([^%]+)%");

    public LocaleManager(AMGShop plugin) {
        this.plugin = plugin;
        this.localeFolder = new File(plugin.getDataFolder(), "locales");
        this.setupLocale();
    }

    private void setupLocale() {
        if (!this.localeFolder.exists()) {
            this.localeFolder.mkdirs();
            this.saveDefaultLocales();
        }
        this.currentLanguage = this.plugin.getConfig().getString("locale.language", "en_US");
        this.loadLanguage(this.currentLanguage);
    }

    private void saveDefaultLocales() {
        this.saveResource("en_US.yml");
        this.saveResource("bg_BG.yml");
    }

    private void saveResource(String fileName) {
        File file = new File(this.localeFolder, fileName);
        if (!file.exists()) {
            this.plugin.saveResource("locales/" + fileName, false);
            this.plugin.getLogger().info("Created locale file: " + fileName);
        }
    }

    public void loadLanguage(String language) {
        File localeFile = new File(this.localeFolder, language + ".yml");
        if (!localeFile.exists()) {
            this.plugin.getLogger().warning("Locale file not found: " + language + ".yml");
            this.plugin.getLogger().warning("Falling back to en_US");
            localeFile = new File(this.localeFolder, "en_US.yml");
            if (!localeFile.exists()) {
                this.saveResource("en_US.yml");
            }
            this.currentLanguage = "en_US";
        } else {
            this.currentLanguage = language;
        }
        this.locale = YamlConfiguration.loadConfiguration((File)localeFile);
        this.plugin.getLogger().info("Loaded locale: " + this.currentLanguage);
    }

    public String getMessage(String path) {
        return this.getMessage(path, new HashMap<String, String>());
    }

    public String getMessage(String path, Map<String, String> placeholders) {
        String message = this.locale.getString(path);
        if (message == null) {
            this.plugin.getLogger().warning("Missing locale message: " + path);
            return "Missing message: " + path;
        }
        if (!placeholders.isEmpty()) {
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(message);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String placeholder = matcher.group(1);
                String replacement = placeholders.getOrDefault(placeholder, matcher.group());
                matcher.appendReplacement(buffer, Matcher.quoteReplacement(replacement));
            }
            matcher.appendTail(buffer);
            message = buffer.toString();
        }
        return message.replace("&", "\u00a7");
    }

    public void reload() {
        this.currentLanguage = this.plugin.getConfig().getString("locale.language", "en_US");
        this.loadLanguage(this.currentLanguage);
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public void setLanguage(String language) {
        this.loadLanguage(language);
        this.plugin.getConfig().set("locale.language", (Object)language);
        this.plugin.saveConfig();
    }

    public FileConfiguration getLocale() {
        return this.locale;
    }
}

