/*
 * Decompiled with CFR 0.152.
 */
package amg.plugins.aMGShop.managers;

import amg.plugins.aMGShop.AMGShop;
import java.util.HashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class TaxManager {
    private final AMGShop plugin;
    private double collectedTaxes;
    private final double buyTaxRate;
    private final double sellTaxRate;
    private final boolean showTaxInLore;

    public TaxManager(AMGShop plugin) {
        this.plugin = plugin;
        this.collectedTaxes = 0.0;
        this.buyTaxRate = plugin.getConfig().getDouble("shop.tax.buy_tax", 20.0) / 100.0;
        this.sellTaxRate = plugin.getConfig().getDouble("shop.tax.sell_tax", 20.0) / 100.0;
        this.showTaxInLore = plugin.getConfig().getBoolean("shop.tax.show_tax_in_lore", true);
    }

    public double calculateBuyTax(double price) {
        return price * this.buyTaxRate;
    }

    public double calculateSellTax(double price) {
        return price * this.sellTaxRate;
    }

    public double getBuyPriceMultiplier() {
        return 1.0 + this.buyTaxRate;
    }

    public double getSellPriceMultiplier() {
        return 1.0 - this.sellTaxRate;
    }

    public void addTax(double amount) {
        this.collectedTaxes += amount;
    }

    public double collectTaxes(Player player) {
        if (!this.isOwner(player)) {
            player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("tax.not_owner")));
            return 0.0;
        }
        if (this.collectedTaxes <= 0.0) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", "0.00");
            player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("tax.no_taxes", placeholders)));
            return 0.0;
        }
        double amount = this.collectedTaxes;
        this.collectedTaxes = 0.0;
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("amount", String.format("%.2f", amount));
        player.sendMessage((Component)Component.text((String)this.plugin.getLocaleManager().getMessage("tax.collected", placeholders)));
        return amount;
    }

    public double getCollectedTaxes() {
        return this.collectedTaxes;
    }

    public boolean shouldShowTaxInLore() {
        return this.showTaxInLore;
    }

    public boolean isOwner(Player player) {
        String ownerUUID = this.plugin.getConfig().getString("shop.owner.uuid", "");
        return player.getUniqueId().toString().equals(ownerUUID);
    }
}

