/*
 * Decompiled with CFR 0.152.
 */
package net.alex.alarmmod.block.entity;

import net.alex.alarmmod.block.custom.SmokeDetectorBlock;
import net.alex.alarmmod.block.entity.AbstractAlarmBlockEntity;
import net.alex.alarmmod.block.entity.ModBlockEntities;
import net.alex.alarmmod.sound.ModSounds;
import net.alex.alarmmod.sound.SoundUtil;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;

public class SmokeDetectorBlockEntity
extends AbstractAlarmBlockEntity {
    private final SoundUtil soundUtil;
    int fireTicks = 0;
    FireEnum fireDistance = FireEnum.BELOW;

    public SmokeDetectorBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.SMOKE_DETECTOR_BLOCK_ENTITY, pos, state, ModSounds.SMOKE_ALARM);
        this.soundUtil = new SoundUtil(ModSounds.SMOKE_ALARM);
    }

    @Override
    public void start(class_1937 world) {
        this.REPEAT_TICKS = this.soundUtil.getLengthTicks();
        super.start(world);
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, SmokeDetectorBlockEntity be) {
        if (world.field_9236) {
            return;
        }
        boolean fireFound = false;
        class_2338 center = pos;
        int radius = 4;
        int height = 4;
        for (int y = 1; y <= height; ++y) {
            block6: for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 checkPos = center.method_10069(x, -y, z);
                    class_2680 fireState = world.method_8320(checkPos);
                    if (!fireState.method_27852(class_2246.field_10036)) continue;
                    int dx = checkPos.method_10263() - center.method_10263();
                    int dz = checkPos.method_10260() - center.method_10260();
                    int distance = Math.abs(dx) + Math.abs(dz);
                    switch (distance) {
                        case 0: 
                        case 1: {
                            be.fireDistance = FireEnum.BELOW;
                            break;
                        }
                        case 2: 
                        case 3: {
                            be.fireDistance = FireEnum.CLOSE;
                            break;
                        }
                        case 4: {
                            be.fireDistance = FireEnum.FAR;
                        }
                    }
                    fireFound = true;
                    continue block6;
                }
            }
        }
        if (fireFound) {
            ++be.fireTicks;
            if (!be.isPlaying() && be.fireTicks >= be.fireDistance.ticks) {
                be.fireTicks = 0;
                be.tickCounter = 0;
                be.start(world);
            }
        }
        if (!be.playing) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)SmokeDetectorBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)));
            return;
        }
        ++be.tickCounter;
        if (be.tickCounter / 15 % 2 == 0) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)SmokeDetectorBlock.ACTIVATED, (Comparable)Boolean.valueOf(true)));
        } else {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)SmokeDetectorBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)));
        }
        if (be.tickCounter >= be.REPEAT_TICKS) {
            be.tickCounter = 0;
            world.method_8396(null, pos, be.alarmSound, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    static enum FireEnum {
        BELOW(40),
        CLOSE(55),
        FAR(70);

        public final int ticks;

        private FireEnum(int ticks) {
            this.ticks = ticks;
        }
    }
}

