/*
 * Decompiled with CFR 0.152.
 */
package timmychips.modefiteitemdefinitions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import timmychips.modefiteitemdefinitions.UseKeyTracker;
import timmychips.modefiteitemdefinitions.property.registry.ConditionPropertyRegistry;
import timmychips.modefiteitemdefinitions.property.registry.RangePropertyRegistry;
import timmychips.modefiteitemdefinitions.property.registry.SelectPropertyRegistry;
import timmychips.modefiteitemdefinitions.property.type.ItemModelTypes;
import timmychips.modefiteitemdefinitions.property.type.codec.ItemModelDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.ItemModelRootDefinition;

@Environment(value=EnvType.CLIENT)
public class ClientInitializer
implements ClientModInitializer {
    public static final String MOD_ID = "modefite";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static Collection<class_2960> modelIds;
    private static final String HAND_ANIMATION_SWAP = "hand_animation_on_swap";
    private static final String OVERSIZED_IN_GUI = "oversized_in_gui";
    private static final String SWAP_ANIMATION_SCALE = "swap_animation_scale";

    private static void registerResources(String folderName, class_3300 manager) {
        for (class_2960 id : manager.method_14488(folderName, path -> path.method_12832().endsWith(".json")).keySet()) {
            try {
                InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(stream));
                    JsonObject root = json.getAsJsonObject();
                    boolean handAnimationOnSwap = !root.has(HAND_ANIMATION_SWAP) || root.get(HAND_ANIMATION_SWAP).getAsBoolean();
                    boolean oversizedInGui = root.has(OVERSIZED_IN_GUI) && root.get(OVERSIZED_IN_GUI).getAsBoolean();
                    float swapAnimationScale = root.has(SWAP_ANIMATION_SCALE) ? root.get(SWAP_ANIMATION_SCALE).getAsFloat() : 1.0f;
                    JsonElement modelElement = root.get("model");
                    if (modelElement != null && modelElement.isJsonObject()) {
                        ItemModelTypes.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)modelElement).resultOrPartial(error -> LOGGER.warn("Failed to decode model definition for {}: {}", (Object)id, error)).ifPresent(pair -> {
                            String cleanPath = id.method_12832().substring((folderName + "/").length(), id.method_12832().length() - ".json".length());
                            class_2960 itemId = new class_2960(id.method_12836(), cleanPath);
                            ItemModelDefinition definition = (ItemModelDefinition)pair.getFirst();
                            ItemModelRootDefinition rootDef = new ItemModelRootDefinition(definition, handAnimationOnSwap, oversizedInGui, swapAnimationScale);
                            ItemModelTypes.Registry.putRoot(itemId, rootDef);
                        });
                        continue;
                    }
                    LOGGER.warn("No 'model' field found in item JSON for {}", (Object)id);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse item definition for {}", (Object)id, (Object)e);
            }
        }
    }

    public void onInitializeClient() {
        UseKeyTracker.receiveUseKeyPacket();
        UseKeyTracker.clientUseKey();
        UseKeyTracker.eventUseKeyPacket();
        ModelLoadingPlugin.register(pluginContext -> {
            class_3300 manager = class_310.method_1551().method_1478();
            ItemModelTypes.Registry.clear();
            RangePropertyRegistry.init();
            ConditionPropertyRegistry.init();
            SelectPropertyRegistry.init();
            ClientInitializer.registerResources("items", manager);
            String overrideFolderName = "modefite_items_override";
            ClientInitializer.registerResources(overrideFolderName, manager);
            modelIds = ItemModelTypes.Registry.getAllModelDependencies();
            LOGGER.info("{}: loading models", (Object)MOD_ID.toUpperCase());
            pluginContext.addModels(modelIds);
        });
    }
}

