/*
 * Decompiled with CFR 0.152.
 */
package timmychips.modefiteitemdefinitions.comp;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class CodecHelper {
    public static <A> Codec<A> lazyInitialized(Supplier<Codec<A>> codecSupplier) {
        return new LazyCodec<A>(codecSupplier);
    }

    @Environment(value=EnvType.CLIENT)
    private static class LazyCodec<A>
    implements Codec<A> {
        private final Supplier<Codec<A>> codecSupplier;
        private volatile Codec<A> codec;

        public LazyCodec(Supplier<Codec<A>> codecSupplier) {
            this.codecSupplier = codecSupplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Codec<A> getCodec() {
            if (this.codec == null) {
                LazyCodec lazyCodec = this;
                synchronized (lazyCodec) {
                    if (this.codec == null) {
                        this.codec = this.codecSupplier.get();
                    }
                }
            }
            return this.codec;
        }

        public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
            return this.getCodec().encode(input, ops, prefix);
        }

        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
            return this.getCodec().decode(ops, input);
        }

        public String toString() {
            return "LazyCodec[" + (this.codec != null ? this.codec.toString() : "uninitialized") + "]";
        }
    }
}

