/*
 * Decompiled with CFR 0.152.
 */
package timmychips.modefiteitemdefinitions.comp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import timmychips.modefiteitemdefinitions.comp.ComponentType;

@Environment(value=EnvType.CLIENT)
public class ComponentChanges {
    private final Map<String, class_2520> additions;
    private final Set<String> removals;

    private ComponentChanges(Map<String, class_2520> additions, Set<String> removals) {
        this.additions = additions;
        this.removals = removals;
    }

    public Set<String> getAdditions() {
        return this.additions.keySet();
    }

    public Set<String> getRemovals() {
        return this.removals;
    }

    @Nullable
    public class_2520 get(String key) {
        return this.additions.get(key);
    }

    public boolean hasAddition(String key) {
        return this.additions.containsKey(key);
    }

    public boolean hasRemoval(String key) {
        return this.removals.contains(key);
    }

    public boolean isEmpty() {
        return this.additions.isEmpty() && this.removals.isEmpty();
    }

    public Set<Map.Entry<String, class_2520>> entrySet() {
        return this.additions.entrySet();
    }

    public void applyTo(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        for (Map.Entry<String, class_2520> entry : this.additions.entrySet()) {
            String key = entry.getKey();
            class_2520 value = entry.getValue();
            if (key.contains(".")) {
                String[] parts = key.split("\\.", 2);
                class_2487 nested = nbt.method_10562(parts[0]);
                if (nested.method_33133() && !nbt.method_10545(parts[0])) {
                    nbt.method_10566(parts[0], (class_2520)nested);
                }
                nested.method_10566(parts[1], value);
                continue;
            }
            nbt.method_10566(key, value);
        }
        for (String key : this.removals) {
            if (key.contains(".")) {
                String[] parts = key.split("\\.", 2);
                if (!nbt.method_10573(parts[0], 10)) continue;
                class_2487 nested = nbt.method_10562(parts[0]);
                nested.method_10551(parts[1]);
                continue;
            }
            nbt.method_10551(key);
        }
    }

    public static ComponentChanges fromStack(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        HashMap<String, class_2520> additions = new HashMap<String, class_2520>();
        if (nbt != null) {
            for (String key : nbt.method_10541()) {
                additions.put(key, nbt.method_10580(key).method_10707());
            }
            if (nbt.method_10573("display", 10)) {
                class_2487 display = nbt.method_10562("display");
                for (String key : display.method_10541()) {
                    additions.put("display." + key, display.method_10580(key).method_10707());
                }
            }
        }
        return new ComponentChanges(additions, new HashSet<String>());
    }

    public static ComponentChanges empty() {
        return new ComponentChanges(new HashMap<String, class_2520>(), new HashSet<String>());
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ComponentChanges{additions=" + String.valueOf(this.additions.keySet()) + ", removals=" + String.valueOf(this.removals) + "}";
    }

    @Environment(value=EnvType.CLIENT)
    public static class Builder {
        private final Map<String, class_2520> additions = new HashMap<String, class_2520>();
        private final Set<String> removals = new HashSet<String>();

        public Builder add(ComponentType<Integer> type, int value) {
            this.additions.put(type.getNbtKey(), (class_2520)class_2497.method_23247((int)value));
            this.removals.remove(type.getNbtKey());
            return this;
        }

        public Builder add(ComponentType<String> type, String value) {
            this.additions.put(type.getNbtKey(), (class_2520)class_2519.method_23256((String)value));
            this.removals.remove(type.getNbtKey());
            return this;
        }

        public Builder add(ComponentType<Boolean> type, boolean value) {
            class_2487 temp = new class_2487();
            temp.method_10556("temp", value);
            this.additions.put(type.getNbtKey(), temp.method_10580("temp"));
            this.removals.remove(type.getNbtKey());
            return this;
        }

        public Builder add(ComponentType<String> type, class_2561 text) {
            this.additions.put(type.getNbtKey(), (class_2520)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)text)));
            this.removals.remove(type.getNbtKey());
            return this;
        }

        public <T extends class_2520> Builder add(ComponentType<T> type, T value) {
            this.additions.put(type.getNbtKey(), value);
            this.removals.remove(type.getNbtKey());
            return this;
        }

        public Builder remove(ComponentType<?> type) {
            this.removals.add(type.getNbtKey());
            this.additions.remove(type.getNbtKey());
            return this;
        }

        public Builder add(String key, class_2520 value) {
            this.additions.put(key, value);
            this.removals.remove(key);
            return this;
        }

        public Builder addInt(String key, int value) {
            this.additions.put(key, (class_2520)class_2497.method_23247((int)value));
            this.removals.remove(key);
            return this;
        }

        public Builder addString(String key, String value) {
            this.additions.put(key, (class_2520)class_2519.method_23256((String)value));
            this.removals.remove(key);
            return this;
        }

        public Builder addBoolean(String key, boolean value) {
            class_2487 temp = new class_2487();
            temp.method_10556("temp", value);
            this.additions.put(key, temp.method_10580("temp"));
            this.removals.remove(key);
            return this;
        }

        public Builder remove(String key) {
            this.removals.add(key);
            this.additions.remove(key);
            return this;
        }

        public ComponentChanges build() {
            return new ComponentChanges(new HashMap<String, class_2520>(this.additions), new HashSet<String>(this.removals));
        }
    }
}

