/*
 * Decompiled with CFR 0.152.
 */
package timmychips.modefiteitemdefinitions.comp;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ComponentType<T> {
    private final class_2960 id;
    private final String nbtKey;
    private final int nbtType;
    private static final Map<class_2960, ComponentType<?>> REGISTRY = new HashMap();
    public static final ComponentType<Integer> CUSTOM_MODEL_DATA = ComponentType.register("minecraft:custom_model_data", "CustomModelData", 3);
    public static final ComponentType<String> CUSTOM_NAME = ComponentType.register("minecraft:custom_name", "display.Name", 8);
    public static final ComponentType<class_2520> LORE = ComponentType.register("minecraft:lore", "display.Lore", 9);
    public static final ComponentType<Integer> COLOR = ComponentType.register("minecraft:dyed_color", "color", 3);
    public static final ComponentType<Integer> DAMAGE = ComponentType.register("minecraft:damage", "Damage", 3);
    public static final ComponentType<Integer> MAX_DAMAGE = ComponentType.register("minecraft:max_damage", "MaxDamage", 3);
    public static final ComponentType<Boolean> UNBREAKABLE = ComponentType.register("minecraft:unbreakable", "Unbreakable", 1);
    public static final ComponentType<class_2487> BLOCK_STATE = ComponentType.register("minecraft:block_state", "block_state", 10);
    public static final ComponentType<class_2520> ENCHANTMENTS = ComponentType.register("minecraft:enchantments", "Enchantments", 9);
    public static final ComponentType<class_2520> STORED_ENCHANTMENTS = ComponentType.register("minecraft:stored_enchantments", "StoredEnchantments", 9);
    public static final ComponentType<class_2487> TRIM = ComponentType.register("minecraft:trim", "Trim", 10);
    public static final ComponentType<class_2487> LODESTONE_TRACKER = ComponentType.register("minecraft:lodestone_tracker", "lodestone_tracker", 10);
    public static final ComponentType<class_2487> BUCKET_ENTITY_DATA = ComponentType.register("minecraft:bucket_entity_data", "BucketVariantTag", 10);
    public static final ComponentType<String> POTION_CONTENTS = ComponentType.register("minecraft:potion_contents", "Potion", 8);
    public static final ComponentType<Integer> CUSTOM_POTION_COLOR = ComponentType.register("minecraft:custom_potion_color", "CustomPotionColor", 3);
    public static final ComponentType<class_2520> WRITTEN_BOOK_CONTENT = ComponentType.register("minecraft:written_book_content", "pages", 9);
    public static final ComponentType<class_2487> FIREWORKS = ComponentType.register("minecraft:fireworks", "Fireworks", 10);
    public static final ComponentType<Integer> MAP_ID = ComponentType.register("minecraft:map_id", "map", 3);
    public static final ComponentType<class_2487> PROFILE = ComponentType.register("minecraft:profile", "SkullOwner", 10);
    public static final ComponentType<Integer> HIDE_FLAGS = ComponentType.register("minecraft:hide_additional_tooltip", "HideFlags", 3);
    public static final ComponentType<Integer> REPAIR_COST = ComponentType.register("minecraft:repair_cost", "RepairCost", 3);
    public static final ComponentType<class_2520> ATTRIBUTE_MODIFIERS = ComponentType.register("minecraft:attribute_modifiers", "AttributeModifiers", 9);
    public static final ComponentType<class_2520> CAN_DESTROY = ComponentType.register("minecraft:can_break", "CanDestroy", 9);
    public static final ComponentType<class_2520> CAN_PLACE_ON = ComponentType.register("minecraft:can_place_on", "CanPlaceOn", 9);
    public static final ComponentType<class_2487> BLOCK_ENTITY_DATA = ComponentType.register("minecraft:block_entity_data", "BlockEntityTag", 10);
    public static final ComponentType<class_2487> ENTITY_DATA = ComponentType.register("minecraft:entity_data", "EntityTag", 10);
    public static final ComponentType<class_2520> CHARGED_PROJECTILES = ComponentType.register("minecraft:charged_projectiles", "ChargedProjectiles", 9);
    public static final ComponentType<class_2520> BUNDLE_CONTENTS = ComponentType.register("minecraft:bundle_contents", "Items", 9);

    private ComponentType(class_2960 id, String nbtKey, int nbtType) {
        this.id = id;
        this.nbtKey = nbtKey;
        this.nbtType = nbtType;
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getNbtKey() {
        return this.nbtKey;
    }

    public int getNbtType() {
        return this.nbtType;
    }

    @Nullable
    public T get(class_1799 stack) {
        if (stack == null) {
            return null;
        }
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return null;
        }
        class_2520 element = this.get(nbt);
        if (element == null) {
            return null;
        }
        switch (this.nbtType) {
            case 3: {
                if (!(element instanceof class_2497)) break;
                class_2497 nbtInt = (class_2497)element;
                return (T)Integer.valueOf(nbtInt.method_10701());
            }
            case 8: {
                if (!(element instanceof class_2519)) break;
                class_2519 nbtString = (class_2519)element;
                return (T)nbtString.method_10714();
            }
            case 10: {
                if (!(element instanceof class_2487)) break;
                class_2487 nbtCompound = (class_2487)element;
                return (T)nbtCompound;
            }
            case 1: {
                if (!(element instanceof class_2497)) break;
                class_2497 nbtInt = (class_2497)element;
                return (T)Boolean.valueOf(nbtInt.method_10701() != 0);
            }
        }
        return null;
    }

    public boolean isIn(class_2487 nbt) {
        if (this.nbtKey.contains(".")) {
            String[] parts = this.nbtKey.split("\\.", 2);
            if (!nbt.method_10573(parts[0], 10)) {
                return false;
            }
            class_2487 nested = nbt.method_10562(parts[0]);
            return nested.method_10545(parts[1]);
        }
        return nbt.method_10573(this.nbtKey, this.nbtType);
    }

    @Nullable
    public class_2520 get(class_2487 nbt) {
        if (this.nbtKey.contains(".")) {
            String[] parts = this.nbtKey.split("\\.", 2);
            if (!nbt.method_10573(parts[0], 10)) {
                return null;
            }
            class_2487 nested = nbt.method_10562(parts[0]);
            return nested.method_10580(parts[1]);
        }
        return nbt.method_10580(this.nbtKey);
    }

    private static <T> ComponentType<T> register(String id, String nbtKey, int nbtType) {
        class_2960 identifier = new class_2960(id);
        ComponentType<T> type = new ComponentType<T>(identifier, nbtKey, nbtType);
        REGISTRY.put(identifier, type);
        return type;
    }

    @Nullable
    public static ComponentType<?> get(class_2960 id) {
        return REGISTRY.get(id);
    }

    public String toString() {
        return "ComponentType{" + String.valueOf(this.id) + " -> " + this.nbtKey + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComponentType)) {
            return false;
        }
        ComponentType other = (ComponentType)obj;
        return this.id.equals((Object)other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

