/*
 * Decompiled with CFR 0.152.
 */
package timmychips.modefiteitemdefinitions.comp;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class ItemSubPredicate {
    public static boolean testPredicate(class_1799 stack, class_2960 PId, JsonElement value) {
        String PPath;
        if (stack == null || PId == null || value == null) {
            return false;
        }
        return switch (PPath = PId.method_12832()) {
            case "damage" -> ItemSubPredicate.testDamage(stack, value);
            case "custom_model_data" -> ItemSubPredicate.testCustomModelData(stack, value);
            case "enchantments" -> ItemSubPredicate.testEnchantments(stack, value);
            case "stored_enchantments" -> ItemSubPredicate.testStoredEnchantments(stack, value);
            case "trim" -> ItemSubPredicate.testTrim(stack, value);
            case "potion_contents" -> ItemSubPredicate.testPotion(stack, value);
            case "custom_data" -> ItemSubPredicate.testCustomData(stack, value);
            case "unbreakable" -> ItemSubPredicate.testUnbreakable(stack, value);
            case "repair_cost" -> ItemSubPredicate.testRepairCost(stack, value);
            case "attribute_modifiers" -> ItemSubPredicate.testAttributeModifiers(stack, value);
            case "can_break" -> ItemSubPredicate.testCanBreak(stack, value);
            case "can_place_on" -> ItemSubPredicate.testCanPlaceOn(stack, value);
            case "special" -> ItemSubPredicate.testSpecial(stack, value);
            case "bundle/selected_item" -> ItemSubPredicate.testBundleSelectedItem(stack, value);
            case "model_tint_source" -> ItemSubPredicate.testModelTintSource(stack, value);
            default -> ItemSubPredicate.testGenericNbt(stack, PPath, value);
        };
    }

    private static boolean testDamage(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        int actualDamage = nbt.method_10550("Damage");
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isNumber()) {
            return actualDamage == value.getAsInt();
        }
        if (value.isJsonObject()) {
            JsonObject obj = value.getAsJsonObject();
            if (obj.has("min") && actualDamage < obj.get("min").getAsInt()) {
                return false;
            }
            return !obj.has("max") || actualDamage <= obj.get("max").getAsInt();
        }
        return false;
    }

    private static boolean testCustomModelData(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545("CustomModelData")) {
            return false;
        }
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isNumber()) {
            return nbt.method_10550("CustomModelData") == value.getAsInt();
        }
        return false;
    }

    private static boolean testEnchantments(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        boolean hasEnchantments = nbt.method_10545("Enchantments");
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isBoolean()) {
            return hasEnchantments == value.getAsBoolean();
        }
        return hasEnchantments;
    }

    private static boolean testStoredEnchantments(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        boolean hasStoredEnchantments = nbt.method_10545("StoredEnchantments");
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isBoolean()) {
            return hasStoredEnchantments == value.getAsBoolean();
        }
        return hasStoredEnchantments;
    }

    private static boolean testTrim(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        boolean hasTrim = nbt.method_10545("Trim");
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isBoolean()) {
            return hasTrim == value.getAsBoolean();
        }
        if (hasTrim && value.isJsonObject()) {
            class_2487 trim = nbt.method_10562("Trim");
            JsonObject obj = value.getAsJsonObject();
            if (obj.has("material") && !trim.method_10558("material").equals(obj.get("material").getAsString())) {
                return false;
            }
            return !obj.has("pattern") || trim.method_10558("pattern").equals(obj.get("pattern").getAsString());
        }
        return hasTrim;
    }

    private static boolean testPotion(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
            return nbt.method_10558("Potion").equals(value.getAsString());
        }
        return false;
    }

    private static boolean testCustomData(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isBoolean()) {
            return nbt.method_10546() > 0 == value.getAsBoolean();
        }
        return true;
    }

    private static boolean testUnbreakable(class_1799 stack, JsonElement value) {
        boolean isUnbreakable;
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        boolean bl = isUnbreakable = nbt.method_10545("Unbreakable") && nbt.method_10577("Unbreakable");
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isBoolean()) {
            return isUnbreakable == value.getAsBoolean();
        }
        return isUnbreakable;
    }

    private static boolean testRepairCost(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545("RepairCost")) {
            return false;
        }
        int actual = nbt.method_10550("RepairCost");
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isNumber()) {
            return actual == value.getAsInt();
        }
        if (value.isJsonObject()) {
            JsonObject obj = value.getAsJsonObject();
            if (obj.has("min") && actual < obj.get("min").getAsInt()) {
                return false;
            }
            return !obj.has("max") || actual <= obj.get("max").getAsInt();
        }
        return false;
    }

    private static boolean testAttributeModifiers(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        boolean hasAttributeModifiers = nbt.method_10545("AttributeModifiers");
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isBoolean()) {
            return hasAttributeModifiers == value.getAsBoolean();
        }
        return hasAttributeModifiers;
    }

    private static boolean testCanBreak(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        boolean hasCanBreak = nbt.method_10545("CanDestroy");
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isBoolean()) {
            return hasCanBreak == value.getAsBoolean();
        }
        return hasCanBreak;
    }

    private static boolean testCanPlaceOn(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        boolean hasCanPlaceOn = nbt.method_10545("CanPlaceOn");
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isBoolean()) {
            return hasCanPlaceOn == value.getAsBoolean();
        }
        return hasCanPlaceOn;
    }

    private static boolean testSpecial(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        boolean hasSpecial = nbt.method_10545("special");
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isBoolean()) {
            return hasSpecial == value.getAsBoolean();
        }
        return hasSpecial;
    }

    private static boolean testBundleSelectedItem(class_1799 stack, JsonElement value) {
        int selectedIndex;
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        if (!stack.method_7909().method_7848().getString().contains("bundle")) {
            return false;
        }
        int n = selectedIndex = nbt.method_10545("selected_index") ? nbt.method_10550("selected_index") : -1;
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isNumber()) {
            return selectedIndex == value.getAsInt();
        }
        return selectedIndex != -1;
    }

    private static boolean testModelTintSource(class_1799 stack, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        if (!nbt.method_10545("model_tint_source")) {
            return false;
        }
        String tint = nbt.method_10558("model_tint_source");
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
            return tint.equals(value.getAsString());
        }
        return true;
    }

    private static boolean testGenericNbt(class_1799 stack, String key, JsonElement value) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        boolean hasKey = nbt.method_10545(key);
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isBoolean()) {
            return hasKey == value.getAsBoolean();
        }
        if (hasKey && value.isJsonPrimitive()) {
            JsonPrimitive prim = value.getAsJsonPrimitive();
            if (prim.isNumber()) {
                return nbt.method_10550(key) == prim.getAsInt();
            }
            if (prim.isString()) {
                return nbt.method_10558(key).equals(prim.getAsString());
            }
        }
        return false;
    }
}

