/*
 * Decompiled with CFR 0.152.
 */
package timmychips.modefiteitemdefinitions.property.resolver;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.FabricBakedModelManager;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import timmychips.modefiteitemdefinitions.bakedmodels.CompositeItemModel;
import timmychips.modefiteitemdefinitions.bakedmodels.EmptyItemModel;
import timmychips.modefiteitemdefinitions.property.resolver.ConditionValueResolver;
import timmychips.modefiteitemdefinitions.property.resolver.RangeDispatchValueResolver;
import timmychips.modefiteitemdefinitions.property.resolver.SelectValueResolver;
import timmychips.modefiteitemdefinitions.property.type.codec.CompositeModelDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.ConditionDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.EmptyModelDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.ItemModelDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.ModelDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.RangeDispatchDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.SelectDefinition;

@Environment(value=EnvType.CLIENT)
public class ResolveRecursive {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Set<String> WARNED_MODELS = ConcurrentHashMap.newKeySet();

    private static FabricBakedModelManager getBakedModelManager() {
        return class_310.method_1551().method_1554();
    }

    public static class_1087 getMissingModel() {
        return class_310.method_1551().method_1554().method_4744();
    }

    public static Optional<class_1087> resolve(ItemModelDefinition def, class_811 renderMode, class_1799 stack, class_1309 entity) {
        if (def == null) {
            return Optional.empty();
        }
        if (renderMode == null) {
            renderMode = class_811.field_4317;
        }
        FabricBakedModelManager manager = ResolveRecursive.getBakedModelManager();
        if (def instanceof ModelDefinition) {
            ModelDefinition model = (ModelDefinition)def;
            class_1087 bakedModel = manager.getModel(model.model());
            return bakedModel == null ? Optional.empty() : Optional.of(bakedModel);
        }
        if (def instanceof EmptyModelDefinition) {
            EmptyModelDefinition emptyModelDefinition = (EmptyModelDefinition)def;
            return Optional.of(new EmptyItemModel());
        }
        if (def instanceof CompositeModelDefinition) {
            CompositeModelDefinition composite = (CompositeModelDefinition)def;
            if (composite.models().isEmpty()) {
                return ResolveRecursive.missingFallbackModel(stack, null, composite.type());
            }
            return Optional.of(new CompositeItemModel(composite.models(), renderMode, stack, entity));
        }
        if (def instanceof SelectDefinition.Definition) {
            SelectDefinition.Definition select = (SelectDefinition.Definition)def;
            String propertyValue = SelectValueResolver.evaluate(select.property(), renderMode, select, stack, entity);
            if (propertyValue != null) {
                for (SelectDefinition.Case<String> c : select.cases()) {
                    if (!c.when().contains(propertyValue)) continue;
                    return ResolveRecursive.resolve(c.model(), renderMode, stack, entity);
                }
            }
            return select.fallback() != null ? ResolveRecursive.resolve(select.fallback(), renderMode, stack, entity) : ResolveRecursive.missingFallbackModel(stack, select.property(), select.type());
        }
        if (def instanceof ConditionDefinition) {
            ConditionDefinition cond = (ConditionDefinition)def;
            boolean result = ConditionValueResolver.evaluate(cond.property(), stack, entity, cond);
            return result ? ResolveRecursive.resolve(cond.on_true(), renderMode, stack, entity) : ResolveRecursive.resolve(cond.on_false(), renderMode, stack, entity);
        }
        if (def instanceof RangeDispatchDefinition.Definition) {
            RangeDispatchDefinition.Definition range = (RangeDispatchDefinition.Definition)def;
            float value = RangeDispatchValueResolver.evaluate(range.property(), Float.valueOf(range.scale()), stack, entity, range);
            class_811 finalRenderMode = renderMode;
            return range.entries().stream().sorted((a, b) -> Float.compare(b.threshold(), a.threshold())).filter(entry -> value >= entry.threshold()).findFirst().map(entry -> ResolveRecursive.resolve(entry.model(), finalRenderMode, stack, entity)).orElseGet(() -> range.fallback() != null ? ResolveRecursive.resolve(range.fallback(), finalRenderMode, stack, entity) : ResolveRecursive.missingFallbackModel(stack, range.property(), range.type()));
        }
        return Optional.empty();
    }

    private static Optional<class_1087> missingFallbackModel(class_1799 stack, class_2960 property, @Nullable class_2960 type) {
        String key;
        if (property != null && WARNED_MODELS.add(key = stack.method_7909().toString() + "|" + String.valueOf(property))) {
            LOGGER.warn("No matching model found for property '{}', item: '{}'", (Object)property, (Object)stack.method_7909());
        }
        if (type.method_12832().equals("composite") && WARNED_MODELS.add(key = stack.method_7909().toString() + "|" + String.valueOf(type))) {
            LOGGER.warn("Composite model has no valid models defined '{}', item: '{}'", (Object)type, (Object)stack.method_7909());
        }
        return Optional.of(ResolveRecursive.getMissingModel());
    }
}

