/*
 * Decompiled with CFR 0.152.
 */
package timmychips.modefiteitemdefinitions.property.resolver.condition;

import com.mojang.logging.LogUtils;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import timmychips.modefiteitemdefinitions.comp.ComponentChanges;
import timmychips.modefiteitemdefinitions.comp.ComponentType;
import timmychips.modefiteitemdefinitions.property.handler.ConditionPropertyHandler;
import timmychips.modefiteitemdefinitions.property.resolver.ResolveRecursive;
import timmychips.modefiteitemdefinitions.property.type.codec.ConditionDefinition;

@Environment(value=EnvType.CLIENT)
public class HasComponentBool
implements ConditionPropertyHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> WARNED_MODELS = ResolveRecursive.WARNED_MODELS;

    private static boolean hasComponent(class_1799 stack, ComponentType<?> componentType) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && componentType.isIn(nbt);
    }

    @Override
    public boolean getValue(class_1799 stack, class_1309 entity, ConditionDefinition definition) {
        String component = definition.component();
        boolean ignore_default = definition.ignore_default();
        if (component == null) {
            return false;
        }
        class_2960 componentId = class_2960.method_12829((String)component);
        if (componentId == null) {
            String key = stack.method_7909().toString() + "|minecraft:has_component";
            if (WARNED_MODELS.add(key)) {
                LOGGER.warn("Invalid component predicate ID '{}'", (Object)component);
            }
            return false;
        }
        ComponentType<?> componentType = ComponentType.get(componentId);
        if (componentType == null) {
            String key = stack.method_7909().toString() + "|minecraft:has_component";
            if (WARNED_MODELS.add(key)) {
                LOGGER.warn("Unknown component predicate componentType '{}'", (Object)componentId);
            }
            return false;
        }
        if (HasComponentBool.hasComponent(stack, componentType)) {
            if (!ignore_default) {
                return true;
            }
            return HasComponentBool.hasChanged(stack, componentType);
        }
        return false;
    }

    private static Boolean hasChanged(class_1799 stack, ComponentType<?> componentType) {
        ComponentChanges changes = ComponentChanges.fromStack(stack);
        String nbtKey = componentType.getNbtKey();
        return changes.getAdditions().contains(nbtKey);
    }
}

