/*
 * Decompiled with CFR 0.152.
 */
package timmychips.modefiteitemdefinitions.property.resolver.rangeentry;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import timmychips.modefiteitemdefinitions.comp.LodestoneTrackerComponent;
import timmychips.modefiteitemdefinitions.comp.util.MathUtils;
import timmychips.modefiteitemdefinitions.property.handler.RangePropertyHandler;
import timmychips.modefiteitemdefinitions.property.type.codec.RangeDispatchDefinition;

@Environment(value=EnvType.CLIENT)
public class CompassFloat
implements RangePropertyHandler {
    private final AngleInterpolator aimedInterpolator = new AngleInterpolator();
    private final AngleInterpolator aimlessInterpolator = new AngleInterpolator();

    @Override
    public float getValue(class_1799 stack, class_1309 entity, RangeDispatchDefinition.Definition def) {
        double adjusted;
        if (entity == null) {
            return 0.0f;
        }
        class_1937 class_19372 = entity.method_37908();
        if (!(class_19372 instanceof class_638)) {
            return 0.0f;
        }
        class_638 clientWorld = (class_638)class_19372;
        if (def.target() == null) {
            return 0.0f;
        }
        class_4208 pos = this.getTargetPosition(clientWorld, stack, entity, def.target());
        long time = clientWorld.method_8510();
        boolean should_wobble = Boolean.TRUE.equals(def.wobble());
        if (!this.canPointTo((class_1297)entity, pos)) {
            return this.getAimlessAngle(0, time, should_wobble);
        }
        class_2338 targetPos = MathUtils.getPos(pos);
        if (targetPos == null) {
            return this.getAimlessAngle(0, time, should_wobble);
        }
        double angle = this.getAngleTo(entity, targetPos);
        double yaw = this.getBodyYaw(entity);
        if (should_wobble) {
            if (this.aimedInterpolator.shouldUpdate(time)) {
                this.aimedInterpolator.update(time, 0.5 - (yaw - 0.25));
            }
            adjusted = angle + this.aimedInterpolator.value;
        } else {
            adjusted = 0.5 - (yaw - 0.25 - angle);
        }
        return class_3532.method_15341((float)((float)adjusted), (float)1.0f);
    }

    private float getAimlessAngle(int seed, long time, boolean should_wobble) {
        if (should_wobble) {
            if (this.aimlessInterpolator.shouldUpdate(time)) {
                this.aimlessInterpolator.update(time, Math.random());
            }
            double d = this.aimlessInterpolator.value + (double)((float)this.scatter(seed) / 2.1474836E9f);
            return class_3532.method_15341((float)((float)d), (float)1.0f);
        }
        return class_3532.method_15341((float)((float)this.scatter(seed) / 2.1474836E9f), (float)1.0f);
    }

    private class_4208 getTargetPosition(class_638 world, class_1799 stack, class_1309 holder, CompassTarget target) {
        return switch (target.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                class_2487 nbt = stack.method_7969();
                if (nbt == null) {
                    yield null;
                }
                LodestoneTrackerComponent comp = LodestoneTrackerComponent.fromNbt(nbt);
                if (comp != null) {
                    yield comp.target().orElse(null);
                }
                yield null;
            }
            case 2 -> class_4208.method_19443((class_5321)world.method_27983(), (class_2338)world.method_43126());
            case 3 -> {
                if (holder instanceof class_1657) {
                    class_1657 player = (class_1657)holder;
                    yield player.method_43122().orElse(null);
                }
                yield null;
            }
            case 0 -> null;
        };
    }

    private float getAngleTo(class_1309 entity, class_2338 pos) {
        class_243 target = class_243.method_24953((class_2382)pos);
        return (float)(Math.atan2(target.method_10215() - entity.method_23321(), target.method_10216() - entity.method_23317()) / (Math.PI * 2));
    }

    private boolean canPointTo(class_1297 entity, @Nullable class_4208 pos) {
        if (pos == null) {
            return false;
        }
        if (!MathUtils.isSameDimension(pos, null, (class_5321<class_1937>)entity.method_37908().method_27983())) {
            return false;
        }
        class_2338 targetPos = MathUtils.getPos(pos);
        if (targetPos == null) {
            return false;
        }
        return !(targetPos.method_19770((class_2374)entity.method_19538()) < (double)1.0E-5f);
    }

    private float getBodyYaw(class_1309 entity) {
        return class_3532.method_15341((float)(entity.method_43078() / 360.0f), (float)1.0f);
    }

    private double scatter(int seed) {
        return (float)seed * 1.3272179E9f;
    }

    @Environment(value=EnvType.CLIENT)
    static class AngleInterpolator {
        double value;
        private double speed;
        private long lastUpdateTime;

        AngleInterpolator() {
        }

        boolean shouldUpdate(long time) {
            return this.lastUpdateTime != time;
        }

        void update(long time, double target) {
            this.lastUpdateTime = time;
            double d = target - this.value;
            d = class_3532.method_15367((double)(d + 0.5), (double)1.0) - 0.5;
            this.speed += d * 0.1;
            this.speed *= 0.8;
            this.value = class_3532.method_15367((double)(this.value + this.speed), (double)1.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum CompassTarget implements class_3542
    {
        NONE("none"),
        LODESTONE("lodestone"),
        SPAWN("spawn"),
        RECOVERY("recovery");

        private final String name;
        public static final class_3542.class_7292<CompassTarget> CODEC;

        private CompassTarget(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(CompassTarget::values);
        }
    }
}

