/*
 * Decompiled with CFR 0.152.
 */
package timmychips.modefiteitemdefinitions.property.type;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import timmychips.modefiteitemdefinitions.ClientInitializer;
import timmychips.modefiteitemdefinitions.comp.CodecHelper;
import timmychips.modefiteitemdefinitions.property.helper.DefinitionIdMapper;
import timmychips.modefiteitemdefinitions.property.type.codec.CompositeModelDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.ConditionDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.EmptyModelDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.ItemModelDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.ItemModelRootDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.ModelDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.RangeDispatchDefinition;
import timmychips.modefiteitemdefinitions.property.type.codec.SelectDefinition;

@Environment(value=EnvType.CLIENT)
public class ItemModelTypes {
    public static final DefinitionIdMapper ID_MAPPER = new DefinitionIdMapper();
    public static final Codec<ItemModelDefinition> CODEC = CodecHelper.lazyInitialized(() -> ID_MAPPER.getCodec((Codec<class_2960>)class_2960.field_25139));

    static {
        ID_MAPPER.put(ModelDefinition.TYPE, ModelDefinition.CODEC);
        ID_MAPPER.put(ConditionDefinition.TYPE, ConditionDefinition.codec(CODEC));
        ID_MAPPER.put(SelectDefinition.Definition.TYPE, SelectDefinition.Definition.codec(CODEC));
        ID_MAPPER.put(RangeDispatchDefinition.Definition.TYPE, RangeDispatchDefinition.Definition.codec(CODEC));
        ID_MAPPER.put(CompositeModelDefinition.TYPE, CompositeModelDefinition.CODEC);
        ID_MAPPER.put(EmptyModelDefinition.TYPE, EmptyModelDefinition.CODEC);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Registry {
        private static final Map<class_2960, ItemModelDefinition> definitions = new HashMap<class_2960, ItemModelDefinition>();
        private static final Map<class_2960, ItemModelRootDefinition> rootDefinitions = new HashMap<class_2960, ItemModelRootDefinition>();
        public static final Set<class_2960> INVALID_MODEL_TYPES = new HashSet<class_2960>();

        public static void putRoot(class_2960 id, ItemModelRootDefinition root) {
            if (root.model() != null && Registry.validateType(id, root.model())) {
                definitions.put(id, root.model());
                rootDefinitions.put(id, root);
            }
        }

        public static ItemModelRootDefinition getRoot(class_2960 id) {
            return rootDefinitions.get(id);
        }

        public static boolean validateType(class_2960 id, ItemModelDefinition definition) {
            if (!definition.type().equals((Object)definition.expectedType())) {
                INVALID_MODEL_TYPES.add(id);
                ClientInitializer.LOGGER.error("Couldn't parse item '{}': Unknown item model type id: {}", (Object)id, (Object)definition.type());
                return false;
            }
            return true;
        }

        public static ItemModelDefinition get(class_2960 id) {
            return definitions.get(id);
        }

        public static boolean hasDefinition(class_2960 id) {
            return definitions.containsKey(id);
        }

        public static void clear() {
            INVALID_MODEL_TYPES.clear();
            definitions.clear();
        }

        public static Set<class_2960> getAllModelDependencies() {
            HashSet<class_2960> dependencies = new HashSet<class_2960>();
            for (ItemModelDefinition definition : definitions.values()) {
                Registry.collectModelsFromDefinition(definition, dependencies);
            }
            return dependencies;
        }

        private static void collectModelsFromDefinition(ItemModelDefinition def, Set<class_2960> out) {
            if (def instanceof ModelDefinition) {
                ModelDefinition model = (ModelDefinition)def;
                out.add(model.model());
            } else if (def instanceof SelectDefinition.Definition) {
                SelectDefinition.Definition select = (SelectDefinition.Definition)def;
                for (SelectDefinition.Case<String> c : select.cases()) {
                    Registry.collectModelsFromDefinition(c.model(), out);
                }
                Registry.collectModelsFromDefinition(select.fallback(), out);
            } else if (def instanceof ConditionDefinition) {
                ConditionDefinition condition = (ConditionDefinition)def;
                Registry.collectModelsFromDefinition(condition.on_true(), out);
                Registry.collectModelsFromDefinition(condition.on_false(), out);
            } else if (def instanceof RangeDispatchDefinition.Definition) {
                RangeDispatchDefinition.Definition range = (RangeDispatchDefinition.Definition)def;
                for (RangeDispatchDefinition.ThresholdEntry entry : range.entries()) {
                    Registry.collectModelsFromDefinition(entry.model(), out);
                }
                Registry.collectModelsFromDefinition(range.fallback(), out);
            } else if (def instanceof CompositeModelDefinition) {
                CompositeModelDefinition composite = (CompositeModelDefinition)def;
                for (ItemModelDefinition defPart : composite.models()) {
                    Registry.collectModelsFromDefinition(defPart, out);
                }
            }
        }
    }
}

