/*
 * Decompiled with CFR 0.152.
 */
package th.tamkungz.letyourfriendeating;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import th.tamkungz.letyourfriendeating.FriendFeeder;

public class LetYourFriendEatingMod
implements ModInitializer {
    public static final String MOD_ID = "letyourfriendeating";
    public static boolean feedFriendEnabled = true;
    private static final Map<UUID, Long> feedCooldowns = new HashMap<UUID, Long>();
    private static final Map<UUID, Integer> feedCounts = new HashMap<UUID, Integer>();
    private static final Logger LOGGER = LogManager.getLogger((String)"letyourfriendeating");
    private static final long COOLDOWN_MS = 500L;

    public static int getFeedCount(UUID playerId) {
        return feedCounts.getOrDefault(playerId, 0);
    }

    public static Map<UUID, Integer> getFeedCountsView() {
        return Collections.unmodifiableMap(feedCounts);
    }

    public static void registerFeedAction(UUID targetId) {
        feedCounts.put(targetId, LetYourFriendEatingMod.getFeedCount(targetId) + 1);
    }

    public static boolean canFeed(UUID feederId) {
        long now = System.currentTimeMillis();
        Long last = feedCooldowns.get(feederId);
        if (last != null && now - last < 500L) {
            return false;
        }
        feedCooldowns.put(feederId, now);
        return true;
    }

    public void onInitialize() {
        LOGGER.info("Initializing {}...", (Object)MOD_ID);
        UseEntityCallback.EVENT.register((feeder, world, hand, entity, hitResult) -> {
            if (world.method_8608()) {
                return class_1269.field_5811;
            }
            if (hand != class_1268.field_5808) {
                return class_1269.field_5811;
            }
            if (!(entity instanceof class_1657)) {
                return class_1269.field_5811;
            }
            class_1657 target = (class_1657)entity;
            if (feeder == target) {
                return class_1269.field_5811;
            }
            if (!feedFriendEnabled) {
                return class_1269.field_5811;
            }
            if (!feeder.method_37908().equals(target.method_37908())) {
                return class_1269.field_5811;
            }
            UUID feederId = feeder.method_5667();
            if (!LetYourFriendEatingMod.canFeed(feederId)) {
                feeder.method_7353((class_2561)class_2561.method_43470((String)"You must wait before feeding again!"), false);
                LOGGER.debug("{} tried to feed too soon.", (Object)feeder.method_5477().getString());
                return class_1269.field_5814;
            }
            class_1269 result = FriendFeeder.tryFeedPlayer(feeder, target, hand);
            if (result == class_1269.field_5812) {
                LetYourFriendEatingMod.registerFeedAction(target.method_5667());
                LOGGER.info("{} fed {}. Total feeds: {}", (Object)feeder.method_5477().getString(), (Object)target.method_5477().getString(), (Object)LetYourFriendEatingMod.getFeedCount(target.method_5667()));
            }
            return result;
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"feedfriend").then(class_2170.method_9247((String)"toggle").executes(ctx -> {
            feedFriendEnabled = !feedFriendEnabled;
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("FeedFriend toggled " + (feedFriendEnabled ? "ON" : "OFF"))), false);
            LOGGER.info("FeedFriend {} by {}", (Object)(feedFriendEnabled ? "ON" : "OFF"), (Object)((class_2168)ctx.getSource()).method_9214());
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").executes(ctx -> {
            class_3222 p = ((class_2168)ctx.getSource()).method_44023();
            int c = LetYourFriendEatingMod.getFeedCount(p.method_5667());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("You have been fed " + c + " time(s).")), false);
            LOGGER.info("{} checked their feed stats: {}", (Object)p.method_5477().getString(), (Object)c);
            return 1;
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_3222 t = class_2186.method_9315((CommandContext)ctx, (String)"player");
            int c = LetYourFriendEatingMod.getFeedCount(t.method_5667());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)(t.method_5477().getString() + " has been fed " + c + " time(s).")), false);
            LOGGER.info("{} checked feed stats for {}: {}", (Object)((class_2168)ctx.getSource()).method_9214(), (Object)t.method_5477().getString(), (Object)c);
            return 1;
        })))));
        LOGGER.info("{} initialized successfully.", (Object)MOD_ID);
    }
}

