/*
 * Decompiled with CFR 0.152.
 */
package th.tamkungz.letyourfriendeating;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="letyourfriendeating")
public class LetYourFriendEating {
    public static final String MOD_ID = "letyourfriendeating";
    private static final Logger LOGGER = LogManager.getLogger((String)"th.tamkungz.letyourfriendeating.LetYourFriendEating");
    private static final Map<UUID, Long> LAST_FEED_TIME = new ConcurrentHashMap<UUID, Long>();
    private static final long COOLDOWN_MS = 500L;

    public LetYourFriendEating() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityInteract);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Initialized for Minecraft 1.19.2 (Forge)");
    }

    private void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof Player)) {
            return;
        }
        Player target = (Player)entity;
        Player feeder = event.getEntity();
        InteractionHand hand = event.getHand();
        InteractionResult result = this.tryFeedPlayer(feeder, target, hand);
        event.setCancellationResult(result);
        if (result == InteractionResult.SUCCESS) {
            event.setCanceled(true);
        }
    }

    private InteractionResult tryFeedPlayer(Player feeder, Player target, InteractionHand hand) {
        if (feeder == target) {
            return InteractionResult.PASS;
        }
        UUID feederId = feeder.m_20148_();
        long now = System.currentTimeMillis();
        Long last = LAST_FEED_TIME.get(feederId);
        if (last != null && now - last < 500L) {
            return InteractionResult.PASS;
        }
        ItemStack stack = feeder.m_21120_(hand);
        if (stack.m_41619_() || !stack.m_41720_().m_41472_()) {
            return InteractionResult.PASS;
        }
        FoodProperties props = stack.m_41720_().m_41473_();
        if (props == null) {
            return InteractionResult.PASS;
        }
        if (target.m_36324_() == null || target.m_36324_().m_38702_() >= 20) {
            return InteractionResult.PASS;
        }
        target.m_36324_().m_38707_(props.m_38744_(), props.m_38745_());
        for (Pair effectEntry : props.m_38749_()) {
            MobEffectInstance effect = (MobEffectInstance)effectEntry.getFirst();
            if (effect == null || !(feeder.m_217043_().m_188501_() < ((Float)effectEntry.getSecond()).floatValue())) continue;
            target.m_7292_(new MobEffectInstance(effect));
        }
        if (!feeder.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        target.m_5496_(SoundEvents.f_12321_, 1.0f, 1.0f);
        Level world = target.f_19853_;
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 5, 0.5, 0.5, 0.5, 0.0);
        }
        LAST_FEED_TIME.put(feederId, now);
        return InteractionResult.SUCCESS;
    }
}

