/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.util.InfoCollectHelper;
import com.iafenvoy.tooltipsreforged.util.TooltipKeyManager;
import it.unimi.dsi.fastutil.objects.ObjectLongPair;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_3545;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class DebugInfoComponent
implements class_5684 {
    private static final TooltipKeyManager KEY_MANAGER = new TooltipKeyManager();
    private final List<String> itemTags;
    private final List<String> blockTags;
    private final List<String> entityTags;
    private final List<class_5250> nbt;
    private final List<class_5250> entityInfo;
    private final ObjectLongPair<class_2960> lootTable;

    public DebugInfoComponent(class_1799 stack, class_5455 registries) {
        this.itemTags = InfoCollectHelper.collectItemTags(stack);
        this.blockTags = InfoCollectHelper.collectBlockTags(stack);
        this.entityTags = InfoCollectHelper.collectEntityTags(stack);
        this.nbt = InfoCollectHelper.collectNbt(stack, registries);
        this.entityInfo = InfoCollectHelper.collectEntityInfo(stack);
        this.lootTable = InfoCollectHelper.collectLootTable(stack);
    }

    public int method_32661() {
        return (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.debugInfoTooltip.getValue() != false ? this.getDisplayTexts().size() * 10 : 0;
    }

    public int method_32664(class_327 textRenderer) {
        return this.getDisplayTexts().stream().map(arg_0 -> ((class_327)textRenderer).method_27525(arg_0)).reduce(0, Math::max, Math::max);
    }

    public void method_32665(class_327 textRenderer, int x, int y, Matrix4f matrix, class_4597.class_4598 vertexConsumers) {
        if (!((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.debugInfoTooltip.getValue()).booleanValue()) {
            return;
        }
        float currentY = y + 1;
        for (class_2561 class_25612 : this.getDisplayTexts()) {
            textRenderer.method_30882(class_25612, (float)x, currentY, -1, true, matrix, (class_4597)vertexConsumers, class_327.class_6415.field_33993, 0, 0xF000F0);
            currentY += 10.0f;
        }
        KEY_MANAGER.renderTick();
    }

    private List<class_5250> getDisplayTexts() {
        class_5250 first = class_2561.method_43473();
        boolean hasInfo = false;
        List<Object> infos = List.of();
        class_3545<String, List<class_5250>> itemTagInfo = this.getItemTagInfo();
        TooltipKeyManager.PressState itemTagState = KEY_MANAGER.itemTag();
        if (itemTagInfo != null && itemTagState.show()) {
            hasInfo = true;
            if (itemTagState.showDetail()) {
                first.method_10852((class_2561)class_2561.method_43470((String)"[%s %s] ".formatted(TooltipKeyManager.itemTagKeyTranslation(), class_1074.method_4662((String)((String)itemTagInfo.method_15442()), (Object[])new Object[0]))).method_27692(class_124.field_1068));
                infos = ((List)itemTagInfo.method_15441()).stream().map(x -> x.method_27692(class_124.field_1063)).toList();
            } else {
                first.method_10852((class_2561)class_2561.method_43470((String)"[%s %s] ".formatted(TooltipKeyManager.itemTagKeyTranslation(), class_1074.method_4662((String)((String)itemTagInfo.method_15442()), (Object[])new Object[0]))).method_27692(class_124.field_1080));
            }
        }
        class_3545<String, List<class_5250>> specificInfo = this.getSpecificInfo();
        TooltipKeyManager.PressState specificState = KEY_MANAGER.specific();
        if (specificInfo != null && specificState.show()) {
            hasInfo = true;
            if (specificState.showDetail()) {
                first.method_10852((class_2561)class_2561.method_43470((String)"[%s %s] ".formatted(TooltipKeyManager.specificKeyTranslation(), class_1074.method_4662((String)((String)specificInfo.method_15442()), (Object[])new Object[0]))).method_27692(class_124.field_1068));
                infos = ((List)specificInfo.method_15441()).stream().map(x -> x.method_27692(class_124.field_1063)).toList();
            } else {
                first.method_10852((class_2561)class_2561.method_43470((String)"[%s %s] ".formatted(TooltipKeyManager.specificKeyTranslation(), class_1074.method_4662((String)((String)specificInfo.method_15442()), (Object[])new Object[0]))).method_27692(class_124.field_1080));
            }
        }
        class_3545<String, List<class_5250>> nbtInfo = this.getNbtInfo();
        TooltipKeyManager.PressState nbtState = KEY_MANAGER.nbt();
        if (nbtInfo != null && nbtState.show()) {
            hasInfo = true;
            if (nbtState.showDetail()) {
                first.method_10852((class_2561)class_2561.method_43470((String)"[%s %s] ".formatted(TooltipKeyManager.nbtKeyTranslation(), class_1074.method_4662((String)((String)nbtInfo.method_15442()), (Object[])new Object[0]))).method_27692(class_124.field_1068));
                infos = ((List)nbtInfo.method_15441()).stream().map(x -> x.method_27692(class_124.field_1063)).toList();
            } else {
                first.method_10852((class_2561)class_2561.method_43470((String)"[%s %s] ".formatted(TooltipKeyManager.nbtKeyTranslation(), class_1074.method_4662((String)((String)nbtInfo.method_15442()), (Object[])new Object[0]))).method_27692(class_124.field_1080));
            }
        }
        return hasInfo ? ImmutableList.builder().add((Object)first).addAll(infos).build() : List.of();
    }

    @Nullable
    private class_3545<String, List<class_5250>> getItemTagInfo() {
        if (!this.itemTags.isEmpty()) {
            return new class_3545((Object)"tooltip.tooltips_reforged.item_tags", this.itemTags.stream().map(class_2561::method_43470).toList());
        }
        return null;
    }

    @Nullable
    private class_3545<String, List<class_5250>> getSpecificInfo() {
        if (!this.blockTags.isEmpty()) {
            return new class_3545((Object)"tooltip.tooltips_reforged.block_tags", this.blockTags.stream().map(class_2561::method_43470).toList());
        }
        if (!this.entityTags.isEmpty()) {
            return new class_3545((Object)"tooltip.tooltips_reforged.entity_tags", this.entityTags.stream().map(class_2561::method_43470).toList());
        }
        if (this.lootTable != null && this.lootTable.left() != null) {
            return new class_3545((Object)"tooltip.tooltips_reforged.loot_table", List.of(class_2561.method_43470((String)("tooltip.tooltips_reforged.id" + ((class_2960)this.lootTable.left()).toString())), class_2561.method_43470((String)("tooltip.tooltips_reforged.seed" + this.lootTable.rightLong()))));
        }
        return null;
    }

    @Nullable
    private class_3545<String, List<class_5250>> getNbtInfo() {
        if (!this.entityInfo.isEmpty()) {
            return new class_3545((Object)"tooltip.tooltips_reforged.mob_info", this.entityInfo);
        }
        if (!this.nbt.isEmpty()) {
            return new class_3545((Object)"tooltip.tooltips_reforged.nbt", this.nbt);
        }
        return null;
    }
}

