/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.component.StandaloneComponent;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1454;
import net.minecraft.class_1473;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5761;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class EntityViewerComponent
extends StandaloneComponent
implements RenderHelper {
    public static final Map<class_1785, Supplier<? extends class_1299<?>>> ENTITY_BUCKET_MAP = new HashMap();
    private static final float ROTATION_INCREMENT = 0.2f;
    private static float CURRENT_ROTATION = 0.0f;
    private static final int ENTITY_OFFSET = 40;

    public EntityViewerComponent(class_1799 stack) {
        super(stack);
    }

    @Override
    public void render(class_332 context, class_327 textRenderer, int x, int y, int z) {
        CURRENT_ROTATION = (CURRENT_ROTATION + 0.2f) % 360.0f;
        class_1792 class_17922 = this.stack.method_7909();
        if (class_17922 instanceof class_1785) {
            class_1785 bucketItem = (class_1785)class_17922;
            if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.bucketTooltip.getValue()).booleanValue()) {
                this.renderBucketEntity(context, x, y, z, bucketItem);
            }
        } else {
            class_17922 = this.stack.method_7909();
            if (class_17922 instanceof class_1826) {
                class_1826 spawnEggItem = (class_1826)class_17922;
                if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.spawnEggTooltip.getValue()).booleanValue()) {
                    this.renderSpawnEggEntity(context, x, y, z, spawnEggItem);
                }
            }
        }
    }

    private void renderBucketEntity(class_332 context, int x, int y, int z, class_1785 bucketItem) {
        if (!ENTITY_BUCKET_MAP.containsKey(bucketItem)) {
            return;
        }
        class_1299<?> entityType = ENTITY_BUCKET_MAP.get(bucketItem).get();
        class_1297 entity = entityType.method_5883((class_1937)class_310.method_1551().field_1687);
        if (entity instanceof class_5761) {
            class_5761 bucketable = (class_5761)entity;
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                class_2487 nbtComponent = ((class_9279)this.stack.method_57825(class_9334.field_49610, (Object)class_9279.field_49302)).method_57461();
                bucketable.method_35170(nbtComponent);
                if (entityType == class_1299.field_6111) {
                    return;
                }
                if (bucketable instanceof class_1454) {
                    class_1454 pufferfishEntity = (class_1454)bucketable;
                    pufferfishEntity.method_6596(2);
                }
                this.renderBackground(context, x - 40 - 70, y, 80, 40, z);
                livingEntity.method_5773();
                this.drawEntity(context, x - 67, y + 40, 30, -CURRENT_ROTATION, livingEntity);
            }
        }
    }

    private void renderSpawnEggEntity(class_332 context, int x, int y, int z, class_1826 spawnEggItem) {
        class_2487 nbt;
        class_1299 entityType = spawnEggItem.method_8015(this.stack);
        class_1297 entity = entityType.method_5883((class_1937)class_310.method_1551().field_1687);
        if (entity == null) {
            return;
        }
        if (entityType == class_1299.field_6077 || entityType == class_1299.field_6054) {
            class_2487 villagerData = new class_2487();
            villagerData.method_10582("profession", "minecraft:none");
            villagerData.method_10582("type", "minecraft:plains");
            nbt = new class_2487();
            nbt.method_10566("VillagerData", (class_2520)villagerData);
            entity.method_5651(nbt);
        }
        if (entityType == class_1299.field_6111) {
            return;
        }
        if (entity instanceof class_1454) {
            class_1454 pufferfishEntity = (class_1454)entity;
            pufferfishEntity.method_6596(2);
        }
        if (entity instanceof class_1473) {
            class_1473 snowGolemEntity = (class_1473)entity;
            snowGolemEntity.method_6642(false);
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            nbt = ((class_9279)this.stack.method_57825(class_9334.field_49609, (Object)class_9279.field_49302)).method_57461();
            if (nbt != null) {
                livingEntity.method_5749(nbt);
            }
            this.renderBackground(context, x - 40 - 70, y, 80, 80, z);
            livingEntity.method_5773();
            this.drawEntity(context, x - 67, y + 75, 40, -CURRENT_ROTATION, livingEntity);
        }
    }
}

