/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.component.StandaloneComponent;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.ArmorRenderMode;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5151;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class EquipmentViewerComponent
extends StandaloneComponent
implements RenderHelper {
    private static final float ROTATION_INCREMENT = 0.2f;
    private static float CURRENT_ROTATION = 0.0f;
    private static final int ENTITY_OFFSET = 40;

    public EquipmentViewerComponent(class_1799 stack) {
        super(stack);
    }

    @Override
    public void render(class_332 context, class_327 textRenderer, int x, int y, int z) {
        CURRENT_ROTATION = (CURRENT_ROTATION + 0.2f) % 360.0f;
        switch ((ArmorRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.armorTooltip.getValue())) {
            case PLAYER: {
                this.renderPlayer(context, x, y, z);
                break;
            }
            case ARMOR_STAND: {
                this.renderArmorStand(context, x, y, z);
            }
        }
    }

    private void renderPlayer(class_332 context, int x, int y, int z) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1304 slot = EquipmentViewerComponent.getPreferredEquipmentSlot(this.stack);
        class_1799 original = player.method_6118(slot);
        player.method_5673(slot, this.stack);
        this.renderBackground(context, x - 40 - 25, y, 40, 70, z);
        this.drawEntity(context, x - 45, y + 65, 35, -CURRENT_ROTATION, (class_1309)player);
        player.method_5673(slot, original);
    }

    private void renderArmorStand(class_332 context, int x, int y, int z) {
        class_1531 armorStand = new class_1531(class_1299.field_6131, (class_1937)class_310.method_1551().field_1687);
        armorStand.method_5673(EquipmentViewerComponent.getPreferredEquipmentSlot(this.stack), this.stack);
        this.renderBackground(context, x - 40 - 25, y, 40, 70, z);
        armorStand.method_5773();
        this.drawEntity(context, x - 45, y + 65, 35, -CURRENT_ROTATION, (class_1309)armorStand);
    }

    private static class_1304 getPreferredEquipmentSlot(class_1799 stack) {
        class_5151 equipment = class_5151.method_48957((class_1799)stack);
        return equipment != null ? equipment.method_7685() : class_1304.field_6173;
    }
}

