/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.EffectsRenderMode;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4174;
import net.minecraft.class_4176;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class FoodEffectComponent
implements class_5684 {
    protected final class_1799 stack;
    private final EffectsRenderMode effectsMode;

    public FoodEffectComponent(class_1799 stack) {
        this.stack = stack;
        this.effectsMode = (EffectsRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.effectsTooltip.getValue());
    }

    public class_4174 getFoodComponent() {
        return (class_4174)this.stack.method_57825(class_9334.field_50075, (Object)class_4176.field_18638);
    }

    public int getHunger() {
        return this.getFoodComponent().comp_2491();
    }

    public int getSaturation() {
        class_4174 foodComponent = this.getFoodComponent();
        int saturation = 0;
        if (foodComponent != null) {
            saturation = (int)(foodComponent.comp_2492() * 100.0f);
        }
        return saturation;
    }

    public int method_32661() {
        int height = 0;
        class_4174 foodComponent = this.getFoodComponent();
        if (foodComponent != null) {
            if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.hungerTooltip.getValue()).booleanValue() && foodComponent.comp_2491() > 0) {
                height += 10;
            }
            if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.saturationTooltip.getValue()).booleanValue() && foodComponent.comp_2492() > 0.0f) {
                height += 10;
            }
            if (this.effectsMode.shouldRender()) {
                height += foodComponent.comp_2495().size() * 10;
            }
        }
        return height;
    }

    public int method_32664(class_327 textRenderer) {
        int effectsWidth = 0;
        int hungerLine = 0;
        int saturationLine = 0;
        class_4174 foodComponent = this.getFoodComponent();
        int hunger = this.getHunger();
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.hungerTooltip.getValue()).booleanValue() && foodComponent.comp_2491() > 0) {
            int n = textRenderer.method_27525((class_5348)class_2561.method_43471((String)"tooltip.%s.hunger".formatted("tooltips_reforged"))) + 1;
            Objects.requireNonNull(textRenderer);
            hungerLine = n + (9 - 2) * hunger;
        }
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.saturationTooltip.getValue()).booleanValue() && foodComponent.comp_2492() > 0.0f) {
            saturationLine = textRenderer.method_27525((class_5348)class_2561.method_43469((String)"tooltip.%s.saturation".formatted("tooltips_reforged"), (Object[])new Object[]{"100%"}));
        }
        int foodWidth = Math.max(hungerLine, saturationLine);
        if (!this.effectsMode.shouldRender()) {
            return foodWidth + 4;
        }
        if (foodComponent == null) {
            return 0;
        }
        for (class_4174.class_9423 effect : foodComponent.comp_2495()) {
            class_1293 statusEffect = effect.comp_2496();
            Object text = class_2561.method_43471((String)statusEffect.method_5586()).getString();
            if (statusEffect.method_5578() > 0) {
                text = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{text, class_2561.method_43471((String)("potion.potency." + statusEffect.method_5578())).getString()}).getString();
            }
            if (!statusEffect.method_48557(20)) {
                text = (String)text + " " + TextUtil.getDurationText(statusEffect, 1.0f).getString();
            }
            effectsWidth = Math.max(effectsWidth, textRenderer.method_1727((String)text) + 14);
        }
        return Math.max(foodWidth, effectsWidth) + 4;
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        class_4174 foodComponent = this.getFoodComponent();
        if (foodComponent == null) {
            return;
        }
        int hunger = this.getHunger();
        class_5250 hungerText = class_2561.method_43471((String)"tooltip.%s.hunger".formatted("tooltips_reforged"));
        class_5250 saturationText = class_2561.method_43469((String)"tooltip.%s.saturation".formatted("tooltips_reforged"), (Object[])new Object[]{this.getSaturation()});
        int lineY = y;
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.hungerTooltip.getValue()).booleanValue() && foodComponent.comp_2491() > 0) {
            context.method_51439(textRenderer, (class_2561)hungerText, x, lineY, -1, true);
            float fullHungers = (float)hunger / 2.0f;
            boolean hasHalfHunger = hunger % 2 != 0;
            int hungerWidth = textRenderer.method_27525((class_5348)hungerText) + 1;
            for (int i = 0; i < (int)fullHungers; ++i) {
                class_2960 class_29602 = class_2960.method_60656((String)"textures/gui/icons.png");
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.method_25290(class_29602, x + hungerWidth, lineY, 52.0f, 27.0f, 9, 9, 256, 256);
                Objects.requireNonNull(textRenderer);
                hungerWidth += 9 - 2;
            }
            if (hasHalfHunger) {
                class_2960 class_29603 = class_2960.method_60656((String)"textures/gui/icons.png");
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.method_25290(class_29603, x + hungerWidth, lineY, 61.0f, 27.0f, 9, 9, 256, 256);
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.saturationTooltip.getValue()).booleanValue() && foodComponent.comp_2492() > 0.0f) {
            context.method_51439(textRenderer, (class_2561)saturationText, x, lineY, -16711681, true);
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
        if (!this.effectsMode.shouldRender()) {
            return;
        }
        for (class_4174.class_9423 effect : foodComponent.comp_2495()) {
            class_1293 statusEffect = effect.comp_2496();
            int c = ((class_1291)statusEffect.method_5579().comp_349()).method_5556();
            class_1058 effectTexture = class_310.method_1551().method_18505().method_18663(statusEffect.method_5579());
            if (c == 0) {
                c = -11250436;
            }
            String effectName = class_2561.method_43471((String)statusEffect.method_5586()).getString();
            if (statusEffect.method_5578() > 0) {
                effectName = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{effectName, class_2561.method_43471((String)("potion.potency." + statusEffect.method_5578())).getString()}).getString();
            }
            Object fullText = effectName;
            if (!statusEffect.method_48557(20)) {
                fullText = (String)fullText + " (" + TextUtil.getDurationText(statusEffect, 1.0f).getString() + ")";
            }
            class_5250 renderText = class_2561.method_43470((String)fullText);
            if (this.effectsMode.shouldRenderIcon()) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.method_25298(x - 1, lineY - 1, 0, 9, 9, effectTexture);
                Objects.requireNonNull(textRenderer);
                context.method_51439(textRenderer, (class_2561)renderText, x + 9 + 2, lineY, c, true);
            } else {
                context.method_51439(textRenderer, (class_2561)renderText, x, lineY, c, true);
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
    }
}

