/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.ItemDisplayMode;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import com.iafenvoy.tooltipsreforged.render.TooltipProviders;
import com.iafenvoy.tooltipsreforged.util.BadgesUtils;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class HeaderComponent
implements class_5684,
RenderHelper {
    protected final class_1799 stack;
    private final ItemDisplayMode itemDisplayMode;
    private final class_5481 nameText;
    private final class_5481 rarityName;
    private final Pair<class_2561, Integer> badgePair;

    public HeaderComponent(class_1799 stack) {
        this.stack = stack;
        this.itemDisplayMode = (ItemDisplayMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.itemDisplayTooltip.getValue());
        this.nameText = TooltipProviders.getDisplayName(this.stack).method_30937();
        this.rarityName = TooltipProviders.getRarityName(this.stack).method_30937();
        this.badgePair = BadgesUtils.getBadgeText(this.stack);
    }

    public int method_32661() {
        return 24;
    }

    public int method_32664(class_327 textRenderer) {
        class_2561 badgeText = (class_2561)this.badgePair.getFirst();
        int rarityWidth = (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.rarityTooltip.getValue() != false ? textRenderer.method_30880(this.rarityName) : 0;
        int badgeWidth = (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.itemGroupTooltip.getValue() != false ? textRenderer.method_27525((class_5348)badgeText) + 8 : 0;
        int titleWidth = (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.rarityTooltip.getValue() != false ? textRenderer.method_30880(this.nameText) + badgeWidth + 2 : Math.max(textRenderer.method_30880(this.nameText), badgeWidth);
        return Math.max(titleWidth, rarityWidth) + this.getTitleOffset();
    }

    public int getTitleOffset() {
        return this.itemDisplayMode.shouldRenderHeader() ? 24 : 0;
    }

    public void method_32665(class_327 textRenderer, int x, int y, Matrix4f matrix, class_4597.class_4598 vertexConsumers) {
        float startDrawX = (float)x + (float)this.getTitleOffset();
        float startDrawY = y + 1;
        textRenderer.method_22942(this.nameText, startDrawX, startDrawY - 1.0f, -1, true, matrix, (class_4597)vertexConsumers, class_327.class_6415.field_33993, 0, 0xF000F0);
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.rarityTooltip.getValue()).booleanValue()) {
            Objects.requireNonNull(textRenderer);
            textRenderer.method_22942(this.rarityName, startDrawX, startDrawY += (float)(9 + 2), -1, true, matrix, (class_4597)vertexConsumers, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        int startDrawX = x + 2;
        int startDrawY = y + 2;
        if (this.itemDisplayMode.shouldRenderHeader()) {
            context.method_51427(this.stack, startDrawX, startDrawY);
            int color = (Integer)TooltipReforgedConfig.INSTANCE.misc.itemBorderColor.getValue();
            context.method_51737(startDrawX - 3, startDrawY - 2, startDrawX - 3 + 1, startDrawY - 2 + 20, 0, color);
            context.method_51737(startDrawX + 18, startDrawY - 2, startDrawX + 18 + 1, startDrawY - 2 + 20, 0, color);
            context.method_51737(startDrawX - 2, startDrawY - 3, startDrawX - 2 + 20, startDrawY - 3 + 1, 0, color);
            context.method_51737(startDrawX - 2, startDrawY + 18, startDrawX - 2 + 20, startDrawY + 18 + 1, 0, color);
        }
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.itemGroupTooltip.getValue()).booleanValue()) {
            class_2561 text = (class_2561)this.badgePair.getFirst();
            int fillColor = (Integer)this.badgePair.getSecond();
            int textWidth = textRenderer.method_27525((class_5348)text);
            Objects.requireNonNull(textRenderer);
            int textHeight = 9 - 2;
            int textX = x + this.getTitleOffset() + ((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.rarityTooltip.getValue() != false ? textRenderer.method_30880(this.nameText) + 4 + 2 : 4);
            int n = (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.rarityTooltip.getValue() != false ? y - 2 : y - 2 + 12;
            Objects.requireNonNull(textRenderer);
            int textY = n - 9 + 8 + 4;
            context.method_25294(textX - 4, textY - 2, textX + textWidth + 4, textY + textHeight, BadgesUtils.darkenColor(fillColor, 0.9f));
            context.method_51439(textRenderer, text, textX, textY - 1, -1, true);
            BadgesUtils.drawFrame(context, textX - 4, textY - 2, textWidth + 8, textHeight + 4, 400, BadgesUtils.darkenColor(fillColor, 0.8f));
        }
    }
}

