/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.EffectsRenderMode;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5684;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class PotionEffectsComponent
implements class_5684 {
    private final float durationMultiplier;
    private final List<class_1293> effects = new LinkedList<class_1293>();
    private final EffectsRenderMode effectsMode;

    public PotionEffectsComponent(class_1799 stack, float durationMultiplier) {
        this.durationMultiplier = durationMultiplier;
        ((class_1844)stack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274)).method_57402(this.effects::add);
        this.effectsMode = (EffectsRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.effectsTooltip.getValue());
    }

    public int method_32661() {
        return this.effects.size() * 10;
    }

    public int method_32664(class_327 textRenderer) {
        int effectsWidth = 0;
        for (class_1293 effect : this.effects) {
            Object text = class_2561.method_43471((String)effect.method_5586()).getString();
            if (effect.method_5578() > 0) {
                text = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{text, class_2561.method_43471((String)("potion.potency." + effect.method_5578())).getString()}).getString();
            }
            if (!effect.method_48557(20)) {
                text = (String)text + " " + TextUtil.getDurationText(effect, this.durationMultiplier).getString();
            }
            effectsWidth = Math.max(effectsWidth, textRenderer.method_1727((String)text) + 14);
        }
        return effectsWidth + 4;
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        if (!this.effectsMode.shouldRender()) {
            return;
        }
        Objects.requireNonNull(textRenderer);
        int lineY = y - 9 - 1;
        for (class_1293 effect : this.effects) {
            int c = ((class_1291)effect.method_5579().comp_349()).method_5556();
            if (c == 0) {
                c = -11250436;
            }
            class_1058 effectTexture = class_310.method_1551().method_18505().method_18663(effect.method_5579());
            class_5250 mutableText = class_2561.method_43471((String)effect.method_5586());
            if (effect.method_5578() > 0) {
                mutableText = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, class_2561.method_43471((String)("potion.potency." + effect.method_5578()))});
            }
            if (!effect.method_48557(20)) {
                String durationText = TextUtil.getDurationText(effect, this.durationMultiplier).getString();
                mutableText = class_2561.method_43470((String)(mutableText.getString() + " (" + durationText + ")"));
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
            if (this.effectsMode.shouldRenderIcon()) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.method_25298(x - 1, lineY - 1, 0, 9, 9, effectTexture);
                Objects.requireNonNull(textRenderer);
                context.method_51439(textRenderer, (class_2561)mutableText, x + 9 + 2, lineY, c, true);
                continue;
            }
            context.method_51439(textRenderer, (class_2561)mutableText, x, lineY, c, true);
        }
    }
}

