/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.render;

import com.iafenvoy.integration.entrypoint.EntryPointManager;
import com.iafenvoy.tooltipsreforged.BuiltinTooltips;
import com.iafenvoy.tooltipsreforged.TooltipReforgedClient;
import com.iafenvoy.tooltipsreforged.api.TooltipsReforgeEntrypoint;
import com.iafenvoy.tooltipsreforged.component.StandaloneComponent;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.render.ExtendedTooltipBackgroundRenderer;
import com.iafenvoy.tooltipsreforged.util.ExtendedTextVisitor;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5455;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_8000;
import org.joml.Vector2ic;

@Environment(value=EnvType.CLIENT)
public class TooltipsRenderHelper {
    private static final int EDGE_SPACING = 32;
    private static final int PAGE_SPACING = 12;

    public static void render(class_1799 stack, List<class_5684> components, class_332 context, class_327 textRenderer, int mouseX, int mouseY, class_8000 positioner) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_5455 registries = world.method_30349();
        BuiltinTooltips.appendTooltip(stack, components, registries);
        EntryPointManager.getEntryPoints((String)"tooltips_reforged", TooltipsReforgeEntrypoint.class).forEach(e -> e.appendTooltip(stack, components, registries));
        components.removeIf(Objects::isNull);
        if (((Boolean)TooltipReforgedConfig.INSTANCE.misc.removeEmptyLines.getValue()).booleanValue()) {
            components.removeIf(x -> {
                class_5683 ordered;
                return x instanceof class_5683 && ExtendedTextVisitor.getText(TextUtil.getTextFromComponent(ordered = (class_5683)x)).getString().isEmpty();
            });
        }
        ResolveResult result = TooltipsRenderHelper.resolveTooltips(textRenderer, components);
        Vector2ic position = TooltipsRenderHelper.resolvePosition(result, context, mouseX, mouseY, positioner);
        TooltipsRenderHelper.drawWithResult(result, stack, context, textRenderer, position.x(), position.y());
    }

    public static ResolveResult resolveTooltips(class_327 textRenderer, List<class_5684> components) {
        if (components.isEmpty()) {
            return new ResolveResult(List.of(), List.of(), 0);
        }
        LinkedList<Page> pageList = new LinkedList<Page>();
        LinkedList<StandaloneComponent> standaloneComponents = new LinkedList<StandaloneComponent>();
        int maxWidth = TooltipsRenderHelper.getMaxWidth();
        int maxHeight = TooltipsRenderHelper.getMaxHeight();
        int totalWidth = 0;
        int pageHeight = -2;
        Page p = new Page();
        for (class_5684 component : components) {
            if (component instanceof StandaloneComponent) {
                StandaloneComponent standalone = (StandaloneComponent)component;
                standaloneComponents.add(standalone);
                continue;
            }
            int width = component.method_32664(textRenderer);
            int height = component.method_32661();
            if (width > maxWidth) {
                int wrappedWidth = component.method_32664(textRenderer);
                int wrappedHeight = component.method_32661();
                if (pageHeight + wrappedHeight > maxHeight) {
                    pageList.add(p);
                    totalWidth += p.width;
                    p = new Page();
                    pageHeight = -2;
                }
                p.components.add(component);
                p.height = pageHeight += wrappedHeight;
                p.width = Math.max(p.width, wrappedWidth);
                continue;
            }
            if (pageHeight + height > maxHeight) {
                pageList.add(p);
                totalWidth += p.width;
                p = new Page();
                pageHeight = -2;
            }
            p.components.add(component);
            p.height = pageHeight += height;
            p.width = Math.max(p.width, width);
        }
        if (!p.components.isEmpty()) {
            pageList.add(p);
            totalWidth += p.width;
        }
        return new ResolveResult(pageList, standaloneComponents, totalWidth);
    }

    public static Vector2ic resolvePosition(ResolveResult result, class_332 context, int mouseX, int mouseY, class_8000 positioner) {
        return positioner.method_47944(context.method_51421(), context.method_51443(), mouseX, mouseY, result.totalWidth, result.pages.getFirst().height);
    }

    public static void drawWithResult(ResolveResult result, class_1799 stack, class_332 context, class_327 textRenderer, int x, int y) {
        if (result.pages.isEmpty()) {
            return;
        }
        int currentX = x;
        for (Page page : result.pages) {
            page.x = currentX;
            page.y = y - (result.pages.size() > 1 ? 32 : 6);
            currentX += page.width + 12;
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        for (Page page : result.pages) {
            ExtendedTooltipBackgroundRenderer.render(stack, context, page.x, page.y, page.width, page.height, 0);
            int currentY = page.y;
            for (class_5684 component : page.components) {
                try {
                    component.method_32665(textRenderer, page.x, currentY, context.method_51448().method_23760().method_23761(), context.method_51450());
                    component.method_32666(textRenderer, page.x, currentY, context);
                    currentY += component.method_32661();
                }
                catch (Exception e) {
                    TooltipReforgedClient.LOGGER.error("{}", (Object)"tooltips_reforged", (Object)e);
                }
            }
        }
        for (StandaloneComponent component : result.standalone) {
            try {
                component.render(context, textRenderer, x, y, 0);
            }
            catch (Exception e) {
                TooltipReforgedClient.LOGGER.error("{}", (Object)"tooltips_reforged", (Object)e);
            }
        }
        context.method_51448().method_22909();
    }

    private static int getMaxHeight() {
        return class_310.method_1551().method_22683().method_4502() - 64;
    }

    private static int getMaxWidth() {
        return class_310.method_1551().method_22683().method_4486() / 2 - 32;
    }

    public static void drawNineSlicedTexture(class_332 context, class_2960 texture, int x, int y, int width, int height, int border, int textureWidth, int textureHeight) {
        context.method_25290(texture, x, y, 0.0f, 0.0f, border, border, textureWidth, textureHeight);
        TooltipsRenderHelper.drawRepeatingTexture(context, texture, x + border, y, width - border * 2, border, border, 0, textureWidth - border * 2, border, textureWidth, textureHeight);
        context.method_25290(texture, x + width - border, y, (float)(textureWidth - border), 0.0f, border, border, textureWidth, textureHeight);
        TooltipsRenderHelper.drawRepeatingTexture(context, texture, x, y + border, border, height - border * 2, 0, border, border, textureHeight - border * 2, textureWidth, textureHeight);
        TooltipsRenderHelper.drawRepeatingTexture(context, texture, x + border, y + border, width - border * 2, height - border * 2, border, border, textureWidth - border * 2, textureHeight - border * 2, textureWidth, textureHeight);
        TooltipsRenderHelper.drawRepeatingTexture(context, texture, x + width - border, y + border, border, height - border * 2, textureWidth - border, border, border, textureHeight - border * 2, textureWidth, textureHeight);
        context.method_25290(texture, x, y + height - border, 0.0f, (float)(textureHeight - border), border, border, textureWidth, textureHeight);
        TooltipsRenderHelper.drawRepeatingTexture(context, texture, x + border, y + height - border, width - border * 2, border, border, textureHeight - border, textureWidth - border * 2, border, textureWidth, textureHeight);
        context.method_25290(texture, x + width - border, y + height - border, (float)(textureWidth - border), (float)(textureHeight - border), border, border, textureWidth, textureHeight);
    }

    public static void drawRepeatingTexture(class_332 context, class_2960 texture, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        int j;
        int i = 0;
        while (i + regionWidth < width) {
            j = 0;
            while (j + regionHeight < height) {
                context.method_25290(texture, x + i, y + j, (float)u, (float)v, regionWidth, regionHeight, textureWidth, textureHeight);
                j += regionHeight;
            }
            context.method_25290(texture, x + i, y + j, (float)u, (float)v, regionWidth, height - j, textureWidth, textureHeight);
            i += regionWidth;
        }
        j = 0;
        while (j + regionHeight < height) {
            context.method_25290(texture, x + i, y + j, (float)u, (float)v, width - i, regionHeight, textureWidth, textureHeight);
            j += regionHeight;
        }
        context.method_25290(texture, x + i, y + j, (float)u, (float)v, width - i, height - j, textureWidth, textureHeight);
    }

    public record ResolveResult(List<Page> pages, List<StandaloneComponent> standalone, int totalWidth) {
    }

    public static class Page {
        private int x;
        private int y;
        private int width;
        private int height;
        private final List<class_5684> components;

        private Page() {
            this(0, 0, 0, 0, new LinkedList<class_5684>());
        }

        private Page(int x, int y, int width, int height, List<class_5684> components) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.components = components;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

