/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.util;

import com.iafenvoy.tooltipsreforged.Static;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class BadgesUtils {
    private static final Map<String, String> MODS_MAP = Static.getAllMods();

    @NotNull
    public static Pair<class_2561, Integer> getBadgeText(class_1799 stack) {
        String namespace = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836();
        return new Pair((Object)class_2561.method_43470((String)MODS_MAP.getOrDefault(namespace, "Minecraft")), (Object)BadgesUtils.getColorFromModName(namespace));
    }

    public static int darkenColor(int color, float factor) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = Math.max(0, (int)((float)red * factor));
        green = Math.max(0, (int)((float)green * factor));
        blue = Math.max(0, (int)((float)blue * factor));
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int getColorFromModName(String modName) {
        int hash = modName.hashCode();
        int r = hash >> 16 & 0xFF;
        int g = hash >> 8 & 0xFF;
        int b = hash & 0xFF;
        int a = 255;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void drawFrame(class_332 context, int x, int y, int width, int height, int z, int color) {
        BadgesUtils.renderVerticalLine(context, x, y, height - 2, z, color);
        BadgesUtils.renderVerticalLine(context, x + width - 1, y, height - 2, z, color);
        BadgesUtils.renderHorizontalLine(context, x + 1, y - 1, width - 2, z, color);
        BadgesUtils.renderHorizontalLine(context, x + 1, y - 1 + height - 1, width - 2, z, color);
    }

    private static void renderVerticalLine(class_332 context, int x, int y, int height, int z, int color) {
        context.method_51737(x, y, x + 1, y + height, z, color);
    }

    private static void renderHorizontalLine(class_332 context, int x, int y, int width, int z, int color) {
        context.method_51737(x, y, x + width, y + 1, z, color);
    }
}

