/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public final class ComponentsProcessor {
    public static final List<String> DEFAULT_IGNORED = List.of("minecraft:max_stack_size", "minecraft:rarity");

    public static List<class_5250> processStack(class_1799 stack, class_5455 registries) {
        List ignored = (List)TooltipReforgedConfig.INSTANCE.misc.ignoredComponents.getValue();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_9331 type : stack.method_57353().method_57831()) {
            class_2960 id = class_7923.field_49658.method_10221((Object)type);
            if (id != null && ignored.contains(id.toString())) continue;
            builder.addAll(ComponentsProcessor.processSingle(id, ComponentsProcessor.serialize(type, stack, registries)));
        }
        return builder.build();
    }

    private static <T> String serialize(class_9331<T> type, class_1799 stack, class_5455 registries) {
        return ((JsonElement)type.method_57876().encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registries), stack.method_57824(type)).resultOrPartial().orElse(new JsonObject())).toString();
    }

    public static List<class_5250> processSingle(@Nullable class_2960 id, String json) {
        class_5250 mutableText;
        Pattern p = Pattern.compile("[{}:\"\\[\\],']", 2);
        class_5250 class_52502 = mutableText = id == null ? class_2561.method_43473() : class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)id.toString()).method_27692(class_124.field_1080)).method_27693(" ");
        if (!p.asPredicate().test(json)) {
            return List.of(mutableText.method_10852((class_2561)class_2561.method_43470((String)json).method_27692(class_124.field_1068)));
        }
        LinkedList<class_5250> list = new LinkedList<class_5250>();
        Matcher m = p.matcher(json);
        int lineStep = 50;
        class_124 stringColour = class_124.field_1060;
        class_124 quotationColour = class_124.field_1063;
        class_124 separationColour = class_124.field_1063;
        class_124 integerColour = class_124.field_1065;
        class_124 typeColour = class_124.field_1061;
        class_124 fieldColour = class_124.field_1075;
        class_124 lstringColour = class_124.field_1054;
        int lineLimit = lineStep;
        int removedCharters = 0;
        int lastIndex = 0;
        Boolean singleQuotationMark = Boolean.FALSE;
        Boolean lineAdded = Boolean.FALSE;
        String lastString = "";
        while (m.find()) {
            lineAdded = Boolean.FALSE;
            if (json.charAt(m.start()) == '\'') {
                if (singleQuotationMark.equals(Boolean.FALSE)) {
                    mutableText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(json.charAt(m.start()))).method_27692(quotationColour));
                    singleQuotationMark = Boolean.TRUE;
                } else {
                    mutableText.method_10852((class_2561)class_2561.method_43470((String)json.substring(lastIndex + 1, m.start())).method_27692(stringColour));
                    mutableText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(json.charAt(m.start()))).method_27692(quotationColour));
                    singleQuotationMark = Boolean.FALSE;
                }
                lastString = String.valueOf(json.charAt(m.start()));
                lastIndex = m.start();
            }
            if (!singleQuotationMark.booleanValue()) {
                if (json.charAt(m.start()) == '{' || json.charAt(m.start()) == '[') {
                    mutableText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(json.charAt(m.start()))).method_27692(separationColour));
                    lastString = String.valueOf(json.charAt(m.start()));
                    lastIndex = m.start();
                }
                if (json.charAt(m.start()) == '}' || json.charAt(m.start()) == ']' || json.charAt(m.start()) == ',') {
                    if (json.charAt(m.start() - 1) == 's' || json.charAt(m.start() - 1) == 'S' || json.charAt(m.start() - 1) == 'b' || json.charAt(m.start() - 1) == 'B' || json.charAt(m.start() - 1) == 'l' || json.charAt(m.start() - 1) == 'L' || json.charAt(m.start() - 1) == 'f' || json.charAt(m.start() - 1) == 'F') {
                        mutableText.method_10852((class_2561)class_2561.method_43470((String)json.substring(lastIndex + 1, m.start() - 1)).method_27692(integerColour));
                        mutableText.method_10852((class_2561)class_2561.method_43470((String)json.substring(m.start() - 1, m.start())).method_27692(typeColour));
                    } else {
                        mutableText.method_10852((class_2561)class_2561.method_43470((String)json.substring(lastIndex + 1, m.start())).method_27692(integerColour));
                    }
                    mutableText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(json.charAt(m.start())))).method_27692(separationColour);
                    if (json.charAt(m.start()) == ',') {
                        mutableText.method_10852((class_2561)class_2561.method_43470((String)" ").method_27692(separationColour));
                    }
                    lastString = String.valueOf(json.charAt(m.start()));
                    lastIndex = m.start();
                }
                if (json.charAt(m.start()) == ':' && !lastString.equals("\"")) {
                    mutableText.method_10852((class_2561)class_2561.method_43470((String)json.substring(lastIndex + 1, m.start())).method_27692(fieldColour));
                    mutableText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(json.charAt(m.start()))).method_27692(separationColour));
                    mutableText.method_10852((class_2561)class_2561.method_43470((String)" ").method_27692(separationColour));
                    lastString = String.valueOf(json.charAt(m.start()));
                    lastIndex = m.start();
                }
                if (json.charAt(m.start()) == '\"') {
                    if (lastString.equals("\"")) {
                        if (m.start() - lineLimit > lineStep) {
                            mutableText.method_10852((class_2561)class_2561.method_43470((String)"....").method_27692(lstringColour));
                            removedCharters += m.start() - lineLimit;
                        } else {
                            mutableText.method_10852((class_2561)class_2561.method_43470((String)json.substring(lastIndex + 1, m.start())).method_27692(stringColour));
                        }
                        mutableText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(json.charAt(m.start()))).method_27692(quotationColour));
                    } else {
                        mutableText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(json.charAt(m.start()))).method_27692(quotationColour));
                    }
                    lastString = String.valueOf(json.charAt(m.start()));
                    lastIndex = m.start();
                }
            }
            if (m.start() - removedCharters < lineLimit || json.charAt(m.start()) != '}' && json.charAt(m.start()) != ']' && json.charAt(m.start()) != ',') continue;
            if (lastString.equals("'")) {
                mutableText.method_10852((class_2561)class_2561.method_43470((String)json.substring(lastIndex + 1, m.start())).method_27692(stringColour));
                lastIndex = m.start();
            }
            list.add(mutableText);
            mutableText = class_2561.method_43470((String)"     ");
            lineAdded = Boolean.TRUE;
            lineLimit += lineStep;
        }
        if (lineAdded.equals(Boolean.FALSE)) {
            list.add(mutableText);
        }
        return list;
    }
}

