/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.util;

import com.iafenvoy.tooltipsreforged.util.ComponentsProcessor;
import it.unimi.dsi.fastutil.objects.ObjectLongImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectLongPair;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3483;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class InfoCollectHelper {
    private static final List<class_6880<class_1320>> ATTRIBUTES = List.of(class_5134.field_23716, class_5134.field_23719, class_5134.field_23721, class_5134.field_23724, class_5134.field_23717, class_5134.field_23718, class_5134.field_23722);

    public static List<String> collectItemTags(class_1799 stack) {
        return class_7923.field_41178.method_47983((Object)stack.method_7909()).method_40228().map(class_6862::comp_327).map(x -> "#" + x.toString()).toList();
    }

    public static List<String> collectBlockTags(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return class_7923.field_41175.method_47983((Object)blockItem.method_7711()).method_40228().map(class_6862::comp_327).map(x -> "#" + x.toString()).toList();
        }
        return List.of();
    }

    public static List<String> collectEntityTags(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1826) {
            class_1826 eggItem = (class_1826)class_17922;
            return class_7923.field_41177.method_47983((Object)eggItem.method_8015(stack)).method_40228().map(class_6862::comp_327).map(x -> "#" + x.toString()).toList();
        }
        return List.of();
    }

    public static List<class_5250> collectEntityInfo(class_1799 stack) {
        LinkedList<class_5250> list = new LinkedList<class_5250>();
        class_638 world = class_310.method_1551().field_1687;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1826) {
            class_1826 eggItem = (class_1826)class_17922;
            if (world != null && (class_17922 = eggItem.method_8015(stack).method_5883((class_1937)world)) instanceof class_1309) {
                class_1309 living = (class_1309)class_17922;
                DecimalFormat df = new DecimalFormat("#.##");
                ATTRIBUTES.forEach(attribute -> {
                    class_1324 instance = living.method_5996(attribute);
                    if (instance != null) {
                        list.add(class_2561.method_43471((String)((class_1320)attribute.comp_349()).method_26830()).method_27693(": ").method_27693(df.format(instance.method_6194())).method_27692(class_124.field_1080));
                    }
                });
                list.add(class_2561.method_43471((String)"text.tooltips_reforged.mob_type").method_10852((class_2561)class_2561.method_43471((String)InfoCollectHelper.getMobType(living.method_5864()))).method_27692(class_124.field_1080));
            }
        }
        return list;
    }

    public static List<class_5250> collectNbt(class_1799 stack, class_5455 registries) {
        return ComponentsProcessor.processStack(stack, registries);
    }

    private static String getMobType(class_1299<?> type) {
        if (type.method_20210(class_3483.field_46232)) {
            return "type.tooltips_reforged.undead";
        }
        if (type.method_20210(class_3483.field_48289)) {
            return "type.tooltips_reforged.arthropod";
        }
        if (type.method_20210(class_3483.field_48287)) {
            return "type.tooltips_reforged.illager";
        }
        if (type.method_20210(class_3483.field_48288)) {
            return "type.tooltips_reforged.aquatic";
        }
        return "type.tooltips_reforged.default";
    }

    @Nullable
    public static ObjectLongPair<class_2960> collectLootTable(class_1799 stack) {
        class_2487 nbt = ((class_9279)stack.method_57825(class_9334.field_49611, (Object)class_9279.field_49302)).method_57461();
        if (nbt != null && nbt.method_10573("LootTable", 8)) {
            return new ObjectLongImmutablePair((Object)class_2960.method_12829((String)nbt.method_10558("LootTable")), nbt.method_10537("LootTableSeed"));
        }
        return null;
    }

    @Nullable
    public static class_2371<class_1799> collectContainer(class_1799 stack, class_7225.class_7874 registries) {
        class_2371 stacks = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
        class_2487 nbt = ((class_9279)stack.method_57825(class_9334.field_49611, (Object)class_9279.field_49302)).method_57461();
        if (nbt == null || !nbt.method_10573("Items", 9)) {
            return null;
        }
        class_1262.method_5429((class_2487)nbt, (class_2371)stacks, (class_7225.class_7874)registries);
        return stacks;
    }
}

