/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged;

import com.iafenvoy.tooltipsreforged.component.BannerPatternComponent;
import com.iafenvoy.tooltipsreforged.component.ContainerPreviewComponent;
import com.iafenvoy.tooltipsreforged.component.DebugInfoComponent;
import com.iafenvoy.tooltipsreforged.component.DurabilityComponent;
import com.iafenvoy.tooltipsreforged.component.EnchantmentsComponent;
import com.iafenvoy.tooltipsreforged.component.EntityViewerComponent;
import com.iafenvoy.tooltipsreforged.component.EquipmentCompareComponent;
import com.iafenvoy.tooltipsreforged.component.EquipmentViewerComponent;
import com.iafenvoy.tooltipsreforged.component.FoodEffectComponent;
import com.iafenvoy.tooltipsreforged.component.HeaderComponent;
import com.iafenvoy.tooltipsreforged.component.ItemZoomComponent;
import com.iafenvoy.tooltipsreforged.component.MapComponent;
import com.iafenvoy.tooltipsreforged.component.PaintingComponent;
import com.iafenvoy.tooltipsreforged.component.PotionEffectsComponent;
import com.iafenvoy.tooltipsreforged.mixin.DecorationItemAccessor;
import com.iafenvoy.tooltipsreforged.util.ExtendedTextVisitor;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BuiltinTooltips {
    public static void appendTooltip(ItemStack stack, List<ClientTooltipComponent> components) {
        DecorationItemAccessor accessor;
        Item item;
        if (!components.isEmpty()) {
            components.remove(0);
        }
        LinkedList<ClientTooltipComponent> headers = new LinkedList<ClientTooltipComponent>();
        headers.add(new HeaderComponent(stack));
        headers.add(new ItemZoomComponent(stack));
        if (stack.m_41720_() instanceof LingeringPotionItem) {
            headers.add(new PotionEffectsComponent(stack, 0.25f));
        } else if (stack.m_41720_() instanceof PotionItem) {
            headers.add(new PotionEffectsComponent(stack, 1.0f));
        } else if (stack.m_41720_() instanceof TippedArrowItem) {
            headers.add(new PotionEffectsComponent(stack, 0.125f));
        }
        if (stack.m_41720_().m_41473_() != null) {
            headers.add(new FoodEffectComponent(stack));
        }
        if (stack.m_41720_() instanceof EnchantedBookItem) {
            headers.add(new EnchantmentsComponent(EnchantedBookItem.m_41163_((ItemStack)stack)));
        }
        if (stack.m_41720_().m_8120_(stack)) {
            headers.add(new EnchantmentsComponent(EnchantmentHelper.m_44831_((ItemStack)stack)));
        }
        components.addAll(0, headers);
        if (stack.m_41720_() instanceof Equipable || stack.m_41720_() instanceof PlayerHeadItem) {
            components.add(new EquipmentViewerComponent(stack));
            components.add(new EquipmentCompareComponent(stack));
        }
        if (stack.m_41720_() instanceof MobBucketItem || stack.m_41720_() instanceof SpawnEggItem) {
            components.add(new EntityViewerComponent(stack));
        }
        components.add(new ContainerPreviewComponent(stack));
        if (stack.m_41720_() instanceof MapItem) {
            components.add(new MapComponent(stack));
        }
        if ((item = stack.m_41720_()) instanceof DecorationItemAccessor && (accessor = (DecorationItemAccessor)item).getEntityType() == EntityType.f_20506_) {
            components.add(new PaintingComponent(stack));
        }
        if (stack.m_41720_() instanceof BannerPatternItem) {
            components.add(new BannerPatternComponent(stack));
        }
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            for (int i = 0; i < components.size(); ++i) {
                ClientTextTooltip ordered;
                ClientTooltipComponent component = components.get(i);
                if (!(component instanceof ClientTextTooltip) || !ExtendedTextVisitor.getText(TextUtil.getTextFromComponent(ordered = (ClientTextTooltip)component)).getString().contains(stack.m_41776_() - stack.m_41773_() + " / " + stack.m_41776_())) continue;
                components.set(i, new DurabilityComponent(stack));
                break;
            }
            components.add(new DebugInfoComponent(stack));
        } else {
            components.add(new DurabilityComponent(stack));
        }
    }
}

