/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.util.InfoCollectHelper;
import com.iafenvoy.tooltipsreforged.util.TooltipKeyManager;
import it.unimi.dsi.fastutil.objects.ObjectLongPair;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class DebugInfoComponent
implements ClientTooltipComponent {
    private static final TooltipKeyManager KEY_MANAGER = new TooltipKeyManager();
    private final List<String> itemTags;
    private final List<String> blockTags;
    private final List<String> entityTags;
    private final List<MutableComponent> nbt;
    private final List<MutableComponent> entityInfo;
    private final ObjectLongPair<ResourceLocation> lootTable;

    public DebugInfoComponent(ItemStack stack) {
        this.itemTags = InfoCollectHelper.collectItemTags(stack);
        this.blockTags = InfoCollectHelper.collectBlockTags(stack);
        this.entityTags = InfoCollectHelper.collectEntityTags(stack);
        this.nbt = InfoCollectHelper.collectNbt(stack);
        this.entityInfo = InfoCollectHelper.collectEntityInfo(stack);
        this.lootTable = InfoCollectHelper.collectLootTable(stack);
    }

    public int m_142103_() {
        return (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.debugInfoTooltip.getValue() != false ? this.getDisplayTexts().size() * 10 : 0;
    }

    public int m_142069_(Font textRenderer) {
        return this.getDisplayTexts().stream().map(arg_0 -> ((Font)textRenderer).m_92852_(arg_0)).reduce(0, Math::max, Math::max);
    }

    public void m_142440_(Font textRenderer, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource vertexConsumers) {
        if (!((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.debugInfoTooltip.getValue()).booleanValue()) {
            return;
        }
        float currentY = y + 1;
        for (Component component : this.getDisplayTexts()) {
            textRenderer.m_272077_(component, (float)x, currentY, -1, true, matrix, (MultiBufferSource)vertexConsumers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            currentY += 10.0f;
        }
        KEY_MANAGER.renderTick();
    }

    private List<MutableComponent> getDisplayTexts() {
        MutableComponent first = Component.m_237119_();
        boolean hasInfo = false;
        List<Object> infos = List.of();
        Tuple<String, List<MutableComponent>> itemTagInfo = this.getItemTagInfo();
        TooltipKeyManager.PressState itemTagState = KEY_MANAGER.itemTag();
        if (itemTagInfo != null && itemTagState.show()) {
            hasInfo = true;
            if (itemTagState.showDetail()) {
                first.m_7220_((Component)Component.m_237113_((String)"[%s %s] ".formatted(TooltipKeyManager.itemTagKeyTranslation(), I18n.m_118938_((String)((String)itemTagInfo.m_14418_()), (Object[])new Object[0]))).m_130940_(ChatFormatting.WHITE));
                infos = ((List)itemTagInfo.m_14419_()).stream().map(x -> x.m_130940_(ChatFormatting.DARK_GRAY)).toList();
            } else {
                first.m_7220_((Component)Component.m_237113_((String)"[%s %s] ".formatted(TooltipKeyManager.itemTagKeyTranslation(), I18n.m_118938_((String)((String)itemTagInfo.m_14418_()), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
            }
        }
        Tuple<String, List<MutableComponent>> specificInfo = this.getSpecificInfo();
        TooltipKeyManager.PressState specificState = KEY_MANAGER.specific();
        if (specificInfo != null && specificState.show()) {
            hasInfo = true;
            if (specificState.showDetail()) {
                first.m_7220_((Component)Component.m_237113_((String)"[%s %s] ".formatted(TooltipKeyManager.specificKeyTranslation(), I18n.m_118938_((String)((String)specificInfo.m_14418_()), (Object[])new Object[0]))).m_130940_(ChatFormatting.WHITE));
                infos = ((List)specificInfo.m_14419_()).stream().map(x -> x.m_130940_(ChatFormatting.DARK_GRAY)).toList();
            } else {
                first.m_7220_((Component)Component.m_237113_((String)"[%s %s] ".formatted(TooltipKeyManager.specificKeyTranslation(), I18n.m_118938_((String)((String)specificInfo.m_14418_()), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
            }
        }
        Tuple<String, List<MutableComponent>> nbtInfo = this.getNbtInfo();
        TooltipKeyManager.PressState nbtState = KEY_MANAGER.nbt();
        if (nbtInfo != null && nbtState.show()) {
            hasInfo = true;
            if (nbtState.showDetail()) {
                first.m_7220_((Component)Component.m_237113_((String)"[%s %s] ".formatted(TooltipKeyManager.nbtKeyTranslation(), I18n.m_118938_((String)((String)nbtInfo.m_14418_()), (Object[])new Object[0]))).m_130940_(ChatFormatting.WHITE));
                infos = ((List)nbtInfo.m_14419_()).stream().map(x -> x.m_130940_(ChatFormatting.DARK_GRAY)).toList();
            } else {
                first.m_7220_((Component)Component.m_237113_((String)"[%s %s] ".formatted(TooltipKeyManager.nbtKeyTranslation(), I18n.m_118938_((String)((String)nbtInfo.m_14418_()), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
            }
        }
        return hasInfo ? ImmutableList.builder().add((Object)first).addAll(infos).build() : List.of();
    }

    @Nullable
    private Tuple<String, List<MutableComponent>> getItemTagInfo() {
        if (!this.itemTags.isEmpty()) {
            return new Tuple((Object)"tooltip.tooltips_reforged.item_tags", this.itemTags.stream().map(Component::m_237113_).toList());
        }
        return null;
    }

    @Nullable
    private Tuple<String, List<MutableComponent>> getSpecificInfo() {
        if (!this.blockTags.isEmpty()) {
            return new Tuple((Object)"tooltip.tooltips_reforged.block_tags", this.blockTags.stream().map(Component::m_237113_).toList());
        }
        if (!this.entityTags.isEmpty()) {
            return new Tuple((Object)"tooltip.tooltips_reforged.entity_tags", this.entityTags.stream().map(Component::m_237113_).toList());
        }
        if (this.lootTable != null && this.lootTable.left() != null) {
            return new Tuple((Object)"tooltip.tooltips_reforged.loot_table", List.of(Component.m_237113_((String)("tooltip.tooltips_reforged.id" + ((ResourceLocation)this.lootTable.left()).toString())), Component.m_237113_((String)("tooltip.tooltips_reforged.seed" + this.lootTable.rightLong()))));
        }
        return null;
    }

    @Nullable
    private Tuple<String, List<MutableComponent>> getNbtInfo() {
        if (!this.entityInfo.isEmpty()) {
            return new Tuple((Object)"tooltip.tooltips_reforged.mob_info", this.entityInfo);
        }
        if (!this.nbt.isEmpty()) {
            return new Tuple((Object)"tooltip.tooltips_reforged.nbt", this.nbt);
        }
        return null;
    }
}

