/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.DurabilityRenderMode;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import com.iafenvoy.tooltipsreforged.util.BadgesUtils;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DurabilityComponent
implements ClientTooltipComponent,
RenderHelper {
    private static final int WIDTH = 80;
    protected final ItemStack stack;
    private final DurabilityRenderMode mode;
    private final boolean enabled;
    private final int color;
    private final Component text;

    public DurabilityComponent(ItemStack stack) {
        this.stack = stack;
        this.mode = (DurabilityRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.durabilityTooltip.getValue());
        this.enabled = this.mode.isEnabled() && this.stack.m_41763_() && this.stack.m_41776_() > 0;
        this.color = stack.m_150949_();
        this.text = this.enabled ? DurabilityComponent.getDurabilityText(stack, this.mode) : Component.m_237113_((String)"");
    }

    private static Component getDurabilityText(ItemStack stack, DurabilityRenderMode mode) {
        int maxDamage = stack.m_41776_();
        int damaged = maxDamage - stack.m_41773_();
        if (mode.shouldInPercentage() && maxDamage > 0) {
            MutableComponent percentageText = Component.m_237113_((String)(" " + damaged * 100 / maxDamage + "%"));
            return mode.shouldColorText() ? (Component)percentageText.m_178405_(Style.f_131099_.m_178520_(stack.m_150949_())).get(0) : percentageText;
        }
        return mode.shouldColorText() ? Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)String.valueOf(damaged)).m_6270_(Style.f_131099_.m_178520_(stack.m_150949_()))).m_7220_((Component)Component.m_237113_((String)" / ").m_6270_(Style.f_131099_.m_178520_(-8355712))).m_7220_((Component)Component.m_237113_((String)String.valueOf(maxDamage)).m_6270_(Style.f_131099_.m_178520_(-16711936))) : Component.m_237113_((String)(" " + damaged + " / " + maxDamage));
    }

    public int m_142103_() {
        return this.enabled ? (this.mode.shouldRenderBackground() ? 13 : 9) : 0;
    }

    public int m_142069_(Font textRenderer) {
        if (!this.enabled) {
            return 0;
        }
        int width = textRenderer.m_92852_((FormattedText)Component.m_237115_((String)"tooltip.%s.durability".formatted("tooltips_reforged")));
        if (this.mode.shouldRenderBackground()) {
            return width + 4 + 80 - 5;
        }
        return width + textRenderer.m_92852_((FormattedText)this.text);
    }

    public void m_183452_(Font textRenderer, int x, int y, GuiGraphics context) {
        if (!this.enabled) {
            return;
        }
        boolean background = this.mode.shouldRenderBackground();
        if (background) {
            y += 2;
        }
        Objects.requireNonNull(textRenderer);
        int textHeight = 9;
        int textY = background ? y - textHeight + 8 + 2 : y;
        MutableComponent durability = Component.m_237115_((String)"tooltip.%s.durability".formatted("tooltips_reforged"));
        context.m_280614_(textRenderer, (Component)durability, x, textY, -1, true);
        x += textRenderer.m_92852_((FormattedText)durability) + 4 - 4;
        int damaged = this.stack.m_41776_() - this.stack.m_41773_();
        if (background) {
            int color = BadgesUtils.darkenColor(0xFF000000 | this.color, 0.9f);
            context.m_280509_(x, textY - 2 + 1, x + damaged * 80 / this.stack.m_41776_(), textY + textHeight - 1, color);
            BadgesUtils.drawFrame(context, x, textY - 2 + 1, 80, textHeight + 4 - 2, 400, BadgesUtils.darkenColor(0xFF000000 | this.stack.m_150949_(), 0.8f));
        }
        int textX = background ? x + (80 - textRenderer.m_92852_((FormattedText)this.text)) / 2 - 1 : x - 4;
        context.m_280614_(textRenderer, this.text, textX, textY, -1, true);
    }
}

