/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.EnchantmentSortMode;
import com.iafenvoy.tooltipsreforged.config.mode.EnchantmentsRenderMode;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import com.iafenvoy.tooltipsreforged.util.InfoCollectHelper;
import com.iafenvoy.tooltipsreforged.util.RandomHelper;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnchantmentsComponent
implements ClientTooltipComponent,
RenderHelper {
    private final List<EnchantmentInfo> enchantments = new LinkedList<EnchantmentInfo>();
    private final EnchantmentsRenderMode mode;
    private final boolean extraColor;

    public EnchantmentsComponent(ListTag list) {
        this(EnchantmentHelper.m_44882_((ListTag)list));
    }

    public EnchantmentsComponent(Map<Enchantment, Integer> map) {
        this.mode = (EnchantmentsRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.enchantmentTooltip.getValue());
        for (Map.Entry<Enchantment, Integer> entry : map.entrySet()) {
            Enchantment enchantment = entry.getKey();
            String descriptionKey = enchantment.m_44704_() + ".desc";
            this.enchantments.add(new EnchantmentInfo(enchantment, entry.getValue(), I18n.m_118936_((String)descriptionKey) ? TextUtil.splitText(Component.m_237113_((String)I18n.m_118938_((String)descriptionKey, (Object[])new Object[0])), 300, Minecraft.m_91087_().f_91062_) : List.of()));
        }
        this.enchantments.sort(((EnchantmentSortMode)((Object)TooltipReforgedConfig.INSTANCE.misc.enchantmentSort.getValue())).getComparator());
        this.extraColor = (Boolean)TooltipReforgedConfig.INSTANCE.misc.advancedEnchantmentColor.getValue();
    }

    private static boolean isShiftDown() {
        long handle = Minecraft.m_91087_().m_91268_().m_85439_();
        return InputConstants.m_84830_((long)handle, (int)340) || InputConstants.m_84830_((long)handle, (int)344);
    }

    private boolean shouldDisplayDetail() {
        return this.mode.shouldAlwaysDescription() || EnchantmentsComponent.isShiftDown();
    }

    public int m_142103_() {
        boolean includeDetail = this.shouldDisplayDetail();
        return this.mode.shouldRender() ? this.enchantments.stream().reduce(0, (p, c) -> p + c.getHeight(includeDetail), Integer::sum) : 0;
    }

    public int m_142069_(Font textRenderer) {
        boolean includeDetail = this.shouldDisplayDetail();
        return this.mode.shouldRender() ? this.enchantments.stream().reduce(0, (p, c) -> Math.max(p, c.getWidth(textRenderer, includeDetail)), Math::max) : 0;
    }

    public void m_183452_(Font textRenderer, int x, int y, GuiGraphics context) {
        if (!this.mode.shouldRender()) {
            return;
        }
        int currentY = y;
        for (EnchantmentInfo info : this.enchantments) {
            int currentX = x;
            Component name = EnchantmentsComponent.getEnchantmentName(info.enchantment, info.level, this.extraColor);
            context.m_280614_(textRenderer, name, currentX, currentY, -1, true);
            this.drawStack(context, new ItemStack((ItemLike)RandomHelper.pick(InfoCollectHelper.getEnchantmentTarget(info.enchantment.f_44672_), Items.f_41852_)), currentX += textRenderer.m_92852_((FormattedText)name) + 2, currentY, 10.0f);
            currentX += 12;
            if (Minecraft.m_91087_().f_91066_.f_92125_) {
                context.m_280056_(textRenderer, info.id.toString(), currentX, currentY, 0x555555, true);
            }
            currentY += 10;
            if (!this.shouldDisplayDetail()) continue;
            for (MutableComponent text : info.descriptions) {
                context.m_280614_(textRenderer, (Component)text.m_130940_(ChatFormatting.DARK_GRAY), x, currentY, -1, true);
                currentY += 10;
            }
        }
    }

    private static Component getEnchantmentName(Enchantment enchantment, int level, boolean extraColor) {
        MutableComponent mutableText = Component.m_237115_((String)enchantment.m_44704_());
        if (enchantment.m_6589_()) {
            mutableText.m_130940_(ChatFormatting.RED);
        } else if (extraColor && enchantment.m_6586_() < level) {
            mutableText.m_130940_(ChatFormatting.LIGHT_PURPLE);
        } else if (extraColor) {
            mutableText.m_130940_(ChatFormatting.GREEN);
        } else {
            mutableText.m_130940_(ChatFormatting.GRAY);
        }
        if (level != 1 || enchantment.m_6586_() != 1) {
            mutableText.m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237115_((String)("enchantment.level." + level))).m_7220_((Component)Component.m_237113_((String)"/").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + enchantment.m_6586_()))).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return mutableText;
    }

    public record EnchantmentInfo(Enchantment enchantment, int level, ResourceLocation id, List<MutableComponent> descriptions) {
        public EnchantmentInfo(Enchantment enchantment, int level, List<MutableComponent> description) {
            this(enchantment, level, Objects.requireNonNullElse(BuiltInRegistries.f_256876_.m_7981_((Object)enchantment), ResourceLocation.m_214293_((String)"", (String)"")), description);
        }

        public int getWidth(Font textRenderer, boolean includeDetail) {
            int width = textRenderer.m_92852_((FormattedText)EnchantmentsComponent.getEnchantmentName(this.enchantment, this.level, false)) + 14 + (Minecraft.m_91087_().f_91066_.f_92125_ ? textRenderer.m_92895_(this.id.toString()) : 0);
            if (includeDetail) {
                for (MutableComponent text : this.descriptions) {
                    width = Math.max(width, textRenderer.m_92852_((FormattedText)text));
                }
            }
            return width;
        }

        public int getHeight(boolean includeDetail) {
            return 10 + (includeDetail ? this.descriptions.size() * 10 : 0);
        }
    }
}

