/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.component.StandaloneComponent;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntityViewerComponent
extends StandaloneComponent
implements RenderHelper {
    public static final Map<MobBucketItem, Supplier<? extends EntityType<?>>> ENTITY_BUCKET_MAP = new HashMap();
    private static final float ROTATION_INCREMENT = 0.2f;
    private static float CURRENT_ROTATION = 0.0f;
    private static final int ENTITY_OFFSET = 40;

    public EntityViewerComponent(ItemStack stack) {
        super(stack);
    }

    @Override
    public void render(GuiGraphics context, Font textRenderer, int x, int y, int z) {
        CURRENT_ROTATION = (CURRENT_ROTATION + 0.2f) % 360.0f;
        Item item = this.stack.m_41720_();
        if (item instanceof MobBucketItem) {
            MobBucketItem bucketItem = (MobBucketItem)item;
            if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.bucketTooltip.getValue()).booleanValue()) {
                this.renderBucketEntity(context, x, y, z, bucketItem);
            }
        } else {
            item = this.stack.m_41720_();
            if (item instanceof SpawnEggItem) {
                SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.spawnEggTooltip.getValue()).booleanValue()) {
                    this.renderSpawnEggEntity(context, x, y, z, spawnEggItem);
                }
            }
        }
    }

    private void renderBucketEntity(GuiGraphics context, int x, int y, int z, MobBucketItem bucketItem) {
        if (!ENTITY_BUCKET_MAP.containsKey(bucketItem)) {
            return;
        }
        EntityType<?> entityType = ENTITY_BUCKET_MAP.get(bucketItem).get();
        Entity entity = entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                CompoundTag nbtComponent = this.stack.m_41784_();
                bucketable.m_142278_(nbtComponent);
                if (entityType == EntityType.f_20489_) {
                    return;
                }
                if (bucketable instanceof Pufferfish) {
                    Pufferfish pufferfishEntity = (Pufferfish)bucketable;
                    pufferfishEntity.m_29618_(2);
                }
                this.renderBackground(context, x - 40 - 70, y, 80, 40, z);
                livingEntity.m_8119_();
                this.drawEntity(context, x - 67, y + 40, 30, -CURRENT_ROTATION, livingEntity);
            }
        }
    }

    private void renderSpawnEggEntity(GuiGraphics context, int x, int y, int z, SpawnEggItem spawnEggItem) {
        CompoundTag nbt;
        EntityType entityType = spawnEggItem.m_43228_(this.stack.m_41783_());
        Entity entity = entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        if (entity == null) {
            return;
        }
        if (entityType == EntityType.f_20492_ || entityType == EntityType.f_20530_) {
            CompoundTag villagerData = new CompoundTag();
            villagerData.m_128359_("profession", "minecraft:none");
            villagerData.m_128359_("type", "minecraft:plains");
            nbt = new CompoundTag();
            nbt.m_128365_("VillagerData", (Tag)villagerData);
            entity.m_20258_(nbt);
        }
        if (entityType == EntityType.f_20489_) {
            return;
        }
        if (entity instanceof Pufferfish) {
            Pufferfish pufferfishEntity = (Pufferfish)entity;
            pufferfishEntity.m_29618_(2);
        }
        if (entity instanceof SnowGolem) {
            SnowGolem snowGolemEntity = (SnowGolem)entity;
            snowGolemEntity.m_29936_(false);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            nbt = this.stack.m_41737_("EntityTag");
            if (nbt != null) {
                livingEntity.m_7378_(nbt);
            }
            this.renderBackground(context, x - 40 - 70, y, 80, 80, z);
            livingEntity.m_8119_();
            this.drawEntity(context, x - 67, y + 75, 40, -CURRENT_ROTATION, livingEntity);
        }
    }
}

