/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.component.DurabilityComponent;
import com.iafenvoy.tooltipsreforged.component.EnchantmentsComponent;
import com.iafenvoy.tooltipsreforged.component.HeaderComponent;
import com.iafenvoy.tooltipsreforged.component.StandaloneComponent;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.render.TooltipsRenderHelper;
import com.iafenvoy.tooltipsreforged.util.ExtendedTextVisitor;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EquipmentCompareComponent
extends StandaloneComponent {
    private final List<ClientTooltipComponent> components = new LinkedList<ClientTooltipComponent>();
    private final ItemStack equipped;

    public EquipmentCompareComponent(ItemStack stack) {
        super(stack);
        Item item;
        if (!((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.equipmentCompareTooltip.getValue()).booleanValue() || !((item = this.stack.m_41720_()) instanceof Equipable)) {
            this.equipped = ItemStack.f_41583_;
            return;
        }
        Equipable equipment = (Equipable)item;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        assert (player != null);
        this.equipped = player.m_6844_(equipment.m_40402_());
        if (this.equipped.m_41619_() || ItemStack.m_150942_((ItemStack)this.equipped, (ItemStack)this.stack)) {
            return;
        }
        for (Component text : this.equipped.m_41651_((Player)player, (TooltipFlag)TooltipFlag.f_256752_)) {
            if (((Boolean)TooltipReforgedConfig.INSTANCE.misc.removeEmptyLines.getValue()).booleanValue() && ExtendedTextVisitor.getText(text.m_7532_()).getString().isEmpty()) continue;
            this.components.add((ClientTooltipComponent)new ClientTextTooltip(text.m_7532_()));
        }
        if (!this.components.isEmpty()) {
            this.components.remove(0);
        }
        LinkedList<Object> headers = new LinkedList<Object>();
        headers.add(new ClientTextTooltip(Component.m_237115_((String)"tooltip.tooltips_reforged.currently_equipped").m_7532_()));
        headers.add(new HeaderComponent(this.equipped));
        if (this.equipped.m_41720_().m_8120_(this.equipped)) {
            headers.add(new EnchantmentsComponent(EnchantmentHelper.m_44831_((ItemStack)this.equipped)));
        }
        this.components.addAll(0, headers);
        this.components.add(new DurabilityComponent(this.equipped));
    }

    @Override
    public void render(GuiGraphics context, Font textRenderer, int x, int y, int z) {
        if (this.components.isEmpty()) {
            return;
        }
        TooltipsRenderHelper.ResolveResult result = TooltipsRenderHelper.resolveTooltips(textRenderer, this.components);
        if (result.pages().isEmpty()) {
            return;
        }
        TooltipsRenderHelper.Page page = result.pages().get(0);
        int height = page.getHeight();
        TooltipsRenderHelper.drawWithResult(result, this.equipped, context, textRenderer, x, y - height - 20);
    }
}

