/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.component.StandaloneComponent;
import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.ArmorRenderMode;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EquipmentViewerComponent
extends StandaloneComponent
implements RenderHelper {
    private static final float ROTATION_INCREMENT = 0.2f;
    private static float CURRENT_ROTATION = 0.0f;
    private static final int ENTITY_OFFSET = 40;

    public EquipmentViewerComponent(ItemStack stack) {
        super(stack);
    }

    @Override
    public void render(GuiGraphics context, Font textRenderer, int x, int y, int z) {
        CURRENT_ROTATION = (CURRENT_ROTATION + 0.2f) % 360.0f;
        switch ((ArmorRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.armorTooltip.getValue())) {
            case PLAYER: {
                this.renderPlayer(context, x, y, z);
                break;
            }
            case ARMOR_STAND: {
                this.renderArmorStand(context, x, y, z);
            }
        }
    }

    private void renderPlayer(GuiGraphics context, int x, int y, int z) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)this.stack);
        ItemStack original = player.m_6844_(slot);
        player.m_8061_(slot, this.stack);
        this.renderBackground(context, x - 40 - 25, y, 40, 70, z);
        this.drawEntity(context, x - 45, y + 65, 35, -CURRENT_ROTATION, (LivingEntity)player);
        player.m_8061_(slot, original);
    }

    private void renderArmorStand(GuiGraphics context, int x, int y, int z) {
        ArmorStand armorStand = new ArmorStand(EntityType.f_20529_, (Level)Minecraft.m_91087_().f_91073_);
        armorStand.m_8061_(LivingEntity.m_147233_((ItemStack)this.stack), this.stack);
        this.renderBackground(context, x - 40 - 25, y, 40, 70, z);
        armorStand.m_8119_();
        this.drawEntity(context, x - 45, y + 65, 35, -CURRENT_ROTATION, (LivingEntity)armorStand);
    }
}

