/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.EffectsRenderMode;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FoodEffectComponent
implements ClientTooltipComponent {
    protected final ItemStack stack;
    private final EffectsRenderMode effectsMode;

    public FoodEffectComponent(ItemStack stack) {
        this.stack = stack;
        this.effectsMode = (EffectsRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.effectsTooltip.getValue());
    }

    public FoodProperties getFoodComponent() {
        return this.stack.m_41720_().m_41473_();
    }

    public int getHunger() {
        return this.getFoodComponent().m_38744_();
    }

    public int getSaturation() {
        FoodProperties foodComponent = this.getFoodComponent();
        int saturation = 0;
        if (foodComponent != null) {
            saturation = (int)(foodComponent.m_38745_() * 100.0f);
        }
        return saturation;
    }

    public int m_142103_() {
        int height = 0;
        FoodProperties foodComponent = this.getFoodComponent();
        if (foodComponent != null) {
            if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.hungerTooltip.getValue()).booleanValue() && foodComponent.m_38744_() > 0) {
                height += 10;
            }
            if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.saturationTooltip.getValue()).booleanValue() && foodComponent.m_38745_() > 0.0f) {
                height += 10;
            }
            if (this.effectsMode.shouldRender()) {
                height += foodComponent.m_38749_().size() * 10;
            }
        }
        return height;
    }

    public int m_142069_(Font textRenderer) {
        int effectsWidth = 0;
        int hungerLine = 0;
        int saturationLine = 0;
        FoodProperties foodComponent = this.getFoodComponent();
        int hunger = this.getHunger();
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.hungerTooltip.getValue()).booleanValue() && foodComponent.m_38744_() > 0) {
            int n = textRenderer.m_92852_((FormattedText)Component.m_237115_((String)"tooltip.%s.hunger".formatted("tooltips_reforged"))) + 1;
            Objects.requireNonNull(textRenderer);
            hungerLine = n + (9 - 2) * hunger;
        }
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.saturationTooltip.getValue()).booleanValue() && foodComponent.m_38745_() > 0.0f) {
            saturationLine = textRenderer.m_92852_((FormattedText)Component.m_237110_((String)"tooltip.%s.saturation".formatted("tooltips_reforged"), (Object[])new Object[]{"100%"}));
        }
        int foodWidth = Math.max(hungerLine, saturationLine);
        if (!this.effectsMode.shouldRender()) {
            return foodWidth + 4;
        }
        if (foodComponent == null) {
            return 0;
        }
        for (Pair effect : foodComponent.m_38749_()) {
            MobEffectInstance statusEffect = (MobEffectInstance)effect.getFirst();
            Object text = Component.m_237115_((String)statusEffect.m_19576_()).getString();
            if (statusEffect.m_19564_() > 0) {
                text = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{text, Component.m_237115_((String)("potion.potency." + statusEffect.m_19564_())).getString()}).getString();
            }
            if (!statusEffect.m_267633_(20)) {
                text = (String)text + " " + TextUtil.getDurationText(statusEffect, 1.0f).getString();
            }
            effectsWidth = Math.max(effectsWidth, textRenderer.m_92895_((String)text) + 14);
        }
        return Math.max(foodWidth, effectsWidth) + 4;
    }

    public void m_183452_(Font textRenderer, int x, int y, GuiGraphics context) {
        FoodProperties foodComponent = this.getFoodComponent();
        if (foodComponent == null) {
            return;
        }
        int hunger = this.getHunger();
        MutableComponent hungerText = Component.m_237115_((String)"tooltip.%s.hunger".formatted("tooltips_reforged"));
        MutableComponent saturationText = Component.m_237110_((String)"tooltip.%s.saturation".formatted("tooltips_reforged"), (Object[])new Object[]{this.getSaturation()});
        int lineY = y;
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.hungerTooltip.getValue()).booleanValue() && foodComponent.m_38744_() > 0) {
            context.m_280614_(textRenderer, (Component)hungerText, x, lineY, -1, true);
            float fullHungers = (float)hunger / 2.0f;
            boolean hasHalfHunger = hunger % 2 != 0;
            int hungerWidth = textRenderer.m_92852_((FormattedText)hungerText) + 1;
            for (int i = 0; i < (int)fullHungers; ++i) {
                ResourceLocation resourceLocation = new ResourceLocation("textures/gui/icons.png");
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.m_280163_(resourceLocation, x + hungerWidth, lineY, 52.0f, 27.0f, 9, 9, 256, 256);
                Objects.requireNonNull(textRenderer);
                hungerWidth += 9 - 2;
            }
            if (hasHalfHunger) {
                ResourceLocation resourceLocation = new ResourceLocation("textures/gui/icons.png");
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.m_280163_(resourceLocation, x + hungerWidth, lineY, 61.0f, 27.0f, 9, 9, 256, 256);
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.saturationTooltip.getValue()).booleanValue() && foodComponent.m_38745_() > 0.0f) {
            context.m_280614_(textRenderer, (Component)saturationText, x, lineY, -16711681, true);
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
        if (!this.effectsMode.shouldRender()) {
            return;
        }
        for (Pair effect : foodComponent.m_38749_()) {
            MobEffectInstance statusEffect = (MobEffectInstance)effect.getFirst();
            int c = statusEffect.m_19544_().m_19484_();
            TextureAtlasSprite effectTexture = Minecraft.m_91087_().m_91306_().m_118732_(statusEffect.m_19544_());
            if (c == 0) {
                c = -11250436;
            }
            String effectName = Component.m_237115_((String)statusEffect.m_19576_()).getString();
            if (statusEffect.m_19564_() > 0) {
                effectName = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{effectName, Component.m_237115_((String)("potion.potency." + statusEffect.m_19564_())).getString()}).getString();
            }
            Object fullText = effectName;
            if (!statusEffect.m_267633_(20)) {
                fullText = (String)fullText + " (" + TextUtil.getDurationText(statusEffect, 1.0f).getString() + ")";
            }
            MutableComponent renderText = Component.m_237113_((String)fullText);
            if (this.effectsMode.shouldRenderIcon()) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.m_280159_(x - 1, lineY - 1, 0, 9, 9, effectTexture);
                Objects.requireNonNull(textRenderer);
                context.m_280614_(textRenderer, (Component)renderText, x + 9 + 2, lineY, c, true);
            } else {
                context.m_280614_(textRenderer, (Component)renderText, x, lineY, c, true);
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
    }
}

