/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.ItemDisplayMode;
import com.iafenvoy.tooltipsreforged.render.RenderHelper;
import com.iafenvoy.tooltipsreforged.render.TooltipProviders;
import com.iafenvoy.tooltipsreforged.util.BadgesUtils;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class HeaderComponent
implements ClientTooltipComponent,
RenderHelper {
    protected final ItemStack stack;
    private final ItemDisplayMode itemDisplayMode;
    private final FormattedCharSequence nameText;
    private final FormattedCharSequence rarityName;
    private final Pair<Component, Integer> badgePair;

    public HeaderComponent(ItemStack stack) {
        this.stack = stack;
        this.itemDisplayMode = (ItemDisplayMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.itemDisplayTooltip.getValue());
        this.nameText = TooltipProviders.getDisplayName(this.stack).m_7532_();
        this.rarityName = TooltipProviders.getRarityName(this.stack).m_7532_();
        this.badgePair = BadgesUtils.getBadgeText(this.stack);
    }

    public int m_142103_() {
        return 24;
    }

    public int m_142069_(Font textRenderer) {
        Component badgeText = (Component)this.badgePair.getFirst();
        int rarityWidth = (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.rarityTooltip.getValue() != false ? textRenderer.m_92724_(this.rarityName) : 0;
        int badgeWidth = (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.itemGroupTooltip.getValue() != false ? textRenderer.m_92852_((FormattedText)badgeText) + 8 : 0;
        int titleWidth = (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.rarityTooltip.getValue() != false ? textRenderer.m_92724_(this.nameText) + badgeWidth + 2 : Math.max(textRenderer.m_92724_(this.nameText), badgeWidth);
        return Math.max(titleWidth, rarityWidth) + this.getTitleOffset();
    }

    public int getTitleOffset() {
        return this.itemDisplayMode.shouldRenderHeader() ? 24 : 0;
    }

    public void m_142440_(Font textRenderer, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource vertexConsumers) {
        float startDrawX = (float)x + (float)this.getTitleOffset();
        float startDrawY = y + 1;
        textRenderer.m_272191_(this.nameText, startDrawX, startDrawY - 1.0f, -1, true, matrix, (MultiBufferSource)vertexConsumers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.rarityTooltip.getValue()).booleanValue()) {
            Objects.requireNonNull(textRenderer);
            textRenderer.m_272191_(this.rarityName, startDrawX, startDrawY += (float)(9 + 2), -1, true, matrix, (MultiBufferSource)vertexConsumers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public void m_183452_(Font textRenderer, int x, int y, GuiGraphics context) {
        int startDrawX = x + 2;
        int startDrawY = y + 2;
        if (this.itemDisplayMode.shouldRenderHeader()) {
            context.m_280480_(this.stack, startDrawX, startDrawY);
            int color = (Integer)TooltipReforgedConfig.INSTANCE.misc.itemBorderColor.getValue();
            context.m_280046_(startDrawX - 3, startDrawY - 2, startDrawX - 3 + 1, startDrawY - 2 + 20, 0, color);
            context.m_280046_(startDrawX + 18, startDrawY - 2, startDrawX + 18 + 1, startDrawY - 2 + 20, 0, color);
            context.m_280046_(startDrawX - 2, startDrawY - 3, startDrawX - 2 + 20, startDrawY - 3 + 1, 0, color);
            context.m_280046_(startDrawX - 2, startDrawY + 18, startDrawX - 2 + 20, startDrawY + 18 + 1, 0, color);
        }
        if (((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.itemGroupTooltip.getValue()).booleanValue()) {
            Component text = (Component)this.badgePair.getFirst();
            int fillColor = (Integer)this.badgePair.getSecond();
            int textWidth = textRenderer.m_92852_((FormattedText)text);
            Objects.requireNonNull(textRenderer);
            int textHeight = 9 - 2;
            int textX = x + this.getTitleOffset() + ((Boolean)TooltipReforgedConfig.INSTANCE.tooltip.rarityTooltip.getValue() != false ? textRenderer.m_92724_(this.nameText) + 4 + 2 : 4);
            int n = (Boolean)TooltipReforgedConfig.INSTANCE.tooltip.rarityTooltip.getValue() != false ? y - 2 : y - 2 + 12;
            Objects.requireNonNull(textRenderer);
            int textY = n - 9 + 8 + 4;
            context.m_280509_(textX - 4, textY - 2, textX + textWidth + 4, textY + textHeight, BadgesUtils.darkenColor(fillColor, 0.9f));
            context.m_280614_(textRenderer, text, textX, textY - 1, -1, true);
            BadgesUtils.drawFrame(context, textX - 4, textY - 2, textWidth + 8, textHeight + 4, 400, BadgesUtils.darkenColor(fillColor, 0.8f));
        }
    }
}

