/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.component;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.config.mode.EffectsRenderMode;
import com.iafenvoy.tooltipsreforged.util.TextUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PotionEffectsComponent
implements ClientTooltipComponent {
    private final float durationMultiplier;
    private final List<MobEffectInstance> effects;
    private final EffectsRenderMode effectsMode;

    public PotionEffectsComponent(ItemStack stack, float durationMultiplier) {
        this.durationMultiplier = durationMultiplier;
        this.effects = PotionUtils.m_43547_((ItemStack)stack);
        this.effectsMode = (EffectsRenderMode)((Object)TooltipReforgedConfig.INSTANCE.tooltip.effectsTooltip.getValue());
    }

    public int m_142103_() {
        return this.effects.size() * 10;
    }

    public int m_142069_(Font textRenderer) {
        int effectsWidth = 0;
        for (MobEffectInstance effect : this.effects) {
            Object text = Component.m_237115_((String)effect.m_19576_()).getString();
            if (effect.m_19564_() > 0) {
                text = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{text, Component.m_237115_((String)("potion.potency." + effect.m_19564_())).getString()}).getString();
            }
            if (!effect.m_267633_(20)) {
                text = (String)text + " " + TextUtil.getDurationText(effect, this.durationMultiplier).getString();
            }
            effectsWidth = Math.max(effectsWidth, textRenderer.m_92895_((String)text) + 14);
        }
        return effectsWidth + 4;
    }

    public void m_183452_(Font textRenderer, int x, int y, GuiGraphics context) {
        if (!this.effectsMode.shouldRender()) {
            return;
        }
        Objects.requireNonNull(textRenderer);
        int lineY = y - 9 - 1;
        for (MobEffectInstance effect : this.effects) {
            int c = effect.m_19544_().m_19484_();
            if (c == 0) {
                c = -11250436;
            }
            TextureAtlasSprite effectTexture = Minecraft.m_91087_().m_91306_().m_118732_(effect.m_19544_());
            MutableComponent mutableText = Component.m_237115_((String)effect.m_19576_());
            if (effect.m_19564_() > 0) {
                mutableText = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, Component.m_237115_((String)("potion.potency." + effect.m_19564_()))});
            }
            if (!effect.m_267633_(20)) {
                String durationText = TextUtil.getDurationText(effect, this.durationMultiplier).getString();
                mutableText = Component.m_237113_((String)(mutableText.getString() + " (" + durationText + ")"));
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
            if (this.effectsMode.shouldRenderIcon()) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.m_280159_(x - 1, lineY - 1, 0, 9, 9, effectTexture);
                Objects.requireNonNull(textRenderer);
                context.m_280614_(textRenderer, (Component)mutableText, x + 9 + 2, lineY, c, true);
                continue;
            }
            context.m_280614_(textRenderer, (Component)mutableText, x, lineY, c, true);
        }
    }
}

