/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.tooltipsreforged.render;

import com.iafenvoy.tooltipsreforged.config.TooltipReforgedConfig;
import com.iafenvoy.tooltipsreforged.render.TooltipProviders;
import com.iafenvoy.tooltipsreforged.render.TooltipsRenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ExtendedTooltipBackgroundRenderer {
    private static final ResourceLocation DEFAULT_BACKGROUND_TEXTURE = ResourceLocation.m_214293_((String)"minecraft", (String)"textures/gui/sprites/tooltip/background.png");
    private static final ResourceLocation DEFAULT_FRAME_TEXTURE = ResourceLocation.m_214293_((String)"minecraft", (String)"textures/gui/sprites/tooltip/frame.png");

    public static void render(ItemStack stack, GuiGraphics context, int x, int y, int width, int height, int z) {
        ResourceLocation texture = stack.m_41783_() != null ? ResourceLocation.m_135820_((String)stack.m_41783_().m_128461_("tooltip_style")) : null;
        int i = x - 4;
        int j = y - 4;
        int k = width + 8;
        int l = height + 8;
        context.m_280168_().m_85836_();
        int bgColor = (Integer)TooltipReforgedConfig.INSTANCE.misc.backgroundColor.getValue();
        if (((Boolean)TooltipReforgedConfig.INSTANCE.misc.useImageBackground.getValue()).booleanValue()) {
            context.m_280168_().m_252880_(0.0f, 0.0f, (float)z);
            TooltipsRenderHelper.drawNineSlicedTexture(context, ExtendedTooltipBackgroundRenderer.getBackgroundTexture(texture), i - 9, j - 9, k + 18, l + 18, 10, 100, 100);
        } else {
            context.m_280046_(i, j - 1, i + k, j, z, bgColor);
            context.m_280046_(i, j + l, i + k, j + l + 1, z, bgColor);
            context.m_280046_(i, j, i + k, j + l, z, ((Integer)TooltipReforgedConfig.INSTANCE.misc.backgroundColor.getValue()).intValue());
            context.m_280120_(i - 1, j, i, j + l, z, bgColor, bgColor);
            context.m_280120_(i + k, j, i + k + 1, j + l, z, bgColor, bgColor);
        }
        int stackColor = TooltipProviders.getItemBorderColor(stack);
        int startColor = 0xFF000000 | stackColor;
        if (stackColor == -1 || stackColor == 0) {
            startColor = (Integer)TooltipReforgedConfig.INSTANCE.misc.commonRarityColor.getValue();
        }
        int endColor = (Integer)TooltipReforgedConfig.INSTANCE.misc.endColor.getValue();
        if (((Boolean)TooltipReforgedConfig.INSTANCE.misc.useImageBorder.getValue()).booleanValue()) {
            TooltipsRenderHelper.drawNineSlicedTexture(context, ExtendedTooltipBackgroundRenderer.getFrameTexture(texture), i - 10, j - 10, k + 20, l + 20, 10, 100, 100);
        } else {
            context.m_280120_(i, j + 1, i + 1, j + l - 1, z, startColor, endColor);
            context.m_280120_(i + k - 1, j + 1, i + k, j + l - 1, z, startColor, endColor);
            context.m_280046_(i, j, i + k, j + 1, z, startColor);
            context.m_280046_(i, j + l - 1, i + k, j + l, z, endColor);
        }
        context.m_280168_().m_85849_();
    }

    protected static ResourceLocation getBackgroundTexture(@Nullable ResourceLocation texture) {
        return texture == null || texture.m_135815_().isEmpty() ? DEFAULT_BACKGROUND_TEXTURE : texture.m_247266_(name -> "textures/gui/sprites/tooltip/" + name + "_background.png");
    }

    protected static ResourceLocation getFrameTexture(@Nullable ResourceLocation texture) {
        return texture == null || texture.m_135815_().isEmpty() ? DEFAULT_FRAME_TEXTURE : texture.m_247266_(name -> "textures/gui/sprites/tooltip/" + name + "_frame.png");
    }
}

